/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.octostudios.reliquified_lenders_cataclysm.utils.relics;

import com.github.L_Ender.cataclysm.entity.projectile.Void_Rune_Entity;
import it.hurts.octostudios.reliquified_lenders_cataclysm.entities.ScreenShakeSoundedEntity;
import it.hurts.octostudios.reliquified_lenders_cataclysm.items.relics.back.VoidCloakItem;
import it.hurts.octostudios.reliquified_lenders_cataclysm.utils.ItemUtils;
import it.hurts.sskirillss.relics.utils.EntityUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;

public class VoidCloakUtils {
    private static final int waveTicks = 30;

    public static void spawnVoidRune(Level level, Player player, LivingEntity entity, ItemStack stack) {
        Vec3 mobMovement = entity.getDeltaMovement();
        if (EntityUtils.isAlliedTo((Entity)player, (Entity)entity)) {
            return;
        }
        VoidCloakUtils.spawnFang(level, (LivingEntity)player, entity, entity.getX() + mobMovement.x, entity.getZ() + mobMovement.z, 0.0f, -20, VoidCloakUtils.getRuneDamageStat(stack));
    }

    public static void spawnSeismicZone(Level level, Player player, LivingEntity dyingEntity, ItemStack stack) {
        int wavesNum = ItemUtils.getIntStat(stack, "seismic_zone", "waves");
        int layersSpawned = 0;
        for (int i = 0; i < wavesNum; ++i) {
            layersSpawned = VoidCloakUtils.spawnQuakeWave(player, dyingEntity, stack, i);
        }
        if (layersSpawned > 0) {
            level.addFreshEntity((Entity)new ScreenShakeSoundedEntity(level, dyingEntity.position(), VoidCloakUtils.getRadiusStat(stack), layersSpawned, wavesNum, 40));
        }
    }

    private static int spawnQuakeWave(Player player, LivingEntity dyingEntity, ItemStack stack, int waveIndex) {
        Level level = player.getCommandSenderWorld();
        Vec3 pos = dyingEntity.position();
        float shift = 1.25f;
        float shiftMultiplier = 2.5f;
        int delayTicks = 3;
        int layersSpawned = 0;
        for (int r = 0; r < VoidCloakUtils.getRadiusStat(stack); ++r) {
            int fangsNum = 6;
            boolean fangSpawned = false;
            for (int i = 0; i < fangsNum; ++i) {
                float angle = (float)((double)i * Math.PI * 2.0 / (double)fangsNum + (double)shift);
                if (!VoidCloakUtils.spawnFang(level, (LivingEntity)player, dyingEntity, pos.x + (double)Mth.cos((float)angle) * (double)shiftMultiplier, pos.z + (double)Mth.sin((float)angle) * (double)shiftMultiplier, i, waveIndex * VoidCloakUtils.getWaveTicks() + delayTicks, VoidCloakUtils.getZoneDamageStat(stack))) continue;
                fangSpawned = true;
            }
            shift -= shiftMultiplier;
            shiftMultiplier += 1.0f;
            delayTicks += 2;
            if (!fangSpawned) continue;
            ++layersSpawned;
        }
        return layersSpawned;
    }

    public static boolean spawnFang(Level level, LivingEntity caster, LivingEntity entity, double posX, double posZ, float yRot, int delayTicks, float damage, boolean silent) {
        BlockPos pos = BlockPos.containing((double)posX, (double)(entity.getY() + 1.0), (double)posZ);
        double shiftY = 0.0;
        boolean canFangSpawn = false;
        do {
            BlockState blockState;
            VoxelShape collisionShape;
            BlockPos posBelow;
            BlockState blockStateBelow;
            if (!(blockStateBelow = level.getBlockState(posBelow = pos.below())).isFaceSturdy((BlockGetter)level, posBelow, Direction.UP)) continue;
            if (!level.isEmptyBlock(pos) && !(collisionShape = (blockState = level.getBlockState(pos)).getCollisionShape((BlockGetter)level, pos)).isEmpty()) {
                shiftY = collisionShape.max(Direction.Axis.Y);
            }
            canFangSpawn = true;
            break;
        } while ((double)(pos = pos.below()).getY() >= Math.floor(entity.getY() - 1.0));
        if (canFangSpawn) {
            Void_Rune_Entity voidRuneEntity = new Void_Rune_Entity(level, posX, (double)pos.getY() + shiftY, posZ, yRot, delayTicks, damage, caster);
            voidRuneEntity.setSilent(silent);
            voidRuneEntity.setCaster(caster);
            level.addFreshEntity((Entity)voidRuneEntity);
        }
        return canFangSpawn;
    }

    public static boolean spawnFang(Level level, LivingEntity caster, LivingEntity entity, double posX, double posZ, float yRot, int delayTicks, float damage) {
        return VoidCloakUtils.spawnFang(level, caster, entity, posX, posZ, yRot, delayTicks, damage, false);
    }

    private static float getRuneDamageStat(ItemStack stack) {
        return (float)((VoidCloakItem)stack.getItem()).getStatValue(stack, "void_rune", "damage");
    }

    private static float getZoneDamageStat(ItemStack stack) {
        return (float)((VoidCloakItem)stack.getItem()).getStatValue(stack, "seismic_zone", "damage");
    }

    public static int getRadiusStat(ItemStack stack) {
        return ItemUtils.getIntStat(stack, "seismic_zone", "radius");
    }

    public static int getWaveTicks() {
        return 30;
    }
}

