/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsbase.modules.informationscreen.client;

import com.mojang.blaze3d.vertex.PoseStack;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import mcjty.lib.client.HudRenderHelper;
import mcjty.lib.typed.TypedMap;
import mcjty.rftoolsbase.modules.informationscreen.blocks.DefaultPowerInformationScreenInfo;
import net.minecraft.ChatFormatting;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.core.Direction;

public class DefaultPowerInformationRenderer {
    private static final DecimalFormat format = new DecimalFormat("#.###");

    public static void renderGraphical(PoseStack matrixStack, MultiBufferSource buffer, TypedMap data, Direction orientation, double scale) {
        if (data == null || data.size() == 0) {
            return;
        }
        long energy = data.getOptional(DefaultPowerInformationScreenInfo.ENERGY).orElse(0L);
        long maxEnergy = data.getOptional(DefaultPowerInformationScreenInfo.MAXENERGY).orElse(0L);
    }

    public static void renderDefault(PoseStack matrixStack, MultiBufferSource buffer, TypedMap data, Direction orientation, double scale) {
        List<String> log = DefaultPowerInformationRenderer.getLog(data);
        HudRenderHelper.HudPlacement hudPlacement = HudRenderHelper.HudPlacement.HUD_FRONT;
        HudRenderHelper.HudOrientation hudOrientation = HudRenderHelper.HudOrientation.HUD_SOUTH;
        HudRenderHelper.renderHud((PoseStack)matrixStack, (MultiBufferSource)buffer, log, (HudRenderHelper.HudPlacement)hudPlacement, (HudRenderHelper.HudOrientation)hudOrientation, (Direction)orientation, (double)((double)(-orientation.getStepX()) * 0.95), (double)0.0, (double)((double)(-orientation.getStepZ()) * 0.95), (float)((float)(1.0 + scale)));
    }

    private static List<String> getLog(TypedMap data) {
        ArrayList<String> list = new ArrayList<String>();
        list.add("");
        if (data != null && data.size() > 0) {
            long energy = data.getOptional(DefaultPowerInformationScreenInfo.ENERGY).orElse(0L);
            long maxEnergy = data.getOptional(DefaultPowerInformationScreenInfo.MAXENERGY).orElse(0L);
            list.add(String.valueOf(ChatFormatting.BLUE) + " RF: " + String.valueOf(ChatFormatting.WHITE) + DefaultPowerInformationRenderer.formatPower(energy));
            list.add(String.valueOf(ChatFormatting.BLUE) + " Max: " + String.valueOf(ChatFormatting.WHITE) + DefaultPowerInformationRenderer.formatPower(maxEnergy));
        } else {
            list.add(String.valueOf(ChatFormatting.RED) + " Not a powercell");
            list.add(String.valueOf(ChatFormatting.RED) + " or anything that");
            list.add(String.valueOf(ChatFormatting.RED) + " supports power");
        }
        return list;
    }

    public static String formatPower(long l) {
        if (l < 100000L) {
            return Long.toString(l);
        }
        if (l < 10000000L) {
            Double d = (double)l / 1000.0;
            return format.format(d) + "K";
        }
        if (l < 10000000000L) {
            Double d = (double)l / 1000000.0;
            return format.format(d) + "M";
        }
        Double d = (double)l / 1.0E9;
        return format.format(d) + "G";
    }

    public static float getHudAngle(Direction orientation) {
        float f3 = 0.0f;
        if (orientation != null) {
            f3 = switch (orientation) {
                case Direction.NORTH -> 180.0f;
                case Direction.WEST -> 90.0f;
                case Direction.EAST -> -90.0f;
                default -> 0.0f;
            };
        }
        return f3;
    }

    public static int getPercentageColor(int i) {
        int col = i < 30 ? -16711936 : (i < 40 ? -14492416 : (i < 50 ? -12272896 : (i < 60 ? -10053376 : (i < 70 ? -7833856 : (i < 80 ? -5614336 : (i < 90 ? -3394816 : -1175296))))));
        return col;
    }
}

