/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsutility.modules.crafter.blocks;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import mcjty.lib.api.container.DefaultContainerProvider;
import mcjty.lib.api.container.ItemInventory;
import mcjty.lib.api.infusable.DefaultInfusable;
import mcjty.lib.api.infusable.IInfusable;
import mcjty.lib.api.infusable.ItemInfusable;
import mcjty.lib.api.power.ItemEnergy;
import mcjty.lib.bindings.GuiValue;
import mcjty.lib.bindings.Value;
import mcjty.lib.blockcommands.Command;
import mcjty.lib.blockcommands.ServerCommand;
import mcjty.lib.container.ContainerFactory;
import mcjty.lib.container.GenericItemHandler;
import mcjty.lib.container.UndoableItemHandler;
import mcjty.lib.crafting.BaseRecipe;
import mcjty.lib.setup.Registration;
import mcjty.lib.tileentity.Cap;
import mcjty.lib.tileentity.CapType;
import mcjty.lib.tileentity.GenericEnergyStorage;
import mcjty.lib.tileentity.GenericTileEntity;
import mcjty.lib.tileentity.TickingTileEntity;
import mcjty.lib.typed.Type;
import mcjty.lib.varia.Cached;
import mcjty.lib.varia.InventoryTools;
import mcjty.lib.varia.Logging;
import mcjty.lib.varia.NamedEnum;
import mcjty.rftoolsbase.api.compat.JEIRecipeAcceptor;
import mcjty.rftoolsbase.modules.filter.items.FilterModuleItem;
import mcjty.rftoolsutility.modules.crafter.CrafterConfiguration;
import mcjty.rftoolsutility.modules.crafter.CrafterModule;
import mcjty.rftoolsutility.modules.crafter.blocks.CrafterContainer;
import mcjty.rftoolsutility.modules.crafter.data.CraftMode;
import mcjty.rftoolsutility.modules.crafter.data.CrafterData;
import mcjty.rftoolsutility.modules.crafter.data.CraftingRecipe;
import mcjty.rftoolsutility.modules.crafter.data.KeepMode;
import mcjty.rftoolsutility.modules.crafter.data.SpeedMode;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.IItemHandlerModifiable;

public class CrafterBaseTE
extends TickingTileEntity
implements JEIRecipeAcceptor {
    private final int supportedRecipes;
    private final GenericItemHandler items = GenericItemHandler.create((GenericTileEntity)this, CrafterContainer.CONTAINER_FACTORY).itemValid(this::isItemValidForSlot).onUpdate((slot, stack) -> this.clearCacheOrUpdateRecipe((Integer)slot)).build();
    @Cap(type=CapType.ITEMS_AUTOMATION)
    private static final Function<CrafterBaseTE, GenericItemHandler> ITEM_CAP = be -> be.items;
    private final GenericEnergyStorage energyStorage = new GenericEnergyStorage((GenericTileEntity)this, true, (long)((Integer)CrafterConfiguration.MAXENERGY.get()).intValue(), (long)((Integer)CrafterConfiguration.RECEIVEPERTICK.get()).intValue());
    @Cap(type=CapType.ENERGY)
    private static final Function<CrafterBaseTE, GenericEnergyStorage> ENERGY_CAP = be -> be.energyStorage;
    @Cap(type=CapType.CONTAINER)
    private static final Function<CrafterBaseTE, MenuProvider> SCREEN_CAP = be -> new DefaultContainerProvider("Crafter").containerSupplier((windowId, player) -> new CrafterContainer((int)windowId, (ContainerFactory)CrafterContainer.CONTAINER_FACTORY.get(), be.getBlockPos(), (GenericTileEntity)be, (Player)player)).itemHandler(() -> be.items).energyHandler(() -> be.energyStorage).data(CrafterModule.CRAFTER_DATA, CrafterData.STREAM_CODEC, CrafterData.CODEC).setupSync((GenericTileEntity)be);
    private final DefaultInfusable infusable = new DefaultInfusable((BlockEntity)this);
    @Cap(type=CapType.INFUSABLE)
    private static final Function<CrafterBaseTE, IInfusable> INFUSABLE_CAP = be -> be.infusable;
    private final Cached<Predicate<ItemStack>> filterCache = Cached.of(this::createFilterCache);
    @GuiValue
    public static final Value<CrafterBaseTE, String> SPEED_MODE = Value.createEnum((String)"speedMode", (NamedEnum[])SpeedMode.values(), CrafterBaseTE::getSpeedMode, CrafterBaseTE::setSpeedMode);
    private int selected = -1;
    @GuiValue
    public static final Value<CrafterBaseTE, Integer> SELECTED = Value.create((String)"selected", (Type)Type.INTEGER, CrafterBaseTE::getSelected, CrafterBaseTE::setSelected);
    @GuiValue
    public static final Value<CrafterBaseTE, String> CRAFT_MODE = Value.createEnum((String)"craftMode", (NamedEnum[])CraftMode.values(), CrafterBaseTE::getCraftMode, CrafterBaseTE::setCraftMode);
    @GuiValue
    public static final Value<CrafterBaseTE, String> KEEP_ONE = Value.createEnum((String)"keepOne", (NamedEnum[])KeepMode.values(), CrafterBaseTE::getKeepOne, CrafterBaseTE::setKeepOne);
    public boolean noRecipesWork = false;
    private static CraftingInput workInventory = CraftingInput.of((int)3, (int)3, CrafterBaseTE.createList());
    @ServerCommand
    public static final Command<?> CMD_REMEMBER = Command.create((String)"crafter.remember", (te, player, params) -> te.rememberItems());
    @ServerCommand
    public static final Command<?> CMD_FORGET = Command.create((String)"crafter.forget", (te, player, params) -> te.forgetItems());
    @ServerCommand
    public static final Command<?> CMD_APPLY = Command.create((String)"crafter.apply", (te, player, params) -> te.applyRecipe());

    public static CrafterBaseTE createTier1(BlockPos pos, BlockState state) {
        return new CrafterBaseTE((BlockEntityType)CrafterModule.CRAFTER1.be().get(), pos, state, 2);
    }

    public static CrafterBaseTE createTier2(BlockPos pos, BlockState state) {
        return new CrafterBaseTE((BlockEntityType)CrafterModule.CRAFTER2.be().get(), pos, state, 4);
    }

    public static CrafterBaseTE createTier3(BlockPos pos, BlockState state) {
        return new CrafterBaseTE((BlockEntityType)CrafterModule.CRAFTER3.be().get(), pos, state, 8);
    }

    private static List<ItemStack> createList() {
        ArrayList<ItemStack> list = new ArrayList<ItemStack>();
        for (int i = 0; i < 9; ++i) {
            list.add(ItemStack.EMPTY);
        }
        return list;
    }

    private void clearCacheOrUpdateRecipe(Integer slot) {
        this.noRecipesWork = false;
        if (slot == 40) {
            this.filterCache.clear();
        } else if (slot >= 0 && slot < 9) {
            ArrayList<ItemStack> list = new ArrayList<ItemStack>();
            for (int i = 0; i < 9; ++i) {
                list.add(this.items.getStackInSlot(i + 0));
            }
            CraftingInput input = CraftingInput.of((int)3, (int)3, list);
            Recipe recipe = CraftingRecipe.findRecipe(this.level, input);
            if (recipe != null) {
                ItemStack result = BaseRecipe.assemble((Recipe)recipe, (RecipeInput)input, (Level)this.level);
                this.items.setStackInSlot(9, result);
            } else {
                this.items.setStackInSlot(9, ItemStack.EMPTY);
            }
        }
    }

    public CrafterBaseTE(BlockEntityType type, BlockPos pos, BlockState state, int supportedRecipes) {
        super(type, pos, state);
        this.supportedRecipes = supportedRecipes;
        ArrayList<CraftingRecipe> recipes = new ArrayList<CraftingRecipe>(supportedRecipes);
        for (int i = 0; i < supportedRecipes; ++i) {
            recipes.add(new CraftingRecipe());
        }
        this.setData(CrafterModule.CRAFTER_DATA, CrafterData.createDefault().withRecipes(recipes));
    }

    public int getSelected() {
        return this.selected;
    }

    private void setSelected(int sel) {
        if (sel == this.selected) {
            return;
        }
        this.selected = sel < 0 || sel >= this.supportedRecipes ? -1 : sel;
        if (this.selected < 0) {
            for (int i = 0; i < 10; ++i) {
                this.items.setStackInSlot(0 + i, ItemStack.EMPTY);
            }
        } else {
            CrafterData data = (CrafterData)this.getData(CrafterModule.CRAFTER_DATA);
            CraftingRecipe recipe = data.getRecipeSafe(this.selected);
            this.items.setStackInSlot(9, recipe.getResult());
            List<ItemStack> list = recipe.convertTo3x3Grid();
            for (int i = 0; i < 9; ++i) {
                this.items.setStackInSlot(0 + i, list.get(i));
            }
            this.items.setStackInSlot(9, recipe.getResult());
        }
        this.setChanged();
    }

    private void applyRecipe() {
        if (this.selected < 0 || this.selected >= this.supportedRecipes) {
            return;
        }
        CrafterData data = (CrafterData)this.getData(CrafterModule.CRAFTER_DATA);
        CraftingRecipe recipe = data.getRecipeSafe(this.selected).copy();
        ItemStack[] recipeItems = new ItemStack[9];
        for (int i = 0; i < 9; ++i) {
            recipeItems[i] = this.items.getStackInSlot(i + 0).copy();
        }
        recipe.setRecipe(recipeItems, this.items.getStackInSlot(9).copy());
        data = data.setRecipeSafe(this.selected, recipe);
        this.setData(CrafterModule.CRAFTER_DATA, data);
        this.markDirtyClient();
    }

    private CraftMode getCraftMode() {
        if (this.selected < 0 || this.selected >= this.supportedRecipes) {
            return CraftMode.EXT;
        }
        return ((CrafterData)this.getData(CrafterModule.CRAFTER_DATA)).getRecipeSafe(this.selected).getCraftMode();
    }

    private void setCraftMode(CraftMode mode) {
        CrafterData data = (CrafterData)this.getData(CrafterModule.CRAFTER_DATA);
        if (this.selected >= 0 && this.selected < this.supportedRecipes && data.getRecipeSafe(this.selected).getCraftMode() != mode) {
            data.getRecipeSafe(this.selected).setCraftMode(mode);
            this.setData(CrafterModule.CRAFTER_DATA, data);
        }
    }

    private KeepMode getKeepOne() {
        if (this.selected < 0 || this.selected >= this.supportedRecipes) {
            return KeepMode.ALL;
        }
        return ((CrafterData)this.getData(CrafterModule.CRAFTER_DATA)).getRecipeSafe(this.selected).getKeepOne();
    }

    private void setKeepOne(KeepMode keepOne) {
        CrafterData data = (CrafterData)this.getData(CrafterModule.CRAFTER_DATA);
        if (this.selected >= 0 && this.selected < this.supportedRecipes && data.getRecipeSafe(this.selected).getKeepOne() != keepOne) {
            data.getRecipeSafe(this.selected).setKeepOne(keepOne);
            this.setData(CrafterModule.CRAFTER_DATA, data);
        }
    }

    protected boolean needsRedstoneMode() {
        return true;
    }

    public List<ItemStack> getGhostSlots() {
        return ((CrafterData)this.getData(CrafterModule.CRAFTER_DATA)).ghostSlots();
    }

    public void setGridContents(List<ItemStack> stacks) {
        this.items.setStackInSlot(9, stacks.get(0));
        for (int i = 1; i < stacks.size(); ++i) {
            this.items.setStackInSlot(0 + i - 1, stacks.get(i));
        }
        this.setChanged();
    }

    public int getSupportedRecipes() {
        return this.supportedRecipes;
    }

    public SpeedMode getSpeedMode() {
        CrafterData data = (CrafterData)this.getData(CrafterModule.CRAFTER_DATA);
        return data.speedMode();
    }

    public void setSpeedMode(SpeedMode speedMode) {
        CrafterData data = (CrafterData)this.getData(CrafterModule.CRAFTER_DATA);
        data = data.withSpeedMode(speedMode);
        this.setData(CrafterModule.CRAFTER_DATA, data);
        this.markDirtyClient();
    }

    public CraftingRecipe getRecipe(int index) {
        return ((CrafterData)this.getData(CrafterModule.CRAFTER_DATA)).getRecipeSafe(index);
    }

    public Predicate<ItemStack> createFilterCache() {
        return FilterModuleItem.getCache((ItemStack)this.items.getStackInSlot(40));
    }

    protected void tickServer() {
        int i;
        int steps;
        if (!this.isMachineEnabled() || this.noRecipesWork) {
            return;
        }
        int defaultCost = (Integer)CrafterConfiguration.rfPerOperation.get();
        int rf = (int)((float)defaultCost * (2.0f - this.infusable.getInfusedFactor()) / 2.0f);
        CrafterData data = (CrafterData)this.getData(CrafterModule.CRAFTER_DATA);
        int n = steps = data.speedMode() == SpeedMode.FAST ? (Integer)CrafterConfiguration.speedOperations.get() : 1;
        if (rf > 0) {
            steps = (int)Math.min((long)steps, this.energyStorage.getEnergy() / (long)rf);
        }
        for (i = 0; i < steps; ++i) {
            if (this.craftOneCycle()) continue;
            this.noRecipesWork = true;
            break;
        }
        if ((rf *= i) > 0) {
            this.energyStorage.consumeEnergy((long)rf);
        }
    }

    private boolean craftOneCycle() {
        boolean craftedAtLeastOneThing = false;
        CrafterData data = (CrafterData)this.getData(CrafterModule.CRAFTER_DATA);
        for (CraftingRecipe craftingRecipe : data.recipes()) {
            if (!this.craftOneItem(craftingRecipe)) continue;
            craftedAtLeastOneThing = true;
        }
        return craftedAtLeastOneThing;
    }

    private boolean craftOneItem(CraftingRecipe craftingRecipe) {
        Recipe recipe = craftingRecipe.getCachedRecipe(this.level);
        if (recipe == null) {
            return false;
        }
        UndoableItemHandler undoHandler = new UndoableItemHandler((IItemHandlerModifiable)this.items);
        if (!this.testAndConsume(craftingRecipe, undoHandler)) {
            undoHandler.restore();
            return false;
        }
        ItemStack result = ItemStack.EMPTY;
        try {
            result = BaseRecipe.assemble((Recipe)recipe, (RecipeInput)workInventory, (Level)this.level);
        }
        catch (RuntimeException e) {
            Logging.logError((String)"Problem with recipe!", (Throwable)e);
        }
        CraftMode mode = craftingRecipe.getCraftMode();
        if (!result.isEmpty() && this.placeResult(mode, (IItemHandlerModifiable)undoHandler, result)) {
            NonNullList remaining = recipe.getRemainingItems((RecipeInput)workInventory);
            CraftMode remainingMode = mode == CraftMode.EXTC ? CraftMode.INT : mode;
            for (ItemStack s : remaining) {
                if (s.isEmpty() || this.placeResult(remainingMode, (IItemHandlerModifiable)undoHandler, s)) continue;
                undoHandler.restore();
                return false;
            }
            return true;
        }
        undoHandler.restore();
        return false;
    }

    private boolean testAndConsume(CraftingRecipe craftingRecipe, UndoableItemHandler undoHandler) {
        int keep = craftingRecipe.getKeepOne() == KeepMode.KEEP ? 1 : 0;
        Recipe recipe = craftingRecipe.getCachedRecipe(this.level);
        Object ingredients = recipe.getIngredients();
        int w = 3;
        int h = 3;
        if (recipe instanceof ShapedRecipe) {
            w = ((ShapedRecipe)recipe).getWidth();
            h = ((ShapedRecipe)recipe).getHeight();
        } else {
            ingredients = craftingRecipe.convertTo3x3Grid().stream().map(xva$0 -> Ingredient.of((ItemStack[])new ItemStack[]{xva$0})).toList();
        }
        ArrayList<ItemStack> list = new ArrayList<ItemStack>(9);
        for (int i = 0; i < 9; ++i) {
            list.add(ItemStack.EMPTY);
        }
        for (int x = 0; x < w; ++x) {
            block2: for (int y = 0; y < h; ++y) {
                Ingredient ingredient;
                int index = y * w + x;
                if (index >= ingredients.size() || (ingredient = (Ingredient)ingredients.get(index)) == Ingredient.EMPTY) continue;
                for (int j = 0; j < 26; ++j) {
                    int slotIdx = 10 + j;
                    ItemStack input = undoHandler.getStackInSlot(slotIdx);
                    if (input.isEmpty() || input.getCount() <= keep || !ingredient.test(input)) continue;
                    undoHandler.remember(slotIdx);
                    ItemStack copy = input.split(1);
                    list.set(y * 3 + x, copy);
                    continue block2;
                }
            }
        }
        workInventory = CraftingInput.of((int)3, (int)3, list);
        return recipe.matches((RecipeInput)workInventory, this.level);
    }

    private boolean placeResult(CraftMode mode, IItemHandlerModifiable undoHandler, ItemStack result) {
        int stop;
        int start;
        if (mode == CraftMode.INT) {
            start = 10;
            stop = 36;
        } else {
            start = 36;
            stop = 40;
        }
        ItemStack remaining = InventoryTools.insertItemRanged((IItemHandler)undoHandler, (ItemStack)result, (int)start, (int)stop, (boolean)true);
        if (remaining.isEmpty()) {
            InventoryTools.insertItemRanged((IItemHandler)undoHandler, (ItemStack)result, (int)start, (int)stop, (boolean)false);
            return true;
        }
        return false;
    }

    private void rememberItems() {
        CrafterData data = (CrafterData)this.getData(CrafterModule.CRAFTER_DATA);
        ArrayList<ItemStack> ghostSlots = new ArrayList<ItemStack>(data.ghostSlots());
        for (int i = 0; i < ghostSlots.size(); ++i) {
            int slotIdx = i < 26 ? i + 10 : i + 36 - 26;
            if (this.items.getStackInSlot(slotIdx).isEmpty()) continue;
            ItemStack stack = this.items.getStackInSlot(slotIdx).copy();
            stack.setCount(1);
            ghostSlots.set(i, stack);
        }
        this.setData(CrafterModule.CRAFTER_DATA, data.withGhostSlots(ghostSlots));
        this.noRecipesWork = false;
        this.markDirtyClient();
    }

    private void forgetItems() {
        CrafterData data = (CrafterData)this.getData(CrafterModule.CRAFTER_DATA);
        ArrayList<ItemStack> ghostSlots = new ArrayList<ItemStack>(data.ghostSlots());
        for (int i = 0; i < ghostSlots.size(); ++i) {
            ghostSlots.set(i, ItemStack.EMPTY);
        }
        this.setData(CrafterModule.CRAFTER_DATA, data.withGhostSlots(ghostSlots));
        this.noRecipesWork = false;
        this.markDirtyClient();
    }

    public void loadAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        super.loadAdditional(tag, provider);
        this.energyStorage.load(tag, "energy", provider);
        this.items.load(tag, "items", provider);
        this.infusable.load(tag, "infusable");
    }

    public void saveAdditional(@Nonnull CompoundTag tag, HolderLookup.Provider provider) {
        super.saveAdditional(tag, provider);
        this.energyStorage.save(tag, "energy", provider);
        this.items.save(tag, "items", provider);
        this.infusable.save(tag, "infusable");
    }

    protected void applyImplicitComponents(BlockEntity.DataComponentInput input) {
        super.applyImplicitComponents(input);
        CrafterData data = (CrafterData)input.get(CrafterModule.ITEM_CRAFTER_DATA);
        if (data != null) {
            this.setData(CrafterModule.CRAFTER_DATA, data);
        }
        this.energyStorage.applyImplicitComponents((ItemEnergy)input.get((Supplier)Registration.ITEM_ENERGY));
        this.items.applyImplicitComponents((ItemInventory)input.get((Supplier)Registration.ITEM_INVENTORY));
        this.infusable.applyImplicitComponents((ItemInfusable)input.get((Supplier)Registration.ITEM_INFUSABLE));
    }

    protected void collectImplicitComponents(DataComponentMap.Builder builder) {
        super.collectImplicitComponents(builder);
        builder.set(CrafterModule.ITEM_CRAFTER_DATA, (Object)((CrafterData)this.getData(CrafterModule.CRAFTER_DATA)));
        this.energyStorage.collectImplicitComponents(builder);
        this.items.collectImplicitComponents(builder);
        this.infusable.collectImplicitComponents(builder);
    }

    public boolean isItemValidForSlot(int slot, @Nonnull ItemStack stack) {
        if (slot >= 0 && slot <= 9) {
            return false;
        }
        CrafterData data = (CrafterData)this.getData(CrafterModule.CRAFTER_DATA);
        List<ItemStack> ghostSlots = data.ghostSlots();
        if (slot >= 10 && slot < 36) {
            ItemStack ghostSlot = ghostSlots.get(slot - 10);
            if (!ghostSlot.isEmpty() && !ItemStack.isSameItem((ItemStack)ghostSlot, (ItemStack)stack)) {
                return false;
            }
            ItemStack filterModule = this.items.getStackInSlot(40);
            if (!filterModule.isEmpty() && this.filterCache.get() != null) {
                return ((Predicate)this.filterCache.get()).test(stack);
            }
        } else if (slot >= 36 && slot < 40) {
            ItemStack ghostSlot = ghostSlots.get(slot - 36 + 26);
            if (!ghostSlot.isEmpty() && !ItemStack.isSameItem((ItemStack)ghostSlot, (ItemStack)stack)) {
                return false;
            }
        } else if (slot == 40) {
            return stack.getItem() instanceof FilterModuleItem;
        }
        return true;
    }
}

