/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsutility.modules.environmental;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import mcjty.lib.varia.LevelTools;
import mcjty.rftoolsutility.modules.environmental.blocks.EnvironmentalControllerTileEntity;
import mcjty.rftoolsutility.modules.environmental.modules.EnvironmentModule;
import mcjty.rftoolsutility.modules.environmental.modules.NoTeleportEModule;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;

public class NoTeleportAreaManager {
    private static final Map<GlobalPos, NoTeleportArea> areas = new HashMap<GlobalPos, NoTeleportArea>();

    public static void markArea(GlobalPos coordinate, int radius, int miny, int maxy) {
        if (areas.containsKey(coordinate)) {
            areas.get(coordinate).touch().setArea(radius, miny, maxy);
        } else {
            NoTeleportArea area = new NoTeleportArea(radius, miny, maxy);
            areas.put(coordinate, area);
        }
    }

    public static boolean isTeleportPrevented(Entity entity, GlobalPos coordinate) {
        if (areas.isEmpty()) {
            return false;
        }
        ArrayList<GlobalPos> toRemove = new ArrayList<GlobalPos>();
        boolean noTeleport = false;
        long curtime = System.currentTimeMillis() - 10000L;
        for (Map.Entry<GlobalPos, NoTeleportArea> entry : areas.entrySet()) {
            BlockPos c;
            ServerLevel world;
            BlockEntity te;
            GlobalPos entryCoordinate;
            NoTeleportArea area = entry.getValue();
            if (area.in(coordinate, entryCoordinate = entry.getKey()) && (te = (world = LevelTools.getLevel((Level)entity.level(), (ResourceKey)entryCoordinate.dimension())).getBlockEntity(entryCoordinate.pos())) instanceof EnvironmentalControllerTileEntity) {
                EnvironmentalControllerTileEntity controller = (EnvironmentalControllerTileEntity)te;
                noTeleport = controller.isEntityAffected(entity);
            }
            if (area.getLastTouched() >= curtime || (world = LevelTools.getLevel((Level)entity.level(), (ResourceKey)entryCoordinate.dimension())) == null || !LevelTools.isLoaded((Level)world, (BlockPos)(c = entryCoordinate.pos()))) continue;
            boolean removeArea = true;
            BlockEntity te2 = world.getBlockEntity(c);
            if (te2 instanceof EnvironmentalControllerTileEntity) {
                EnvironmentalControllerTileEntity controller = (EnvironmentalControllerTileEntity)te2;
                for (EnvironmentModule module : controller.getEnvironmentModules()) {
                    if (!(module instanceof NoTeleportEModule) || !((NoTeleportEModule)module).isActive()) continue;
                    removeArea = false;
                    break;
                }
            }
            if (!removeArea) continue;
            toRemove.add(entryCoordinate);
        }
        for (GlobalPos globalCoordinate : toRemove) {
            areas.remove(globalCoordinate);
        }
        return noTeleport;
    }

    public static class NoTeleportArea {
        private float sqradius;
        private int miny;
        private int maxy;
        private long lastTouched;

        public NoTeleportArea(float radius, int miny, int maxy) {
            this.sqradius = radius * radius;
            this.miny = miny;
            this.maxy = maxy;
            this.touch();
        }

        public NoTeleportArea setArea(float radius, int miny, int maxy) {
            this.sqradius = radius * radius;
            this.miny = miny;
            this.maxy = maxy;
            return this;
        }

        public String toString() {
            return "NoTeleportArea{sqradius=" + this.sqradius + ", miny=" + this.miny + ", maxy=" + this.maxy + ", lastTouched=" + this.lastTouched + "}";
        }

        public long getLastTouched() {
            return this.lastTouched;
        }

        public NoTeleportArea touch() {
            this.lastTouched = System.currentTimeMillis();
            return this;
        }

        public boolean in(GlobalPos coordinate, GlobalPos thisCoordinate) {
            double pz;
            if (!Objects.equals(coordinate.dimension(), thisCoordinate.dimension())) {
                return false;
            }
            double py = coordinate.pos().getY();
            if (py < (double)this.miny || py > (double)this.maxy) {
                return false;
            }
            double px = coordinate.pos().getX() - thisCoordinate.pos().getX();
            double sqdist = px * px + (pz = (double)(coordinate.pos().getZ() - thisCoordinate.pos().getZ())) * pz;
            return sqdist < (double)this.sqradius;
        }
    }
}

