/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsutility.modules.logic.client;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import mcjty.lib.blocks.LogicSlabBlock;
import mcjty.lib.client.RenderHelper;
import mcjty.lib.varia.LogicFacing;
import mcjty.rftoolsutility.modules.logic.LogicBlockModule;
import mcjty.rftoolsutility.modules.logic.blocks.DigitTileEntity;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderers;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.client.model.generators.ModelBuilder;

public class DigitRenderer
implements BlockEntityRenderer<DigitTileEntity> {
    public static final ResourceLocation[] DIGITS = new ResourceLocation[]{ResourceLocation.fromNamespaceAndPath((String)"rftoolsutility", (String)"block/logic/machineoutput_0"), ResourceLocation.fromNamespaceAndPath((String)"rftoolsutility", (String)"block/logic/machineoutput_1"), ResourceLocation.fromNamespaceAndPath((String)"rftoolsutility", (String)"block/logic/machineoutput_2"), ResourceLocation.fromNamespaceAndPath((String)"rftoolsutility", (String)"block/logic/machineoutput_3"), ResourceLocation.fromNamespaceAndPath((String)"rftoolsutility", (String)"block/logic/machineoutput_4"), ResourceLocation.fromNamespaceAndPath((String)"rftoolsutility", (String)"block/logic/machineoutput_5"), ResourceLocation.fromNamespaceAndPath((String)"rftoolsutility", (String)"block/logic/machineoutput_6"), ResourceLocation.fromNamespaceAndPath((String)"rftoolsutility", (String)"block/logic/machineoutput_7"), ResourceLocation.fromNamespaceAndPath((String)"rftoolsutility", (String)"block/logic/machineoutput_8"), ResourceLocation.fromNamespaceAndPath((String)"rftoolsutility", (String)"block/logic/machineoutput_9"), ResourceLocation.fromNamespaceAndPath((String)"rftoolsutility", (String)"block/logic/machineoutput_a"), ResourceLocation.fromNamespaceAndPath((String)"rftoolsutility", (String)"block/logic/machineoutput_b"), ResourceLocation.fromNamespaceAndPath((String)"rftoolsutility", (String)"block/logic/machineoutput_c"), ResourceLocation.fromNamespaceAndPath((String)"rftoolsutility", (String)"block/logic/machineoutput_d"), ResourceLocation.fromNamespaceAndPath((String)"rftoolsutility", (String)"block/logic/machineoutput_e"), ResourceLocation.fromNamespaceAndPath((String)"rftoolsutility", (String)"block/logic/machineoutput_f")};

    public DigitRenderer(BlockEntityRendererProvider.Context context) {
    }

    public void render(DigitTileEntity te, float partialTicks, PoseStack matrixStack, MultiBufferSource buffer, int combinedLightIn, int combinedOverlayIn) {
        BlockState state = te.getLevel().getBlockState(te.getBlockPos());
        Block block = state.getBlock();
        if (!(block instanceof LogicSlabBlock)) {
            return;
        }
        matrixStack.pushPose();
        VertexConsumer builder = buffer.getBuffer(RenderType.cutout());
        LogicFacing logicFacing = (LogicFacing)state.getValue((Property)LogicSlabBlock.LOGIC_FACING);
        Direction facing = logicFacing.getSide();
        RenderHelper.adjustTransformToDirection((PoseStack)matrixStack, (Direction)facing);
        int level = te.getPowerLevel();
        if (level < 0) {
            level = 0;
        } else if (level > 15) {
            level = 15;
        }
        TextureAtlasSprite sprite = (TextureAtlasSprite)Minecraft.getInstance().getTextureAtlas(TextureAtlas.LOCATION_BLOCKS).apply(DIGITS[level]);
        ModelBuilder.FaceRotation rotation = ModelBuilder.FaceRotation.values()[logicFacing.getRotationStep()];
        RenderHelper.renderNorthSouthQuad((PoseStack)matrixStack, (VertexConsumer)builder, (TextureAtlasSprite)sprite, (ModelBuilder.FaceRotation)rotation, (float)0.73f);
        matrixStack.popPose();
    }

    public static void register() {
        BlockEntityRenderers.register((BlockEntityType)((BlockEntityType)LogicBlockModule.DIGIT.be().get()), DigitRenderer::new);
    }
}

