/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsutility.modules.screen.client;

import javax.annotation.Nonnull;
import mcjty.lib.gui.GenericGuiContainer;
import mcjty.lib.gui.ManualEntry;
import mcjty.lib.gui.Window;
import mcjty.lib.gui.widgets.AbstractContainerWidget;
import mcjty.lib.gui.widgets.Panel;
import mcjty.lib.gui.widgets.Widgets;
import mcjty.lib.tileentity.GenericTileEntity;
import mcjty.lib.varia.Tools;
import mcjty.rftoolsutility.modules.screen.ScreenModule;
import mcjty.rftoolsutility.modules.screen.blocks.ScreenContainer;
import mcjty.rftoolsutility.modules.screen.blocks.ScreenTileEntity;
import mcjty.rftoolsutility.modules.screen.client.ScreenRenderer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.MenuScreens;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.neoforged.neoforge.client.event.RegisterMenuScreensEvent;

public class GuiTabletScreen
extends GenericGuiContainer<ScreenTileEntity, ScreenContainer> {
    public static final int WIDTH = 200;
    public static final int HEIGHT = 190;

    public GuiTabletScreen(ScreenContainer container, Inventory inventory, Component title) {
        super((AbstractContainerMenu)container, inventory, title, ManualEntry.EMPTY);
        this.imageWidth = 200;
        this.imageHeight = 190;
    }

    public static void register(RegisterMenuScreensEvent event) {
        MenuScreens.ScreenConstructor factory = (container, inventory, title) -> {
            GenericTileEntity te = container.getBe();
            return (GuiTabletScreen)((Object)((Object)Tools.safeMap((Object)te, tile -> new GuiTabletScreen((ScreenContainer)container, inventory, (Component)Component.literal((String)"Title")), (String)"Invalid tile entity!")));
        };
        event.register(ScreenModule.CONTAINER_SCREEN_REMOTE.get(), factory);
        event.register(ScreenModule.CONTAINER_SCREEN_REMOTE_CREATIVE.get(), factory);
    }

    public void init() {
        super.init();
        Panel toplevel = Widgets.positional();
        toplevel.bounds(this.leftPos, this.topPos, this.imageWidth, this.imageHeight);
        this.window = new Window((Screen)this, (AbstractContainerWidget)toplevel);
    }

    public boolean mouseClicked(double x, double y, int button) {
        double dx = 1.0 - (x -= 102.0) / 60.0;
        double dy = 1.0 - (y -= 32.0) / 60.0;
        ScreenTileEntity tileEntity = (ScreenTileEntity)this.getBE();
        ScreenTileEntity.ModuleRaytraceResult result = tileEntity.getHitModule(dx, dy, 0.0, Direction.NORTH, Direction.NORTH, 1);
        if (result != null) {
            tileEntity.hitScreenClient(result);
        }
        return false;
    }

    public void render(@Nonnull GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        ScreenTileEntity tileEntity = (ScreenTileEntity)this.getBE();
        tileEntity.tickMe();
        MultiBufferSource.BufferSource buffer = Minecraft.getInstance().renderBuffers().bufferSource();
        ScreenRenderer.renderInternal(tileEntity, graphics.pose(), (MultiBufferSource)buffer, 0xF000F0, OverlayTexture.NO_OVERLAY);
        buffer.endBatch();
    }
}

