/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsutility.modules.teleporter.blocks;

import javax.annotation.Nonnull;
import mcjty.lib.blocks.LogicSlabBlock;
import mcjty.lib.builder.BlockBuilder;
import mcjty.lib.builder.InfoLine;
import mcjty.lib.builder.TooltipBuilder;
import mcjty.lib.compat.theoneprobe.TOPDriver;
import mcjty.lib.varia.BlockPosTools;
import mcjty.lib.varia.Logging;
import mcjty.rftoolsutility.compat.RFToolsUtilityTOPDriver;
import mcjty.rftoolsutility.modules.teleporter.TeleporterModule;
import mcjty.rftoolsutility.modules.teleporter.blocks.SimpleDialerTileEntity;
import mcjty.rftoolsutility.modules.teleporter.data.SimpleDialerData;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;

public class SimpleDialerBlock
extends LogicSlabBlock {
    public SimpleDialerBlock() {
        super(new BlockBuilder().topDriver((TOPDriver)RFToolsUtilityTOPDriver.DRIVER).info(new InfoLine[]{TooltipBuilder.key((String)"message.rftoolsutility.shiftmessage")}).infoShift(new InfoLine[]{TooltipBuilder.header(), TooltipBuilder.parameter((String)"transmitter", SimpleDialerBlock::getTransmitterInfo), TooltipBuilder.parameter((String)"receiver", SimpleDialerBlock::getReceiverInfo), TooltipBuilder.parameter((String)"once", SimpleDialerBlock::hasOnce, stack -> SimpleDialerBlock.hasOnce(stack) ? "Once mode enabled" : "")}).tileEntitySupplier(SimpleDialerTileEntity::new));
    }

    private static boolean hasOnce(ItemStack stack) {
        SimpleDialerData data = (SimpleDialerData)stack.get(TeleporterModule.ITEM_SIMPLEDIALER_DATA);
        if (data != null) {
            return data.onceMode();
        }
        return false;
    }

    private static String getTransmitterInfo(ItemStack stack) {
        SimpleDialerData data = (SimpleDialerData)stack.get(TeleporterModule.ITEM_SIMPLEDIALER_DATA);
        if (data != null && BlockPosTools.isValid((BlockPos)data.transmitter().pos())) {
            int transX = data.transmitter().pos().getX();
            int transY = data.transmitter().pos().getY();
            int transZ = data.transmitter().pos().getZ();
            String dim = data.transmitter().dimension().location().toString();
            return transX + "," + transY + "," + transZ + " (dim " + dim + ")";
        }
        return "<unset>";
    }

    private static String getReceiverInfo(ItemStack stack) {
        SimpleDialerData data = (SimpleDialerData)stack.get(TeleporterModule.ITEM_SIMPLEDIALER_DATA);
        if (data != null && data.receiver() != -1) {
            return Integer.toString(data.receiver());
        }
        return "<unset>";
    }

    protected boolean wrenchUse(Level world, BlockPos pos, Direction side, Player player) {
        SimpleDialerTileEntity simpleDialerTileEntity;
        if (!world.isClientSide && (simpleDialerTileEntity = (SimpleDialerTileEntity)world.getBlockEntity(pos)) != null) {
            boolean onceMode = !simpleDialerTileEntity.isOnceMode();
            simpleDialerTileEntity.setOnceMode(onceMode);
            if (onceMode) {
                Logging.message((Player)player, (String)"Enabled 'dial once' mode");
            } else {
                Logging.message((Player)player, (String)"Disabled 'dial once' mode");
            }
        }
        return true;
    }

    public void neighborChanged(@Nonnull BlockState state, @Nonnull Level world, @Nonnull BlockPos pos, @Nonnull Block blockIn, @Nonnull BlockPos fromPos, boolean isMoving) {
        super.neighborChanged(state, world, pos, blockIn, fromPos, isMoving);
        BlockEntity te = world.getBlockEntity(pos);
        if (te instanceof SimpleDialerTileEntity) {
            SimpleDialerTileEntity simpleDialer = (SimpleDialerTileEntity)te;
            simpleDialer.update();
        }
    }
}

