/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsutility.modules.teleporter.blocks;

import javax.annotation.Nonnull;
import mcjty.lib.varia.LevelTools;
import mcjty.lib.varia.Logging;
import mcjty.rftoolsutility.RFToolsUtility;
import mcjty.rftoolsutility.modules.teleporter.TeleporterModule;
import mcjty.rftoolsutility.modules.teleporter.blocks.MatterReceiverTileEntity;
import mcjty.rftoolsutility.modules.teleporter.blocks.MatterTransmitterTileEntity;
import mcjty.rftoolsutility.modules.teleporter.data.SimpleDialerData;
import mcjty.rftoolsutility.modules.teleporter.data.TeleportDestination;
import mcjty.rftoolsutility.modules.teleporter.data.TeleportDestinations;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;

public class SimpleDialerItemBlock
extends BlockItem {
    public SimpleDialerItemBlock(Block block) {
        super(block, RFToolsUtility.setup.defaultProperties());
    }

    @Nonnull
    public InteractionResult useOn(UseOnContext context) {
        ItemStack stack = context.getItemInHand();
        Level world = context.getLevel();
        BlockPos pos = context.getClickedPos();
        Player player = context.getPlayer();
        BlockEntity te = world.getBlockEntity(pos);
        if (!world.isClientSide) {
            SimpleDialerData data = (SimpleDialerData)stack.get(TeleporterModule.ITEM_SIMPLEDIALER_DATA);
            if (data == null) {
                data = SimpleDialerData.createDefault();
            }
            if (te instanceof MatterTransmitterTileEntity) {
                MatterTransmitterTileEntity transmitter = (MatterTransmitterTileEntity)te;
                if (!transmitter.checkAccess(player.getDisplayName().getString())) {
                    Logging.message((Player)player, (String)(String.valueOf(ChatFormatting.RED) + "You have no access to this matter transmitter!"));
                    return InteractionResult.FAIL;
                }
                BlockPos mpos = transmitter.getBlockPos();
                data = data.withTransmitter(GlobalPos.of((ResourceKey)world.dimension(), (BlockPos)mpos));
                stack.set(TeleporterModule.ITEM_SIMPLEDIALER_DATA, (Object)data);
                if (transmitter.isDialed()) {
                    Integer id = transmitter.getTeleportId();
                    boolean access = this.checkReceiverAccess(player, world, id);
                    if (!access) {
                        Logging.message((Player)player, (String)(String.valueOf(ChatFormatting.RED) + "You have no access to the matter receiver!"));
                        return InteractionResult.FAIL;
                    }
                    data = data.withReceiver(id);
                    stack.set(TeleporterModule.ITEM_SIMPLEDIALER_DATA, (Object)data);
                    Logging.message((Player)player, (String)(String.valueOf(ChatFormatting.YELLOW) + "Receiver set!"));
                }
                Logging.message((Player)player, (String)(String.valueOf(ChatFormatting.YELLOW) + "Transmitter set!"));
            } else if (te instanceof MatterReceiverTileEntity) {
                MatterReceiverTileEntity receiver = (MatterReceiverTileEntity)te;
                Integer id = receiver.getOrCalculateID();
                boolean access = this.checkReceiverAccess(player, world, id);
                if (!access) {
                    Logging.message((Player)player, (String)(String.valueOf(ChatFormatting.RED) + "You have no access to this matter receiver!"));
                    return InteractionResult.FAIL;
                }
                data = data.withReceiver(id);
                stack.set(TeleporterModule.ITEM_SIMPLEDIALER_DATA, (Object)data);
                Logging.message((Player)player, (String)(String.valueOf(ChatFormatting.YELLOW) + "Receiver set!"));
            } else {
                return super.useOn(context);
            }
            return InteractionResult.SUCCESS;
        }
        return super.useOn(context);
    }

    private boolean checkReceiverAccess(Player player, Level world, Integer id) {
        MatterReceiverTileEntity receiver;
        BlockEntity recTe;
        ServerLevel worldForDimension;
        TeleportDestination destination;
        boolean access = true;
        TeleportDestinations destinations = TeleportDestinations.get(world);
        GlobalPos coordinate = destinations.getCoordinateForId(id);
        if (coordinate != null && (destination = destinations.getDestination(coordinate)) != null && (worldForDimension = LevelTools.getLevel(destination.getDimension())) != null && (recTe = worldForDimension.getBlockEntity(destination.getCoordinate())) instanceof MatterReceiverTileEntity && !(destination = (receiver = (MatterReceiverTileEntity)recTe).updateDestination()).checkAccess(world, player.getUUID())) {
            access = false;
        }
        return access;
    }
}

