/*
 * Decompiled with CFR 0.152.
 */
package me.wesley1808.servercore.common.config;

import me.wesley1808.servercore.common.config.Copyable;
import space.arim.dazzleconf.annote.ConfComments;
import space.arim.dazzleconf.annote.ConfDefault;
import space.arim.dazzleconf.annote.ConfHeader;
import space.arim.dazzleconf.annote.ConfKey;
import space.arim.dazzleconf.sorter.AnnotationBasedSorter;

@ConfHeader(value={"Allows you to toggle specific optimizations that don't have full vanilla parity.", "These settings will only take effect after server restarts.\n"})
public interface OptimizationConfig
extends Copyable {
    @AnnotationBasedSorter.Order(value=1)
    @ConfKey(value="reduce-sync-loads")
    @ConfDefault.DefaultBoolean(value=true)
    @ConfComments(value={"Prevents many different lagspikes caused by loading chunks synchronously.", "This for example causes maps to only update loaded chunks, which depending on the viewdistance can be a smaller radius than vanilla."})
    public boolean reduceSyncLoads();

    @AnnotationBasedSorter.Order(value=2)
    @ConfKey(value="cache-ticking-chunks")
    @ConfDefault.DefaultBoolean(value=true)
    @ConfComments(value={"Can significantly reduce the time spent on chunk iteration by only updating the ticking chunks list each second, rather than each tick.", "This is especially useful for servers with a high playercount and / or viewdistance.", "Note: This setting is incompatible with Moonrise."})
    public boolean cacheTickingChunks();

    @AnnotationBasedSorter.Order(value=3)
    @ConfKey(value="optimize-command-blocks")
    @ConfDefault.DefaultBoolean(value=false)
    @ConfComments(value={"Optimizes command block executions by caching parsed commands.", "Command parsing is a relatively expensive operation. By caching it we avoid parsing the same command every time it is executed."})
    public boolean optimizeCommandBlocks();

    @AnnotationBasedSorter.Order(value=4)
    @ConfKey(value="fast-biome-lookups")
    @ConfDefault.DefaultBoolean(value=false)
    @ConfComments(value={"Can significantly reduce time spent on mobspawning, but isn't as accurate as vanilla on biome borders.", "This may cause mobs from another biome to spawn a few blocks across a biome border (this does not affect structure spawning!)."})
    public boolean fastBiomeLookups();

    @AnnotationBasedSorter.Order(value=5)
    @ConfKey(value="cancel-duplicate-fluid-ticks")
    @ConfDefault.DefaultBoolean(value=false)
    @ConfComments(value={"Fluid random ticks, like lava spreading fire, are run twice each game tick.", "Enabling this will cancel the 'duplicate' second fluid tick, but this may cause slight behavior changes."})
    public boolean cancelDuplicateFluidTicks();

    @Override
    default public OptimizationConfig optimizedCopy() {
        return this;
    }
}

