/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.block.alloymaker;

import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.function.Supplier;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.silentchaos512.gear.api.material.IMaterialCategory;
import net.silentchaos512.gear.block.alloymaker.AlloyMakerBlock;
import net.silentchaos512.gear.block.alloymaker.AlloyMakerBlockEntity;
import net.silentchaos512.gear.block.alloymaker.AlloyMakerContainer;
import net.silentchaos512.gear.crafting.recipe.alloy.AlloyRecipe;
import net.silentchaos512.gear.gear.material.MaterialInstance;
import net.silentchaos512.gear.item.CompoundMaterialItem;

public class AlloyMakerInfo<R extends AlloyRecipe> {
    private final Supplier<AlloyMakerBlock<R>> block;
    private final Supplier<BlockEntityType<AlloyMakerBlockEntity<R>>> blockEntityType;
    private final Supplier<MenuType<? extends AlloyMakerContainer>> containerType;
    private final Supplier<RecipeType<R>> recipeType;
    private final Supplier<CompoundMaterialItem> outputItem;
    private final Supplier<RecipeSerializer<R>> recipeSerializer;
    private final Class<R> recipeClass;
    private final int inputSlotCount;
    private final ImmutableList<IMaterialCategory> categories;

    public AlloyMakerInfo(Collection<IMaterialCategory> categories, int inputSlotCount, Supplier<CompoundMaterialItem> outputItem, Supplier<AlloyMakerBlock<R>> block, Supplier<BlockEntityType<AlloyMakerBlockEntity<R>>> blockEntityType, Supplier<MenuType<? extends AlloyMakerContainer>> containerType, Supplier<RecipeSerializer<R>> recipeSerializer, Supplier<RecipeType<R>> recipeType, Class<R> recipeClass) {
        this.block = block;
        this.blockEntityType = blockEntityType;
        this.containerType = containerType;
        this.recipeType = recipeType;
        this.outputItem = outputItem;
        this.recipeSerializer = recipeSerializer;
        this.inputSlotCount = inputSlotCount;
        this.categories = ImmutableList.copyOf(categories);
        this.recipeClass = recipeClass;
    }

    public boolean acceptsMaterial(MaterialInstance material) {
        return this.categories.isEmpty() || material.hasAnyCategory((Collection<IMaterialCategory>)this.categories);
    }

    public AlloyMakerBlock<R> getBlock() {
        return this.block.get();
    }

    public BlockEntityType<AlloyMakerBlockEntity<R>> getBlockEntityType() {
        return this.blockEntityType.get();
    }

    public BlockEntityTicker<? super AlloyMakerBlockEntity<R>> getServerBlockEntityTicker() {
        return AlloyMakerBlockEntity::tick;
    }

    public MenuType<? extends AlloyMakerContainer> getContainerType() {
        return this.containerType.get();
    }

    public RecipeType<R> getRecipeType() {
        return this.recipeType.get();
    }

    public CompoundMaterialItem getOutputItem() {
        return this.outputItem.get();
    }

    public int getInputSlotCount() {
        return this.inputSlotCount;
    }

    public Collection<IMaterialCategory> getCategories() {
        return this.categories;
    }

    public Class<R> getRecipeClass() {
        return this.recipeClass;
    }

    public RecipeSerializer<?> getRecipeSerializer() {
        return this.recipeSerializer.get();
    }
}

