/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.block.grader;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.IntStream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.fml.ModList;
import net.neoforged.neoforge.items.ItemStackHandler;
import net.silentchaos512.gear.Config;
import net.silentchaos512.gear.SilentGear;
import net.silentchaos512.gear.api.material.modifier.IMaterialModifierType;
import net.silentchaos512.gear.api.part.MaterialGrade;
import net.silentchaos512.gear.block.SgContainerBlockEntity;
import net.silentchaos512.gear.block.grader.GraderContainer;
import net.silentchaos512.gear.gear.material.MaterialInstance;
import net.silentchaos512.gear.gear.material.modifier.GradeMaterialModifier;
import net.silentchaos512.gear.item.CompoundMaterialItem;
import net.silentchaos512.gear.setup.SgBlockEntities;
import net.silentchaos512.gear.setup.SgDataComponents;
import net.silentchaos512.gear.setup.SgTags;
import net.silentchaos512.gear.setup.gear.MaterialModifiers;
import net.silentchaos512.lib.util.EnumUtils;
import net.silentchaos512.lib.util.InventoryUtils;
import net.silentchaos512.lib.util.TimeUtils;

public class GraderBlockEntity
extends SgContainerBlockEntity {
    static final int BASE_ANALYZE_TIME = TimeUtils.ticksFromSeconds((float)(SilentGear.isDevBuild() ? 1.0f : 5.0f));
    static final int INPUT_SLOT = 0;
    static final int CATALYST_SLOT = 1;
    private static final int[] SLOTS_INPUT = new int[]{0, 1};
    private static final int[] SLOTS_OUTPUT = new int[]{2, 3, 4, 5};
    static final int INVENTORY_SIZE = SLOTS_INPUT.length + SLOTS_OUTPUT.length;
    private static final int[] SLOTS_ALL = IntStream.rangeClosed(0, INVENTORY_SIZE - 1).toArray();
    private int progress = 0;
    private MaterialGrade lastGradeAttempt = MaterialGrade.NONE;
    private final ContainerData fields = new ContainerData(){

        public int get(int index) {
            return switch (index) {
                case 0 -> GraderBlockEntity.this.progress;
                case 1 -> GraderBlockEntity.this.lastGradeAttempt.ordinal();
                default -> 0;
            };
        }

        public void set(int index, int value) {
            switch (index) {
                case 0: {
                    GraderBlockEntity.this.progress = value;
                    break;
                }
                case 1: {
                    GraderBlockEntity.this.lastGradeAttempt = (MaterialGrade)EnumUtils.byOrdinal((int)value, (Enum)MaterialGrade.NONE);
                }
            }
        }

        public int getCount() {
            return 2;
        }
    };

    public GraderBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)SgBlockEntities.MATERIAL_GRADER.get(), pos, state);
    }

    public static void tick(Level level, BlockPos pos, BlockState state, GraderBlockEntity blockEntity) {
        ItemStack input = blockEntity.getInputStack();
        if (input.isEmpty()) {
            return;
        }
        int outputSlot = blockEntity.getFreeOutputSlot();
        if (outputSlot < 0) {
            return;
        }
        ItemStack catalyst = blockEntity.getCatalystStack();
        int catalystTier = GraderBlockEntity.getCatalystTier(catalyst);
        if (catalystTier < 1) {
            return;
        }
        if (GraderBlockEntity.canGrade(input)) {
            if (blockEntity.progress < BASE_ANALYZE_TIME) {
                ++blockEntity.progress;
            }
            if (blockEntity.progress >= BASE_ANALYZE_TIME && !level.isClientSide) {
                blockEntity.progress = 0;
                catalyst.shrink(1);
                blockEntity.tryGradeItem(input, catalystTier);
            }
        } else {
            blockEntity.progress = 0;
        }
    }

    private void tryGradeItem(ItemStack input, int catalystTier) {
        boolean isCompoundMaterial = input.getItem() instanceof CompoundMaterialItem;
        List data = (List)input.get(SgDataComponents.MATERIAL_LIST);
        if (data != null && !isCompoundMaterial && this.tryGradePartItem(input, catalystTier, data)) {
            return;
        }
        MaterialInstance material = MaterialInstance.from(input);
        if (material != null) {
            this.tryGradeMaterial(input, catalystTier, material);
        }
    }

    private void tryGradeMaterial(ItemStack input, int catalystTier, MaterialInstance material) {
        MaterialGrade targetGrade;
        this.lastGradeAttempt = targetGrade = MaterialGrade.selectWithCatalyst(SilentGear.RANDOM, catalystTier);
        GradeMaterialModifier currentGradeMod = (GradeMaterialModifier)material.getModifier((IMaterialModifierType)MaterialModifiers.GRADE.get());
        if (currentGradeMod == null || targetGrade.ordinal() > currentGradeMod.grade().ordinal()) {
            ItemStack stack = input.split(1);
            targetGrade.setGradeOnStack(stack);
            InventoryUtils.mergeItem((Container)this, (int)2, (int)(2 + SLOTS_OUTPUT.length), (ItemStack)stack);
        }
    }

    private boolean tryGradePartItem(ItemStack input, int catalystTier, List<MaterialInstance> dataIn) {
        ArrayList<MaterialInstance> data = new ArrayList<MaterialInstance>(dataIn);
        MaterialInstance lowestMaterial = null;
        for (MaterialInstance materialInstance : data) {
            GradeMaterialModifier materialGradeMod = (GradeMaterialModifier)materialInstance.getModifier((IMaterialModifierType)MaterialModifiers.GRADE.get());
            if (lowestMaterial != null && materialGradeMod != null && materialGradeMod.grade().ordinal() >= ((GradeMaterialModifier)lowestMaterial.getModifier((IMaterialModifierType)MaterialModifiers.GRADE.get())).grade().ordinal()) continue;
            lowestMaterial = materialInstance;
            if (materialGradeMod != null) continue;
            break;
        }
        if (lowestMaterial != null) {
            MaterialGrade targetGrade;
            this.lastGradeAttempt = targetGrade = MaterialGrade.selectWithCatalyst(SilentGear.RANDOM, catalystTier);
            GradeMaterialModifier currentGradeMod = (GradeMaterialModifier)lowestMaterial.getModifier((IMaterialModifierType)MaterialModifiers.GRADE.get());
            if (currentGradeMod == null || targetGrade.ordinal() > currentGradeMod.grade().ordinal()) {
                ItemStack stack = input.split(1);
                data.remove(lowestMaterial);
                ItemStack materialStack = lowestMaterial.getItem();
                targetGrade.setGradeOnStack(materialStack);
                data.add(MaterialInstance.of(lowestMaterial.get(), materialStack));
                data.sort((o1, o2) -> {
                    GradeMaterialModifier g1 = (GradeMaterialModifier)o1.getModifier((IMaterialModifierType)MaterialModifiers.GRADE.get());
                    if (g1 == null) {
                        return 1;
                    }
                    GradeMaterialModifier g2 = (GradeMaterialModifier)o2.getModifier((IMaterialModifierType)MaterialModifiers.GRADE.get());
                    if (g2 == null) {
                        return -1;
                    }
                    return g2.grade().ordinal() - g1.grade().ordinal();
                });
                stack.set(SgDataComponents.MATERIAL_LIST, data);
                InventoryUtils.mergeItem((Container)this, (int)2, (int)(2 + SLOTS_OUTPUT.length), (ItemStack)stack);
            }
            return true;
        }
        return false;
    }

    public static boolean canGrade(ItemStack stack) {
        boolean isCompoundMaterial = stack.getItem() instanceof CompoundMaterialItem;
        if (GraderBlockEntity.canGradePartItem(stack) && !isCompoundMaterial) {
            return true;
        }
        MaterialInstance material = MaterialInstance.from(stack);
        if (material == null) {
            return false;
        }
        GradeMaterialModifier gradeMod = (GradeMaterialModifier)material.getModifier((IMaterialModifierType)MaterialModifiers.GRADE.get());
        return gradeMod == null || gradeMod.grade() != MaterialGrade.MAX;
    }

    private static boolean canGradePartItem(ItemStack stack) {
        if (!GraderBlockEntity.isGradingPartsAllowed()) {
            return false;
        }
        if (stack.getItem() instanceof CompoundMaterialItem) {
            return false;
        }
        List data = (List)stack.get(SgDataComponents.MATERIAL_LIST);
        if (data != null) {
            for (MaterialInstance materialInstance : data) {
                GradeMaterialModifier materialGradeMod = (GradeMaterialModifier)materialInstance.getModifier((IMaterialModifierType)MaterialModifiers.GRADE.get());
                if (materialGradeMod != null && materialGradeMod.grade() == MaterialGrade.MAX) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean isGradingPartsAllowed() {
        return Config.Common.isLoaded() && (Boolean)Config.Common.graderCanGradeParts.get() != false || ModList.get().isLoaded("sgearmetalworks");
    }

    private ItemStack getInputStack() {
        ItemStack stack = this.getItem(0);
        if (!stack.isEmpty() && GraderBlockEntity.canGrade(stack)) {
            return stack;
        }
        return ItemStack.EMPTY;
    }

    private ItemStack getCatalystStack() {
        return this.getItem(1);
    }

    private int getFreeOutputSlot() {
        for (int slot : SLOTS_OUTPUT) {
            if (!this.getItem(slot).isEmpty()) continue;
            return slot;
        }
        return -1;
    }

    public static int getCatalystTier(ItemStack stack) {
        if (!stack.isEmpty()) {
            for (int i = SgTags.Items.GRADER_CATALYSTS_TIERS.size() - 1; i >= 0; --i) {
                if (!stack.is(SgTags.Items.GRADER_CATALYSTS_TIERS.get(i))) continue;
                return i + 1;
            }
        }
        return 0;
    }

    public void setChanged() {
        this.progress = 0;
        super.setChanged();
    }

    @Override
    protected void loadAdditional(CompoundTag pTag, HolderLookup.Provider pRegistries) {
        super.loadAdditional(pTag, pRegistries);
        this.progress = pTag.getInt("Progress");
    }

    @Override
    protected void saveAdditional(CompoundTag pTag, HolderLookup.Provider pRegistries) {
        super.saveAdditional(pTag, pRegistries);
        pTag.putInt("Progress", this.progress);
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider pRegistries) {
        CompoundTag tags = super.getUpdateTag(pRegistries);
        tags.putInt("Progress", this.progress);
        ItemStack input = this.getInputStack();
        if (!input.isEmpty()) {
            tags.put("input_item", input.save(pRegistries, (Tag)new CompoundTag()));
        }
        return tags;
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt, HolderLookup.Provider lookupProvider) {
        super.onDataPacket(net, pkt, lookupProvider);
        CompoundTag tags = pkt.getTag();
        if (tags == null) {
            return;
        }
        this.progress = tags.getInt("Progress");
        if (tags.contains("input_item")) {
            ItemStack inputItem = ItemStack.parse((HolderLookup.Provider)lookupProvider, (Tag)tags.getCompound("input_item")).orElse(ItemStack.EMPTY);
            this.setItem(0, inputItem);
        } else {
            this.setItem(0, ItemStack.EMPTY);
        }
    }

    @Override
    public boolean canPlaceItem(int index, ItemStack stack) {
        if (index != 0 && index != 1) {
            return false;
        }
        ItemStack stackInSlot = this.getItem(index);
        if (stack.isEmpty() || !stackInSlot.isEmpty() && !ItemStack.isSameItemSameComponents((ItemStack)stackInSlot, (ItemStack)stack)) {
            return false;
        }
        if (index == 0) {
            return GraderBlockEntity.canGrade(stack);
        }
        return GraderBlockEntity.getCatalystTier(stack) > 0;
    }

    protected Component getDefaultName() {
        return Component.translatable((String)"container.silentgear.material_grader");
    }

    @Override
    public ItemStackHandler createItemHandler() {
        return new ItemStackHandler(this, INVENTORY_SIZE){

            public boolean isItemValid(int slot, ItemStack stack) {
                return slot == 0 && GraderBlockEntity.canGrade(stack) || slot == 1 && GraderBlockEntity.getCatalystTier(stack) > 0;
            }

            public ItemStack extractItem(int slot, int amount, boolean simulate) {
                if (slot == 0 || slot == 1) {
                    return ItemStack.EMPTY;
                }
                return super.extractItem(slot, amount, simulate);
            }
        };
    }

    protected AbstractContainerMenu createMenu(int id, Inventory playerInventory) {
        return new GraderContainer(id, playerInventory, (Container)this, this.fields);
    }
}

