/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.block.grader;

import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.ContainerListener;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.SimpleContainerData;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.silentchaos512.gear.api.part.MaterialGrade;
import net.silentchaos512.gear.block.grader.GraderBlockEntity;
import net.silentchaos512.gear.setup.SgMenuTypes;
import net.silentchaos512.lib.inventory.SlotOutputOnly;
import net.silentchaos512.lib.util.EnumUtils;
import net.silentchaos512.lib.util.InventoryUtils;

public class GraderContainer
extends AbstractContainerMenu {
    private final Container inventory;
    final ContainerData fields;

    public GraderContainer(int id, Inventory playerInventory, FriendlyByteBuf buffer) {
        this(id, playerInventory, (Container)new SimpleContainer(GraderBlockEntity.INVENTORY_SIZE), (ContainerData)new SimpleContainerData(2));
    }

    public GraderContainer(int id, Inventory playerInventory, Container inventory, ContainerData fields) {
        super((MenuType)SgMenuTypes.MATERIAL_GRADER.get(), id);
        this.inventory = inventory;
        this.fields = fields;
        GraderContainer.checkContainerSize((Container)this.inventory, (int)GraderBlockEntity.INVENTORY_SIZE);
        this.addSlot(new Slot(this, inventory, 0, 26, 35){

            public boolean mayPlace(ItemStack stack) {
                return GraderBlockEntity.canGrade(stack);
            }
        });
        this.addSlot(new Slot(this, inventory, 1, 26, 55){

            public boolean mayPlace(ItemStack stack) {
                return GraderBlockEntity.getCatalystTier(stack) > 0;
            }
        });
        this.addSlot((Slot)new SlotOutputOnly(inventory, 2, 80, 35));
        this.addSlot((Slot)new SlotOutputOnly(inventory, 3, 98, 35));
        this.addSlot((Slot)new SlotOutputOnly(inventory, 4, 116, 35));
        this.addSlot((Slot)new SlotOutputOnly(inventory, 5, 134, 35));
        InventoryUtils.createPlayerSlots((Inventory)playerInventory, (int)8, (int)84).forEach(x$0 -> this.addSlot((Slot)x$0));
        this.addDataSlots(this.fields);
    }

    public int getProgressArrowScale() {
        int progress = this.fields.get(0);
        return progress != 0 ? progress * 24 / GraderBlockEntity.BASE_ANALYZE_TIME : 0;
    }

    public MaterialGrade getLastGradeAttempt() {
        return (MaterialGrade)EnumUtils.byOrdinal((int)this.fields.get(1), (Enum)MaterialGrade.NONE);
    }

    public void addSlotListener(ContainerListener listener) {
        super.addSlotListener(listener);
    }

    public boolean stillValid(Player playerIn) {
        return this.inventory.stillValid(playerIn);
    }

    public ItemStack quickMoveStack(Player playerIn, int index) {
        ItemStack stack = ItemStack.EMPTY;
        Slot slot = (Slot)this.slots.get(index);
        if (slot != null && slot.hasItem()) {
            int size;
            ItemStack stack1 = slot.getItem();
            stack = stack1.copy();
            int startPlayer = size = this.inventory.getContainerSize();
            int endPlayer = size + 27;
            int startHotbar = size + 27;
            int endHotbar = size + 36;
            if (index >= 2 && index < GraderBlockEntity.INVENTORY_SIZE ? !this.moveItemStackTo(stack1, startPlayer, endHotbar, true) : (index >= size && GraderBlockEntity.canGrade(stack1) ? !this.moveItemStackTo(stack1, 0, 1, false) : (index >= size && GraderBlockEntity.getCatalystTier(stack1) > 0 ? !this.moveItemStackTo(stack1, 1, 2, false) : (index >= startPlayer && index < endPlayer ? !this.moveItemStackTo(stack1, startHotbar, endHotbar, false) : (index >= startHotbar && index < endHotbar ? !this.moveItemStackTo(stack1, startPlayer, endPlayer, false) : !this.moveItemStackTo(stack1, startPlayer, endHotbar, false)))))) {
                return ItemStack.EMPTY;
            }
            if (stack1.getCount() == 0) {
                slot.set(ItemStack.EMPTY);
            } else {
                slot.setChanged();
            }
            if (stack1.getCount() == stack.getCount()) {
                return ItemStack.EMPTY;
            }
            slot.onTake(playerIn, stack1);
        }
        return stack;
    }
}

