/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.client.model;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.ArrayList;
import java.util.HashMap;
import net.minecraft.client.model.Model;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class GearTridentModel
extends Model {
    public static final ModelResourceLocation TRIDENT_ICON = ModelResourceLocation.standalone((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"silentgear", (String)"item/trident_icon"));
    public static final ResourceLocation TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"silentgear", (String)"textures/item/trident/model.png");
    private final ModelPart root;

    public GearTridentModel(ModelPart root) {
        super(RenderType::entitySolid);
        this.root = root;
    }

    public static LayerDefinition createLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition partdefinition1 = partdefinition.addOrReplaceChild("pole", CubeListBuilder.create().texOffs(0, 6).addBox(-0.5f, 2.0f, -0.5f, 1.0f, 25.0f, 1.0f), PartPose.ZERO);
        partdefinition.addOrReplaceChild("base", CubeListBuilder.create().texOffs(4, 0).addBox(-1.5f, 0.0f, -0.5f, 3.0f, 2.0f, 1.0f), PartPose.ZERO);
        partdefinition.addOrReplaceChild("left_spike", CubeListBuilder.create().texOffs(4, 3).addBox(-2.5f, -3.0f, -0.5f, 1.0f, 4.0f, 1.0f), PartPose.ZERO);
        partdefinition.addOrReplaceChild("middle_spike", CubeListBuilder.create().texOffs(0, 0).addBox(-0.5f, -4.0f, -0.5f, 1.0f, 4.0f, 1.0f), PartPose.ZERO);
        partdefinition.addOrReplaceChild("right_spike", CubeListBuilder.create().texOffs(4, 3).mirror().addBox(1.5f, -3.0f, -0.5f, 1.0f, 4.0f, 1.0f), PartPose.ZERO);
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)32, (int)32);
    }

    public static LayerDefinition createToolRodLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        partdefinition.addOrReplaceChild("pole_top", CubeListBuilder.create().texOffs(0, 7).addBox(-0.5f, 1.0f, -0.5f, 1.0f, 4.0f, 1.0f), PartPose.ZERO);
        partdefinition.addOrReplaceChild("pole_bottom", CubeListBuilder.create().texOffs(0, 0).addBox(-0.5f, 21.0f, -0.5f, 1.0f, 6.0f, 1.0f), PartPose.ZERO);
        partdefinition.addOrReplaceChild("base_left", CubeListBuilder.create().texOffs(0, 29).addBox(-1.5f, 0.0f, -0.5f, 1.0f, 2.0f, 1.0f), PartPose.ZERO);
        partdefinition.addOrReplaceChild("base_right", CubeListBuilder.create().texOffs(0, 29).addBox(0.5f, 0.0f, -0.5f, 1.0f, 2.0f, 1.0f), PartPose.ZERO);
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)32, (int)32);
    }

    public static LayerDefinition createGripLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        partdefinition.addOrReplaceChild("pole_middle", CubeListBuilder.create().texOffs(0, 12).addBox(-0.5f, 5.0f, -0.5f, 1.0f, 16.0f, 1.0f), PartPose.ZERO);
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)32, (int)32);
    }

    public static LayerDefinition createSpikesLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        partdefinition.addOrReplaceChild("left_spike", CubeListBuilder.create().texOffs(4, 0).addBox(-2.5f, -2.0f, -0.5f, 1.0f, 3.0f, 1.0f), PartPose.ZERO);
        partdefinition.addOrReplaceChild("middle_spike", CubeListBuilder.create().texOffs(4, 4).addBox(-0.5f, -3.0f, -0.5f, 1.0f, 4.0f, 1.0f), PartPose.ZERO);
        partdefinition.addOrReplaceChild("right_spike", CubeListBuilder.create().texOffs(4, 0).mirror().addBox(1.5f, -2.0f, -0.5f, 1.0f, 3.0f, 1.0f), PartPose.ZERO);
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)32, (int)32);
    }

    public static LayerDefinition createTipLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        partdefinition.addOrReplaceChild("left_tip", CubeListBuilder.create().texOffs(4, 9).addBox(-2.5f, -3.0f, -0.5f, 1.0f, 1.0f, 1.0f), PartPose.ZERO);
        partdefinition.addOrReplaceChild("middle_tip", CubeListBuilder.create().texOffs(4, 9).addBox(-0.5f, -4.0f, -0.5f, 1.0f, 1.0f, 1.0f), PartPose.ZERO);
        partdefinition.addOrReplaceChild("right_tip", CubeListBuilder.create().texOffs(4, 9).mirror().addBox(1.5f, -3.0f, -0.5f, 1.0f, 1.0f, 1.0f), PartPose.ZERO);
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)32, (int)32);
    }

    public void renderToBuffer(PoseStack poseStack, VertexConsumer buffer, int packedLight, int packedOverlay, int color) {
        this.root.getChild("tool_rod").render(poseStack, buffer, packedLight, packedOverlay, 31743);
        this.root.getChild("grip").render(poseStack, buffer, packedLight, packedOverlay, 0xFFFB00);
        this.root.getChild("spikes").render(poseStack, buffer, packedLight, packedOverlay, 65293);
        this.root.getChild("tip").render(poseStack, buffer, packedLight, packedOverlay, 0xFF00D0);
    }

    public static GearTridentModel bakeModel() {
        ArrayList cubes = new ArrayList();
        HashMap<String, ModelPart> children = new HashMap<String, ModelPart>();
        children.put("tool_rod", GearTridentModel.createToolRodLayer().bakeRoot());
        children.put("grip", GearTridentModel.createGripLayer().bakeRoot());
        children.put("spikes", GearTridentModel.createSpikesLayer().bakeRoot());
        children.put("tip", GearTridentModel.createTipLayer().bakeRoot());
        return new GearTridentModel(new ModelPart(cubes, children));
    }

    public void renderWithColors(PoseStack poseStack, VertexConsumer buffer, int packedLight, int packedOverlay, int color_toolrod, int color_grip, int color_spikes, int color_tip) {
        this.root.getChild("tool_rod").render(poseStack, buffer, packedLight, packedOverlay, color_toolrod);
        this.root.getChild("grip").render(poseStack, buffer, packedLight, packedOverlay, color_grip);
        this.root.getChild("spikes").render(poseStack, buffer, packedLight, packedOverlay, color_spikes);
        this.root.getChild("tip").render(poseStack, buffer, packedLight, packedOverlay, color_tip);
    }
}

