/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.client.renderer.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.silentchaos512.gear.Config;
import net.silentchaos512.gear.client.model.GearTridentModel;
import net.silentchaos512.gear.entity.projectile.GearTridentProjectile;

public class GearTridentProjectileRenderer
extends EntityRenderer<GearTridentProjectile> {
    public static final ResourceLocation TRIDENT_LOCATION = GearTridentModel.TEXTURE;
    private final GearTridentModel model = GearTridentModel.bakeModel();

    public GearTridentProjectileRenderer(EntityRendererProvider.Context context) {
        super(context);
    }

    public void render(GearTridentProjectile entity, float entityYaw, float partialTicks, PoseStack poseStack, MultiBufferSource buffer, int packedLight) {
        poseStack.pushPose();
        poseStack.mulPose(Axis.YP.rotationDegrees(Mth.lerp((float)partialTicks, (float)entity.yRotO, (float)entity.getYRot()) - 90.0f));
        poseStack.mulPose(Axis.ZP.rotationDegrees(Mth.lerp((float)partialTicks, (float)entity.xRotO, (float)entity.getXRot()) + 90.0f));
        VertexConsumer vertexconsumer = ItemRenderer.getFoilBufferDirect((MultiBufferSource)buffer, (RenderType)this.model.renderType(TRIDENT_LOCATION), (boolean)false, ((Boolean)Config.Client.allowEnchantedEffect.get() != false && entity.isFoil() ? 1 : 0) != 0);
        this.model.renderWithColors(poseStack, vertexconsumer, packedLight, OverlayTexture.NO_OVERLAY, entity.getToolRodColor(), entity.getGripColor(), entity.getSpikesColor(), entity.getTipColor());
        poseStack.popPose();
    }

    public ResourceLocation getTextureLocation(GearTridentProjectile entity) {
        return TRIDENT_LOCATION;
    }
}

