/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.event;

import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.OnDatapackSyncEvent;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.network.PacketDistributor;
import net.silentchaos512.gear.network.payload.server.SyncMaterialsPayload;
import net.silentchaos512.gear.network.payload.server.SyncPartsPayload;
import net.silentchaos512.gear.network.payload.server.SyncTraitsPayload;
import net.silentchaos512.gear.setup.SgRegistries;

@EventBusSubscriber(modid="silentgear")
public final class ServerEvents {
    private ServerEvents() {
    }

    @SubscribeEvent
    public static void onDataPackSync(OnDatapackSyncEvent event) {
        if (event.getPlayer() != null) {
            ServerPlayer player = event.getPlayer();
            PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)new SyncTraitsPayload(), (CustomPacketPayload[])new CustomPacketPayload[]{new SyncMaterialsPayload(), new SyncPartsPayload()});
        } else {
            PacketDistributor.sendToAllPlayers((CustomPacketPayload)new SyncTraitsPayload(), (CustomPacketPayload[])new CustomPacketPayload[]{new SyncMaterialsPayload(), new SyncPartsPayload()});
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onPlayerJoinServer(PlayerEvent.PlayerLoggedInEvent event) {
        Player player = event.getEntity();
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer serverPlayer = (ServerPlayer)player;
        SgRegistries.TRAIT.getErrorMessages(serverPlayer).forEach(arg_0 -> ((ServerPlayer)serverPlayer).sendSystemMessage(arg_0));
        SgRegistries.MATERIAL.getErrorMessages(serverPlayer).forEach(arg_0 -> ((ServerPlayer)serverPlayer).sendSystemMessage(arg_0));
        SgRegistries.PART.getErrorMessages(serverPlayer).forEach(arg_0 -> ((ServerPlayer)serverPlayer).sendSystemMessage(arg_0));
    }
}

