/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.item.blueprint.book;

import javax.annotation.Nonnull;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.SlotItemHandler;
import net.silentchaos512.gear.item.IContainerItem;
import net.silentchaos512.gear.item.blueprint.book.BlueprintBookItem;
import net.silentchaos512.gear.setup.SgMenuTypes;

public class BlueprintBookContainerMenu
extends AbstractContainerMenu {
    final ItemStack item;
    private final IItemHandler itemHandler;
    int bookSlot = -1;

    public BlueprintBookContainerMenu(int id, Inventory playerInventory, RegistryFriendlyByteBuf data) {
        this(id, playerInventory, (ItemStack)ItemStack.STREAM_CODEC.decode((Object)data));
    }

    BlueprintBookContainerMenu(int id, Inventory playerInventory, ItemStack stack) {
        super((MenuType)SgMenuTypes.BLUEPRINT_BOOK.get(), id);
        int y;
        this.item = stack;
        final IContainerItem containerItem = (IContainerItem)this.item.getItem();
        this.itemHandler = containerItem.getInventory(this.item);
        for (int i = 0; i < this.itemHandler.getSlots(); ++i) {
            int x = 8 + 18 * (i % 9);
            y = 18 + 18 * (i / 9);
            this.addSlot((Slot)new SlotItemHandler(this, this.itemHandler, i, x, y){

                public boolean mayPlace(@Nonnull ItemStack stack) {
                    return containerItem.canStore(stack);
                }
            });
        }
        int rowCount = this.itemHandler.getSlots() / 9;
        int yOffset = (rowCount - 4) * 18;
        for (y = 0; y < 3; ++y) {
            for (int x = 0; x < 9; ++x) {
                this.addSlot(new Slot((Container)playerInventory, x + y * 9 + 9, 8 + x * 18, 103 + y * 18 + yOffset));
            }
        }
        for (int x = 0; x < 9; ++x) {
            Slot slot = this.addSlot(new Slot((Container)playerInventory, x, 8 + x * 18, 161 + yOffset){

                public boolean mayPickup(Player playerIn) {
                    return this.index != BlueprintBookContainerMenu.this.bookSlot;
                }
            });
            if (x != playerInventory.selected || !ItemStack.matches((ItemStack)playerInventory.getSelected(), (ItemStack)this.item)) continue;
            this.bookSlot = slot.index;
        }
    }

    public boolean stillValid(Player playerIn) {
        return true;
    }

    public ItemStack quickMoveStack(Player playerIn, int index) {
        Slot slot = this.getSlot(index);
        if (!slot.mayPickup(playerIn)) {
            return slot.getItem();
        }
        if (index == this.bookSlot || !slot.hasItem()) {
            return ItemStack.EMPTY;
        }
        ItemStack stack = slot.getItem();
        ItemStack newStack = stack.copy();
        int containerSlots = this.itemHandler.getSlots();
        if (index < containerSlots) {
            if (!this.moveItemStackTo(stack, containerSlots, this.slots.size(), true)) {
                return ItemStack.EMPTY;
            }
            slot.setChanged();
        } else if (!this.moveItemStackTo(stack, 0, containerSlots, false)) {
            return ItemStack.EMPTY;
        }
        if (stack.isEmpty()) {
            slot.set(ItemStack.EMPTY);
        } else {
            slot.setChanged();
        }
        slot.onTake(playerIn, newStack);
        return newStack;
    }

    public void clicked(int slotId, int dragType, ClickType clickTypeIn, Player player) {
        if (slotId < 0 || slotId > this.slots.size()) {
            super.clicked(slotId, dragType, clickTypeIn, player);
            return;
        }
        Slot slot = (Slot)this.slots.get(slotId);
        if (!this.canTake(slotId, slot, dragType, player, clickTypeIn)) {
            return;
        }
        super.clicked(slotId, dragType, clickTypeIn, player);
    }

    public boolean canTake(int slotId, Slot slot, int button, Player player, ClickType clickType) {
        if (slotId == this.bookSlot) {
            return false;
        }
        if (clickType == ClickType.SWAP) {
            int hotbarId = this.itemHandler.getSlots() + 27 + button;
            if (this.bookSlot == hotbarId) {
                return false;
            }
            Slot hotbarSlot = this.getSlot(hotbarId);
            if (slotId <= this.itemHandler.getSlots() - 1) {
                return !BlueprintBookContainerMenu.isContainerItem(slot.getItem()) && !BlueprintBookContainerMenu.isContainerItem(hotbarSlot.getItem());
            }
        }
        return true;
    }

    private static boolean isContainerItem(ItemStack stack) {
        return stack.getItem() instanceof BlueprintBookItem;
    }
}

