/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.setup;

import com.google.common.collect.ImmutableList;
import java.util.List;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.silentchaos512.gear.Config;

@EventBusSubscriber(modid="silentgear")
public final class NerfedGear {
    public static final List<String> DEFAULT_ITEMS = ImmutableList.of((Object)"diamond_axe", (Object)"iron_axe", (Object)"golden_axe", (Object)"stone_axe", (Object)"wooden_axe", (Object)"diamond_hoe", (Object)"iron_hoe", (Object)"golden_hoe", (Object)"stone_hoe", (Object)"wooden_hoe", (Object)"diamond_pickaxe", (Object)"iron_pickaxe", (Object[])new String[]{"golden_pickaxe", "stone_pickaxe", "wooden_pickaxe", "diamond_shovel", "iron_shovel", "golden_shovel", "stone_shovel", "wooden_shovel", "diamond_sword", "iron_sword", "golden_sword", "stone_sword", "wooden_sword"});

    private NerfedGear() {
    }

    public static void init() {
    }

    private static boolean isNerfedItem(Item item) {
        return Config.Common.isNerfedItem(item);
    }

    @SubscribeEvent
    public static void onBreakSpeed(PlayerEvent.BreakSpeed event) {
        ItemStack heldItem = event.getEntity().getMainHandItem();
        if (NerfedGear.isNerfedItem(heldItem.getItem())) {
            float newSpeed = event.getNewSpeed() * ((Double)Config.Common.nerfedItemHarvestSpeedMulti.get()).floatValue();
            event.setNewSpeed(Math.max(newSpeed, 1.0f));
        }
    }
}

