/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.lib.crafting.recipe;

import com.mojang.datafixers.Products;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Function5;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.item.crafting.ShapedRecipePattern;
import net.minecraft.world.level.Level;

public abstract class ExtendedShapedRecipe
extends ShapedRecipe {
    protected final ShapedRecipePattern pattern;
    protected final ItemStack result;
    protected final String group;
    protected final CraftingBookCategory category;
    protected final boolean showNotification;

    public ExtendedShapedRecipe(String pGroup, CraftingBookCategory pCategory, ShapedRecipePattern pPattern, ItemStack pResult, boolean pShowNotification) {
        super(pGroup, pCategory, pPattern, pResult, pShowNotification);
        this.group = pGroup;
        this.category = pCategory;
        this.pattern = pPattern;
        this.result = pResult;
        this.showNotification = pShowNotification;
    }

    public ExtendedShapedRecipe(String pGroup, CraftingBookCategory pCategory, ShapedRecipePattern pPattern, ItemStack pResult) {
        this(pGroup, pCategory, pPattern, pResult, true);
    }

    public abstract RecipeSerializer<?> getSerializer();

    public String getGroup() {
        return this.group;
    }

    public CraftingBookCategory category() {
        return this.category;
    }

    public ItemStack getResultItem(HolderLookup.Provider pRegistries) {
        return this.result;
    }

    public NonNullList<Ingredient> getIngredients() {
        return this.pattern.ingredients();
    }

    public boolean showNotification() {
        return this.showNotification;
    }

    public boolean canCraftInDimensions(int pWidth, int pHeight) {
        return pWidth >= this.pattern.width() && pHeight >= this.pattern.height();
    }

    public boolean matches(CraftingInput pInv, Level pLevel) {
        return this.pattern.matches(pInv);
    }

    public ItemStack assemble(CraftingInput pContainer, HolderLookup.Provider pRegistries) {
        return this.getResultItem(pRegistries).copy();
    }

    public int getWidth() {
        return this.pattern.width();
    }

    public int getHeight() {
        return this.pattern.height();
    }

    public boolean isIncomplete() {
        NonNullList<Ingredient> nonnulllist = this.getIngredients();
        return nonnulllist.isEmpty() || nonnulllist.stream().filter(ingredient -> !ingredient.isEmpty()).anyMatch(Ingredient::hasNoItems);
    }

    protected static <R extends ExtendedShapedRecipe> Products.P5<RecordCodecBuilder.Mu<R>, String, CraftingBookCategory, ShapedRecipePattern, ItemStack, Boolean> basicCodecFields(RecordCodecBuilder.Instance<R> builder) {
        return builder.group((App)Codec.STRING.optionalFieldOf("group", (Object)"").forGetter(r -> r.group), (App)CraftingBookCategory.CODEC.fieldOf("category").orElse((Object)CraftingBookCategory.MISC).forGetter(r -> r.category), (App)ShapedRecipePattern.MAP_CODEC.forGetter(r -> r.pattern), (App)ItemStack.STRICT_CODEC.fieldOf("result").forGetter(r -> r.result), (App)Codec.BOOL.optionalFieldOf("show_notification", (Object)true).forGetter(r -> r.showNotification));
    }

    public static class BasicSerializer<R extends ExtendedShapedRecipe>
    implements RecipeSerializer<R> {
        private final MapCodec<R> codec;
        private final StreamCodec<RegistryFriendlyByteBuf, R> streamCodec;
        private final Function5<String, CraftingBookCategory, ShapedRecipePattern, ItemStack, Boolean, R> factory;

        public BasicSerializer(Function5<String, CraftingBookCategory, ShapedRecipePattern, ItemStack, Boolean, R> factory) {
            this.factory = factory;
            this.codec = RecordCodecBuilder.mapCodec(builder -> ExtendedShapedRecipe.basicCodecFields(builder).apply((Applicative)builder, this.factory));
            this.streamCodec = StreamCodec.of(this::toNetwork, this::fromNetwork);
        }

        public MapCodec<R> codec() {
            return this.codec;
        }

        public StreamCodec<RegistryFriendlyByteBuf, R> streamCodec() {
            return this.streamCodec;
        }

        public R fromNetwork(RegistryFriendlyByteBuf buf) {
            String group = buf.readUtf();
            CraftingBookCategory category = (CraftingBookCategory)buf.readEnum(CraftingBookCategory.class);
            ShapedRecipePattern pattern = (ShapedRecipePattern)ShapedRecipePattern.STREAM_CODEC.decode((Object)buf);
            ItemStack result = (ItemStack)ItemStack.STREAM_CODEC.decode((Object)buf);
            boolean showNotification = buf.readBoolean();
            return (R)((Object)((ExtendedShapedRecipe)((Object)this.factory.apply((Object)group, (Object)category, (Object)pattern, (Object)result, (Object)showNotification))));
        }

        public void toNetwork(RegistryFriendlyByteBuf buf, R recipe) {
            buf.writeUtf(((ExtendedShapedRecipe)((Object)recipe)).group);
            buf.writeEnum((Enum)((ExtendedShapedRecipe)((Object)recipe)).category);
            ShapedRecipePattern.STREAM_CODEC.encode((Object)buf, (Object)((ExtendedShapedRecipe)((Object)recipe)).pattern);
            ItemStack.STREAM_CODEC.encode((Object)buf, (Object)((ExtendedShapedRecipe)((Object)recipe)).result);
            buf.writeBoolean(((ExtendedShapedRecipe)((Object)recipe)).showNotification);
        }
    }
}

