/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.lib.item;

import java.util.Collection;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.loot.LootTable;
import net.silentchaos512.lib.SilentLib;
import net.silentchaos512.lib.component.LootContainer;
import net.silentchaos512.lib.util.LootUtils;
import net.silentchaos512.lib.util.PlayerUtils;

public class LootContainerItem
extends Item {
    private static final String NBT_ROOT = "silentlib.LootContainer";
    private static final String NBT_LOOT_TABLE = "LootTable";
    private static final boolean DEFAULT_LIST_ITEMS_RECEIVED = true;
    private final ResourceKey<LootTable> defaultLootTable;
    private final boolean listItemsReceived;

    public LootContainerItem(ResourceLocation defaultLootTable) {
        this(defaultLootTable, true, new Item.Properties());
    }

    public LootContainerItem(ResourceLocation defaultLootTable, boolean listItemsReceived) {
        this(defaultLootTable, listItemsReceived, new Item.Properties());
    }

    public LootContainerItem(ResourceLocation defaultLootTable, Item.Properties properties) {
        this(defaultLootTable, true, properties);
    }

    public LootContainerItem(ResourceLocation defaultLootTable, boolean listItemsReceived, Item.Properties properties) {
        super(properties);
        this.defaultLootTable = ResourceKey.create((ResourceKey)Registries.LOOT_TABLE, (ResourceLocation)defaultLootTable);
        this.listItemsReceived = listItemsReceived;
    }

    public ItemStack getStack() {
        return this.getStack(this.defaultLootTable);
    }

    public ItemStack getStack(ResourceKey<LootTable> lootTable) {
        ItemStack result = new ItemStack((ItemLike)this);
        result.set(SilentLib.LOOT_CONTAINER, (Object)new LootContainer(lootTable));
        return result;
    }

    protected ResourceKey<LootTable> getLootTable(ItemStack stack) {
        LootContainer lootContainer = (LootContainer)stack.get(SilentLib.LOOT_CONTAINER);
        if (lootContainer != null) {
            return lootContainer.lootTable();
        }
        return this.defaultLootTable;
    }

    public static void setLootTable(ItemStack stack, ResourceKey<LootTable> lootTable) {
        stack.set(SilentLib.LOOT_CONTAINER, (Object)new LootContainer(lootTable));
    }

    protected Collection<ItemStack> getLootDrops(ItemStack heldItem, ServerPlayer player) {
        return LootUtils.gift(this.getLootTable(heldItem), player);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flag) {
        if (!flag.isAdvanced()) {
            return;
        }
        MutableComponent textTableName = Component.literal((String)this.getLootTable(stack).location().toString()).withStyle(ChatFormatting.WHITE);
        tooltip.add((Component)Component.translatable((String)"item.silentlib.lootContainer.table", (Object[])new Object[]{textTableName}).withStyle(ChatFormatting.BLUE));
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        ItemStack heldItem = player.getItemInHand(hand);
        if (!(player instanceof ServerPlayer)) {
            return InteractionResultHolder.success((Object)heldItem);
        }
        ServerPlayer serverPlayer = (ServerPlayer)player;
        Collection<ItemStack> lootDrops = this.getLootDrops(heldItem, serverPlayer);
        if (lootDrops.isEmpty()) {
            SilentLib.LOGGER.warn("LootContainerItem has no drops? {}, table={}", (Object)heldItem, this.getLootTable(heldItem));
        }
        lootDrops.forEach(stack -> {
            PlayerUtils.giveItem((Player)serverPlayer, stack);
            if (this.listItemsReceived) {
                LootContainerItem.listItemReceivedInChat(serverPlayer, stack);
            }
        });
        float pitch = ((serverPlayer.getRandom().nextFloat() - serverPlayer.getRandom().nextFloat()) * 0.7f + 1.0f) * 2.0f;
        serverPlayer.level().playSound(null, serverPlayer.blockPosition(), SoundEvents.ITEM_PICKUP, SoundSource.PLAYERS, 0.2f, pitch);
        heldItem.shrink(1);
        return InteractionResultHolder.success((Object)heldItem);
    }

    private static void listItemReceivedInChat(ServerPlayer serverPlayer, ItemStack stack) {
        MutableComponent itemReceivedText = Component.translatable((String)"item.silentlib.lootContainer.itemReceived", (Object[])new Object[]{stack.getCount(), stack.getHoverName()});
        serverPlayer.sendSystemMessage((Component)itemReceivedText);
    }
}

