/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.lib.util;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiFunction;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.silentchaos512.lib.util.MCMathUtils;

public final class WorldUtils {
    private WorldUtils() {
        throw new IllegalAccessError("Utility class");
    }

    public static <T> Map<BlockPos, T> getBlocksInArea(Level world, BlockPos pos, int range, BiFunction<Level, BlockPos, Optional<T>> getter) {
        int xMin = pos.getX() - range;
        int xMax = pos.getX() + range;
        int yMin = pos.getY() - range;
        int yMax = pos.getY() + range;
        int zMin = pos.getZ() - range;
        int zMax = pos.getZ() + range;
        return WorldUtils.getBlocks(world, xMin, yMin, zMin, xMax, yMax, zMax, getter);
    }

    public static <T> Map<BlockPos, T> getBlocksInSphere(Level world, BlockPos pos, int radius, BiFunction<Level, BlockPos, Optional<T>> getter) {
        int radiusSq = radius * radius;
        int xMin = pos.getX() - radius;
        int xMax = pos.getX() + radius;
        int yMin = pos.getY() - radius;
        int yMax = pos.getY() + radius;
        int zMin = pos.getZ() - radius;
        int zMax = pos.getZ() + radius;
        return WorldUtils.getBlocks(world, xMin, yMin, zMin, xMax, yMax, zMax, (world1, pos1) -> {
            if (MCMathUtils.distanceSq((Vec3i)pos, (Vec3i)pos1) <= (double)radiusSq) {
                return (Optional)getter.apply((Level)world1, (BlockPos)pos1);
            }
            return Optional.empty();
        });
    }

    public static <T> Map<BlockPos, T> getBlocks(Level world, int xMin, int yMin, int zMin, int xMax, int yMax, int zMax, BiFunction<Level, BlockPos, Optional<T>> getter) {
        LinkedHashMap map = new LinkedHashMap();
        if (!world.hasChunksAt(xMin, yMin, zMin, xMax, yMax, zMax)) {
            return map;
        }
        BlockPos.MutableBlockPos blockPos = new BlockPos.MutableBlockPos();
        for (int x = xMin; x <= xMax; ++x) {
            for (int y = yMin; y <= yMax; ++y) {
                for (int z = zMin; z <= zMax; ++z) {
                    BlockPos pos = new BlockPos(x, y, z);
                    getter.apply(world, (BlockPos)blockPos.set(x, y, z)).ifPresent(t -> map.put(pos, t));
                }
            }
        }
        return map;
    }

    public static <T extends BlockEntity> Map<BlockPos, T> getTileEntitiesInArea(Class<? extends T> clazz, Level world, BlockPos pos, int range) {
        int xMin = pos.getX() - range;
        int xMax = pos.getX() + range;
        int yMin = pos.getY() - range;
        int yMax = pos.getY() + range;
        int zMin = pos.getZ() - range;
        int zMax = pos.getZ() + range;
        return WorldUtils.getTileEntities(clazz, world, xMin, yMin, zMin, xMax, yMax, zMax);
    }

    public static <T extends BlockEntity> Map<BlockPos, T> getTileEntitiesInSphere(Class<? extends T> clazz, Level world, BlockPos pos, int radius) {
        int radiusSq = radius * radius;
        int xMin = pos.getX() - radius;
        int xMax = pos.getX() + radius;
        int yMin = pos.getY() - radius;
        int yMax = pos.getY() + radius;
        int zMin = pos.getZ() - radius;
        int zMax = pos.getZ() + radius;
        return WorldUtils.getBlocks(world, xMin, yMin, zMin, xMax, yMax, zMax, (world1, pos1) -> {
            if (MCMathUtils.distanceSq((Vec3i)pos, (Vec3i)pos1) <= (double)radiusSq) {
                return WorldUtils.getTileEntityOfType(clazz, pos, (BlockGetter)world1);
            }
            return Optional.empty();
        });
    }

    public static <T extends BlockEntity> Map<BlockPos, T> getTileEntities(Class<? extends T> clazz, Level world, int xMin, int yMin, int zMin, int xMax, int yMax, int zMax) {
        return WorldUtils.getBlocks(world, xMin, yMin, zMin, xMax, yMax, zMax, (world1, pos) -> WorldUtils.getTileEntityOfType(clazz, pos, (BlockGetter)world1));
    }

    private static <T extends BlockEntity> Optional<T> getTileEntityOfType(Class<? extends T> clazz, BlockPos pos, BlockGetter world) {
        BlockEntity te = world.getBlockEntity(pos);
        return clazz.isInstance(te) ? Optional.of(te) : Optional.empty();
    }
}

