/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.simplemagnets;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.supermartijn642.core.CommonUtils;
import com.supermartijn642.core.TextComponents;
import com.supermartijn642.core.gui.BaseContainer;
import com.supermartijn642.core.item.BaseItem;
import com.supermartijn642.simplemagnets.MagnetItem;
import com.supermartijn642.simplemagnets.SMConfig;
import com.supermartijn642.simplemagnets.gui.MagnetContainer;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public class AdvancedMagnet
extends MagnetItem {
    public static final DataComponentType<Settings> SETTINGS = DataComponentType.builder().persistent(RecordCodecBuilder.create(instance -> instance.group((App)Codec.BOOL.fieldOf("collectItems").forGetter(Settings::collectItems), (App)ExtraCodecs.POSITIVE_INT.fieldOf("itemRange").forGetter(Settings::itemRange), (App)Codec.BOOL.fieldOf("collectXp").forGetter(Settings::collectXp), (App)ExtraCodecs.POSITIVE_INT.fieldOf("xpRange").forGetter(Settings::xpRange), (App)Codec.BOOL.fieldOf("whitelist").forGetter(Settings::isWhitelist), (App)Codec.BOOL.fieldOf("filterDurability").forGetter(Settings::isFilterDurability), (App)ExtraCodecs.optionalEmptyMap((Codec)ItemStack.SINGLE_ITEM_CODEC).listOf(9, 9).fieldOf("itemFilter").forGetter(s -> s.itemFilter.stream().map(Optional::ofNullable).toList())).apply((Applicative)instance, (a, b, c, d, e, f, filter) -> new Settings((boolean)a, (int)b, (boolean)c, (int)d, (boolean)e, (boolean)f, filter.stream().map(o -> o.orElse(null)).toList())))).networkSynchronized((StreamCodec)new StreamCodec<RegistryFriendlyByteBuf, Settings>(){

        public void encode(RegistryFriendlyByteBuf buffer, Settings settings) {
            buffer.writeBoolean(settings.collectItems);
            buffer.writeInt(settings.itemRange);
            buffer.writeBoolean(settings.collectXp);
            buffer.writeInt(settings.xpRange);
            buffer.writeBoolean(settings.isWhitelist);
            buffer.writeBoolean(settings.isFilterDurability);
            for (ItemStack stack : settings.itemFilter) {
                buffer.writeBoolean(stack != null);
                if (stack == null) continue;
                ItemStack.STREAM_CODEC.encode((Object)buffer, (Object)stack);
            }
        }

        public Settings decode(RegistryFriendlyByteBuf buffer) {
            boolean collectItems = buffer.readBoolean();
            int itemRange = buffer.readInt();
            boolean collectXp = buffer.readBoolean();
            int xpRange = buffer.readInt();
            boolean isWhitelist = buffer.readBoolean();
            boolean isFilterDurability = buffer.readBoolean();
            List<ItemStack> itemFilter = Arrays.asList(new ItemStack[9]);
            for (int i = 0; i < itemFilter.size(); ++i) {
                if (!buffer.readBoolean()) continue;
                itemFilter.set(i, (ItemStack)ItemStack.STREAM_CODEC.decode((Object)buffer));
            }
            return new Settings(collectItems, itemRange, collectXp, xpRange, isWhitelist, isFilterDurability, itemFilter);
        }
    }).build();

    @Override
    public BaseItem.ItemUseResult interact(ItemStack stack, Player player, InteractionHand hand, Level level) {
        int slot;
        if (!player.isShiftKeyDown()) {
            return super.interact(stack, player, hand, level);
        }
        int n = slot = hand == InteractionHand.MAIN_HAND ? player.getInventory().selected : 40;
        if (!level.isClientSide) {
            CommonUtils.openContainer((BaseContainer)new MagnetContainer(player, slot));
        }
        return BaseItem.ItemUseResult.success((ItemStack)stack);
    }

    @Override
    protected boolean canPickupItems(ItemStack magnet) {
        return !magnet.has(SETTINGS) || ((Settings)magnet.get(SETTINGS)).collectItems();
    }

    @Override
    protected boolean canPickupStack(ItemStack magnet, ItemStack stack) {
        if (!magnet.has(SETTINGS)) {
            return true;
        }
        Settings settings = (Settings)magnet.get(SETTINGS);
        for (int slot = 0; slot < 9; ++slot) {
            ItemStack filterStack;
            if (settings.itemFilter.get(slot) == null || !ItemStack.isSameItem((ItemStack)stack, (ItemStack)(filterStack = settings.itemFilter.get(slot))) || settings.isFilterDurability && !ItemStack.isSameItemSameComponents((ItemStack)stack, (ItemStack)filterStack)) continue;
            return settings.isWhitelist;
        }
        return !settings.isWhitelist;
    }

    @Override
    protected boolean canPickupXp(ItemStack magnet) {
        return !magnet.has(SETTINGS) || ((Settings)magnet.get(SETTINGS)).collectXp();
    }

    @Override
    protected int getRangeItems(ItemStack magnet) {
        return magnet.has(SETTINGS) ? ((Settings)magnet.get(SETTINGS)).itemRange() : SMConfig.advancedMagnetRange.get().intValue();
    }

    @Override
    protected int getRangeXp(ItemStack magnet) {
        return magnet.has(SETTINGS) ? ((Settings)magnet.get(SETTINGS)).xpRange() : SMConfig.advancedMagnetRange.get().intValue();
    }

    @Override
    protected Component getTooltip() {
        return TextComponents.translation((String)"simplemagnets.advancedmagnet.info", (Object[])new Object[]{TextComponents.number((int)SMConfig.advancedMagnetMaxRange.get()).color(ChatFormatting.GOLD).get()}).color(ChatFormatting.GRAY).get();
    }

    public record Settings(boolean collectItems, int itemRange, boolean collectXp, int xpRange, boolean isWhitelist, boolean isFilterDurability, List<ItemStack> itemFilter) {
        public static Settings defaultSettings() {
            return new Settings(true, SMConfig.advancedMagnetRange.get(), true, SMConfig.advancedMagnetRange.get(), false, false, Collections.unmodifiableList(Arrays.asList(new ItemStack[9])));
        }

        public Settings collectItems(boolean value) {
            if (this.collectItems == value) {
                return this;
            }
            return new Settings(value, this.itemRange, this.collectXp, this.xpRange, this.isWhitelist, this.isFilterDurability, this.itemFilter);
        }

        public Settings itemRange(int value) {
            if (this.itemRange == value) {
                return this;
            }
            return new Settings(this.collectItems, value, this.collectXp, this.xpRange, this.isWhitelist, this.isFilterDurability, this.itemFilter);
        }

        public Settings collectXp(boolean value) {
            if (this.collectXp == value) {
                return this;
            }
            return new Settings(this.collectItems, this.itemRange, value, this.xpRange, this.isWhitelist, this.isFilterDurability, this.itemFilter);
        }

        public Settings xpRange(int value) {
            if (this.xpRange == value) {
                return this;
            }
            return new Settings(this.collectItems, this.itemRange, this.collectXp, value, this.isWhitelist, this.isFilterDurability, this.itemFilter);
        }

        public Settings whitelist(boolean value) {
            if (this.isWhitelist == value) {
                return this;
            }
            return new Settings(this.collectItems, this.itemRange, this.collectXp, this.xpRange, value, this.isFilterDurability, this.itemFilter);
        }

        public Settings filterDurability(boolean value) {
            if (this.isFilterDurability == value) {
                return this;
            }
            return new Settings(this.collectItems, this.itemRange, this.collectXp, this.xpRange, this.isWhitelist, value, this.itemFilter);
        }

        public Settings itemFilter(int index, ItemStack stack) {
            if (this.itemFilter.get(index) == null ? stack == null : stack != null && ItemStack.isSameItemSameComponents((ItemStack)this.itemFilter.get(index), (ItemStack)stack)) {
                return this;
            }
            ItemStack[] filter = Arrays.copyOf((ItemStack[])this.itemFilter.toArray(ItemStack[]::new), this.itemFilter.size());
            filter[index] = stack;
            return new Settings(this.collectItems, this.itemRange, this.collectXp, this.xpRange, this.isWhitelist, this.isFilterDurability, Collections.unmodifiableList(Arrays.asList(filter)));
        }
    }
}

