/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.simpletomb.particle;

import com.lothrazar.simpletomb.helper.WorldHelper;
import com.lothrazar.simpletomb.particle.CustomParticle;
import java.util.function.Predicate;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;

public class ParticleCasting
extends CustomParticle {
    private static final ResourceLocation COMMON_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"simpletomb", (String)"textures/particle/casting.png");
    private final LivingEntity caster;
    private final Predicate<LivingEntity> predic;
    private final double radius = 1.1;
    private double angle;
    private static final double ROT_INCR = 0.15707963267948966;
    private final float colorR;
    private final float colorG;
    private final float colorB;
    private boolean goUp;

    public ParticleCasting(ClientLevel level, LivingEntity caster, Predicate<LivingEntity> predic, double addY, double angle) {
        super(level, caster.getX(), caster.getY() + addY, caster.getZ());
        this.zd = 0.0;
        this.yd = 0.0;
        this.xd = 0.0;
        this.setAlpha(1.0f);
        this.goUp = addY < 1.0;
        this.caster = caster;
        this.predic = predic;
        this.quadSize = level.random.nextFloat() * 0.1f + 0.15f;
        this.angle = angle + (double)WorldHelper.getRandom(level.random, -0.25, 0.25);
        this.roll = level.random.nextFloat() * ((float)Math.PI * 2);
        float[] color = WorldHelper.getRGBColor3F(14937088);
        this.colorR = color[0];
        this.colorG = color[1];
        this.colorB = color[2];
        this.hasPhysics = false;
        this.updatePosition();
    }

    private void updatePosition() {
        this.angle += (double)0.01f;
        this.xo = this.x = this.caster.getX() + this.radius * Math.cos(Math.PI * 2 * this.angle);
        this.yo = this.y += this.goUp ? 0.02 : -0.02;
        this.zo = this.z = this.caster.getZ() + this.radius * Math.sin(Math.PI * 2 * this.angle);
        this.setColor(this.clampColor(this.colorR + WorldHelper.getRandom(this.level.random, -20.0, 20.0) / 255.0f), this.clampColor(this.colorG - WorldHelper.getRandom(this.level.random, -20.0, 20.0) / 255.0f), this.clampColor(this.colorB + WorldHelper.getRandom(this.level.random, -20.0, 20.0) / 255.0f));
        this.oRoll = this.roll;
        this.roll += 0.15707964f;
    }

    private float clampColor(float color) {
        return Mth.clamp((float)color, (float)0.0f, (float)1.0f);
    }

    public void tick() {
        if (this.y > this.caster.getY() + 2.0 || this.y < this.caster.getY()) {
            boolean bl = this.goUp = !this.goUp;
        }
        if (this.predic.test(this.caster)) {
            this.remove();
        }
        this.updatePosition();
        ++this.age;
    }

    protected int getLightColor(float partialTick) {
        int skylight = 5;
        int blocklight = 15;
        return skylight << 20 | blocklight << 4;
    }

    @Override
    ResourceLocation getTexture() {
        return COMMON_TEXTURE;
    }
}

