/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedstorage.compat.recipeviewers.common.subtypes;

import java.lang.runtime.SwitchBootstraps;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.p3pp3rf1y.sophisticatedcore.compat.recipeviewers.common.subtypes.PropertyBasedSubtypeInterpreter;
import net.p3pp3rf1y.sophisticatedstorage.compat.recipeviewers.common.subtypes.BarrelSubtypeInterpreter;
import net.p3pp3rf1y.sophisticatedstorage.compat.recipeviewers.common.subtypes.ChestSubtypeInterpreter;
import net.p3pp3rf1y.sophisticatedstorage.compat.recipeviewers.common.subtypes.ShulkerBoxSubtypeInterpreter;
import net.p3pp3rf1y.sophisticatedstorage.init.ModBlocks;
import net.p3pp3rf1y.sophisticatedstorage.item.BarrelBlockItem;
import net.p3pp3rf1y.sophisticatedstorage.item.ChestBlockItem;
import net.p3pp3rf1y.sophisticatedstorage.item.ShulkerBoxItem;
import net.p3pp3rf1y.sophisticatedstorage.item.StorageBlockItem;

public class SubtypeInterpreters {
    private static final PropertyBasedSubtypeInterpreter chestSubtypeInterpreter = new ChestSubtypeInterpreter();
    private static final PropertyBasedSubtypeInterpreter barrelSubtypeInterpreter = new BarrelSubtypeInterpreter();
    private static final PropertyBasedSubtypeInterpreter shulkerBoxSubtypeInterpreter = new ShulkerBoxSubtypeInterpreter();

    public static Map<BlockItem, PropertyBasedSubtypeInterpreter> getSubtypeInterpreters() {
        return new HashMap<BlockItem, PropertyBasedSubtypeInterpreter>(){
            {
                ModBlocks.ITEMS.getEntries().stream().filter(holder -> holder.get() instanceof StorageBlockItem).forEach((? super T item) -> {
                    Item item2 = (Item)item.get();
                    Objects.requireNonNull(item2);
                    Item selector0$temp = item2;
                    int index$1 = 0;
                    switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{BarrelBlockItem.class, ChestBlockItem.class, ShulkerBoxItem.class}, (Object)selector0$temp, index$1)) {
                        case 0: {
                            BarrelBlockItem blockItem = (BarrelBlockItem)selector0$temp;
                            this.put(blockItem, barrelSubtypeInterpreter);
                            break;
                        }
                        case 1: {
                            ChestBlockItem blockItem = (ChestBlockItem)selector0$temp;
                            this.put(blockItem, chestSubtypeInterpreter);
                            break;
                        }
                        case 2: {
                            ShulkerBoxItem blockItem = (ShulkerBoxItem)selector0$temp;
                            this.put(blockItem, shulkerBoxSubtypeInterpreter);
                            break;
                        }
                    }
                });
            }
        };
    }

    public static Optional<PropertyBasedSubtypeInterpreter> getSubtypeInterpreter(Map<BlockItem, PropertyBasedSubtypeInterpreter> subtypeInterpreters, ItemStack stack) {
        Item item = stack.getItem();
        if (!(item instanceof BlockItem)) {
            return Optional.empty();
        }
        BlockItem blockItem = (BlockItem)item;
        return Optional.ofNullable(subtypeInterpreters.get(blockItem));
    }
}

