/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevescarts;

import com.mojang.authlib.GameProfile;
import java.util.UUID;
import net.minecraft.world.level.ItemLike;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.fml.loading.FMLEnvironment;
import net.neoforged.neoforge.common.NeoForgeMod;
import net.neoforged.neoforge.event.BuildCreativeModeTabContentsEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import vswe.stevescarts.SCConfig;
import vswe.stevescarts.StevesCartsClient;
import vswe.stevescarts.blocks.tileentities.TileEntityCargo;
import vswe.stevescarts.client.StevesCartsCreativeTabs;
import vswe.stevescarts.events.OverlayEventHandler;
import vswe.stevescarts.helpers.ForceChunkHelper;
import vswe.stevescarts.init.ModBlocks;
import vswe.stevescarts.init.ModCapabilities;
import vswe.stevescarts.init.ModContainers;
import vswe.stevescarts.init.ModEntities;
import vswe.stevescarts.init.ModItemData;
import vswe.stevescarts.init.ModItems;
import vswe.stevescarts.init.ModSerializers;
import vswe.stevescarts.init.StevesCartsModules;
import vswe.stevescarts.network.PacketHandler;
import vswe.stevescarts.upgrades.AssemblerUpgrade;

@Mod(value="stevescarts")
public class StevesCarts {
    public static final GameProfile FAKE_PLAYER = new GameProfile(UUID.fromString("5e8636cc-6b51-4f8f-952c-beedf20347b0"), "[StevesCarts]");
    public static StevesCarts INSTANCE;
    public static Logger LOGGER;

    public StevesCarts(IEventBus modBus, ModContainer container) {
        INSTANCE = this;
        modBus.addListener(this::commonSetup);
        StevesCartsModules.init();
        AssemblerUpgrade.init();
        ModItems.ITEMS.register(modBus);
        ModBlocks.BLOCKS.register(modBus);
        StevesCartsCreativeTabs.CREATIVE_TAB.register(modBus);
        ModEntities.ENTITIES.register(modBus);
        ModBlocks.TILES_ENTITIES.register(modBus);
        ModContainers.CONTAINERS.register(modBus);
        modBus.addListener(this::creativeTabBuildEvent);
        modBus.addListener(this::clientInit);
        container.registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)SCConfig.clientSpec, "stevescarts-client.toml");
        container.registerConfig(ModConfig.Type.COMMON, (IConfigSpec)SCConfig.commonSpec, "stevescarts-common.toml");
        modBus.register(SCConfig.class);
        NeoForgeMod.enableMilkFluid();
        ForceChunkHelper.init(modBus);
        ModCapabilities.init(modBus);
        PacketHandler.init(modBus);
        ModSerializers.init(modBus);
        ModItemData.init();
        if (FMLEnvironment.dist.isClient()) {
            OverlayEventHandler.init(modBus);
            StevesCartsClient.init(modBus);
        }
    }

    public void creativeTabBuildEvent(BuildCreativeModeTabContentsEvent event) {
        if (event.getTab() == StevesCartsCreativeTabs.BLOCKS.get()) {
            ModBlocks.BLOCKS.getEntries().forEach(blockRegistryObject -> event.accept((ItemLike)blockRegistryObject.get()));
        }
        if (event.getTab() == StevesCartsCreativeTabs.ITEMS.get()) {
            ModItems.COMPONENTS.forEach((moduleData, itemSupplier) -> event.accept((ItemLike)itemSupplier.get()));
        }
        if (event.getTab() == StevesCartsCreativeTabs.MODULES.get()) {
            ModItems.MODULES.forEach((moduleData, itemSupplier) -> event.accept((ItemLike)itemSupplier.get()));
        }
    }

    public void clientInit(FMLClientSetupEvent event) {
        StevesCartsClient.clientInit(event);
    }

    public void commonSetup(FMLCommonSetupEvent event) {
        AssemblerUpgrade.init();
        TileEntityCargo.loadSelectionSettings();
    }

    static {
        LOGGER = LogManager.getLogger();
    }
}

