/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevescarts.api.modules.template;

import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.vehicle.AbstractMinecart;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseRailBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.RailShape;
import vswe.stevescarts.api.modules.ModuleBase;
import vswe.stevescarts.entities.EntityMinecartModular;
import vswe.stevescarts.integration.Integration;

public abstract class ModuleWorker
extends ModuleBase {
    private boolean preWork = true;
    private boolean shouldDie;

    public ModuleWorker(EntityMinecartModular cart) {
        super(cart);
    }

    public abstract byte getWorkPriority();

    public abstract boolean work();

    public void startWorking(int time) {
        this.getCart().setWorkingTime(time);
        this.preWork = false;
        this.getCart().setWorker(this);
    }

    public void stopWorking() {
        if (this.getCart().getWorker() == this) {
            this.preWork = true;
            this.getCart().setWorker(null);
        }
    }

    public boolean preventAutoShutdown() {
        return false;
    }

    public void kill() {
        this.shouldDie = true;
    }

    public boolean isDead() {
        return this.shouldDie;
    }

    public void revive() {
        this.shouldDie = false;
    }

    protected boolean doPreWork() {
        return this.preWork;
    }

    public BlockPos getLastblock() {
        return this.getNextblock(false);
    }

    public BlockPos getNextblock() {
        return this.getNextblock(true);
    }

    private BlockPos getNextblock(boolean flag) {
        BlockState blockState;
        BlockPos pos = this.getCart().blockPosition();
        if (BaseRailBlock.isRail((Level)this.getCart().level(), (BlockPos)pos.below())) {
            pos = pos.below();
        }
        if (BaseRailBlock.isRail((BlockState)(blockState = this.getCart().level().getBlockState(pos)))) {
            RailShape direction = ((BaseRailBlock)blockState.getBlock()).getRailDirection(blockState, (BlockGetter)this.getCart().level(), pos, (AbstractMinecart)this.getCart());
            if (direction.isAscending()) {
                pos = pos.above();
            }
            int[][] logic = EntityMinecartModular.railDirectionCoordinates[direction.ordinal()];
            double pX = this.getCart().temppushX;
            double pZ = this.getCart().temppushZ;
            boolean xDir = pX > 0.0 && logic[0][0] > 0 || pX == 0.0 || logic[0][0] == 0 || pX < 0.0 && logic[0][0] < 0;
            boolean zDir = pZ > 0.0 && logic[0][2] > 0 || pZ == 0.0 || logic[0][2] == 0 || pZ < 0.0 && logic[0][2] < 0;
            int dir = (xDir && zDir) != flag ? 1 : 0;
            return pos.offset(logic[dir][0], logic[dir][1], logic[dir][2]);
        }
        return pos;
    }

    @Override
    public float getMaxSpeed() {
        if (!this.doPreWork()) {
            return 0.0f;
        }
        return super.getMaxSpeed();
    }

    protected boolean isValidForTrack(BlockPos pos, boolean checkBellow) {
        boolean result;
        if (!Integration.canEditBlock((ServerPlayer)this.getFakePlayer(), pos)) {
            return false;
        }
        boolean bl = result = this.countsAsAir(pos) && (!checkBellow || Block.canSupportRigidBlock((BlockGetter)this.getCart().level(), (BlockPos)pos.below()));
        if (result) {
            int coordX = pos.getX() - (this.getCart().x() - pos.getX());
            int coordZ = pos.getZ() - (this.getCart().z() - pos.getZ());
            Block block = this.getCart().level().getBlockState(new BlockPos(coordX, pos.getY(), coordZ)).getBlock();
            boolean isWater = block == Blocks.WATER || block == Blocks.ICE;
            boolean isLava = block == Blocks.LAVA;
            boolean isOther = !this.getCart().level().getFluidState(pos).isEmpty();
            boolean isLiquid = isWater || isLava || isOther;
            result = !isLiquid;
        }
        return result;
    }
}

