/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevescarts.blocks;

import com.mojang.serialization.MapCodec;
import java.util.ArrayList;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import vswe.stevescarts.blocks.BlockContainerBase;
import vswe.stevescarts.blocks.tileentities.TileEntityCartAssembler;
import vswe.stevescarts.blocks.tileentities.TileEntityUpgrade;
import vswe.stevescarts.polylib.Pair;

public class BlockCartAssembler
extends BlockContainerBase {
    public static final MapCodec<BlockCartAssembler> CODEC = BlockCartAssembler.simpleCodec(BlockCartAssembler::new);

    public BlockCartAssembler(BlockBehaviour.Properties properties) {
        super(properties);
    }

    @NotNull
    public InteractionResult useWithoutItem(@NotNull BlockState blockState, Level world, @NotNull BlockPos blockPos, @NotNull Player playerEntity, BlockHitResult result) {
        if (!world.isClientSide && !playerEntity.isCrouching()) {
            playerEntity.openMenu((MenuProvider)world.getBlockEntity(blockPos), blockPos);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.SUCCESS;
    }

    public void updateMultiBlock(Level world, BlockPos pos) {
        BlockEntity master = world.getBlockEntity(pos);
        if (master instanceof TileEntityCartAssembler) {
            ((TileEntityCartAssembler)master).clearUpgrades();
        }
        this.checkForUpgrades(world, pos);
        if (master instanceof TileEntityCartAssembler) {
            ((TileEntityCartAssembler)master).onUpgradeUpdate();
        }
    }

    private void checkForUpgrades(Level world, BlockPos pos) {
        for (Direction facing : Direction.values()) {
            this.checkForUpgrade(world, pos.relative(facing));
        }
    }

    private TileEntityCartAssembler checkForUpgrade(Level world, BlockPos pos) {
        BlockEntity tile = world.getBlockEntity(pos);
        if (tile != null && tile instanceof TileEntityUpgrade) {
            TileEntityUpgrade upgrade = (TileEntityUpgrade)tile;
            ArrayList<Pair<TileEntityCartAssembler, Direction>> masters = this.getMasters(world, pos);
            if (masters.size() == 1) {
                Pair<TileEntityCartAssembler, Direction> pair = masters.get(0);
                TileEntityCartAssembler master = pair.first();
                master.addUpgrade(upgrade);
                upgrade.setMaster(master, pair.second().getOpposite());
                return master;
            }
            world.blockEntityChanged(pos);
            for (Pair<TileEntityCartAssembler, Direction> master2 : masters) {
                master2.first().removeUpgrade(upgrade);
            }
            upgrade.setMaster(null, null);
        }
        return null;
    }

    private ArrayList<Pair<TileEntityCartAssembler, Direction>> getMasters(Level world, BlockPos pos) {
        ArrayList<Pair<TileEntityCartAssembler, Direction>> masters = new ArrayList<Pair<TileEntityCartAssembler, Direction>>();
        for (Direction facing : Direction.values()) {
            TileEntityCartAssembler temp = this.getMaster(world, pos.relative(facing));
            if (temp == null) continue;
            masters.add(Pair.of(temp, facing));
        }
        return masters;
    }

    private TileEntityCartAssembler getValidMaster(Level world, BlockPos pos) {
        TileEntityCartAssembler master = null;
        for (Direction facing : Direction.values()) {
            TileEntityCartAssembler temp = this.getMaster(world, pos.relative(facing));
            if (temp == null) continue;
            if (master != null) {
                return null;
            }
            master = temp;
        }
        return master;
    }

    private TileEntityCartAssembler getMaster(Level world, BlockPos pos) {
        BlockEntity tile = world.getBlockEntity(pos);
        if (tile != null && tile instanceof TileEntityCartAssembler) {
            TileEntityCartAssembler master = (TileEntityCartAssembler)tile;
            if (!master.isDead) {
                return master;
            }
        }
        return null;
    }

    public void addUpgrade(Level world, BlockPos pos) {
        TileEntityCartAssembler master = this.getValidMaster(world, pos);
        if (master != null) {
            this.updateMultiBlock(world, master.getBlockPos());
        }
    }

    public void removeUpgrade(Level world, BlockPos pos) {
        TileEntityCartAssembler master = this.getValidMaster(world, pos);
        if (master != null) {
            this.updateMultiBlock(world, master.getBlockPos());
        }
    }

    public void neighborChanged(@NotNull BlockState blockState, @NotNull Level world, @NotNull BlockPos blockPos, @NotNull Block block, @NotNull BlockPos blockPos1, boolean p_220069_6_) {
        super.neighborChanged(blockState, world, blockPos, block, blockPos, p_220069_6_);
        this.updateMultiBlock(world, blockPos);
    }

    @Nullable
    public BlockEntity newBlockEntity(@NotNull BlockPos blockPos, @NotNull BlockState blockState) {
        return new TileEntityCartAssembler(blockPos, blockState);
    }

    protected MapCodec<? extends BaseEntityBlock> codec() {
        return CODEC;
    }
}

