/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevescarts.modules.realtimers;

import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import vswe.stevescarts.api.modules.ModuleBase;
import vswe.stevescarts.entities.EntityMinecartModular;

public class ModuleCleaner
extends ModuleBase {
    public ModuleCleaner(EntityMinecartModular cart) {
        super(cart);
    }

    @Override
    public void update() {
        super.update();
        if (this.getCart().level().isClientSide) {
            return;
        }
        if (this.getCart().hasFuel()) {
            this.suck();
        }
        this.clean();
    }

    private double calculatemotion(double dif) {
        if (dif > -0.5 && dif < 0.5) {
            return 0.0;
        }
        return 1.0 / (dif * 2.0);
    }

    private void suck() {
        List list = this.getCart().level().getEntitiesOfClass(ItemEntity.class, this.getCart().getBoundingBox().inflate(3.0, 1.0, 3.0));
        for (ItemEntity eItem : list) {
            if (eItem.isPickable()) continue;
            double difX = this.getCart().getExactPosition().getX() - eItem.blockPosition().getX();
            double difY = this.getCart().getExactPosition().getY() - eItem.blockPosition().getY();
            double d = this.getCart().getExactPosition().getZ() - eItem.blockPosition().getZ();
        }
    }

    private void clean() {
        List list = this.getCart().level().getEntitiesOfClass(ItemEntity.class, this.getCart().getBoundingBox().inflate(3.0, 1.0, 3.0));
        for (ItemEntity eItem : list) {
            if (eItem.isPickable() || eItem.isRemoved()) continue;
            int stackSize = eItem.getItem().getCount();
            this.getCart().addItemToChest(eItem.getItem());
            if (stackSize != eItem.getItem().getCount()) {
                this.getCart().level().playSound(null, this.getCart().blockPosition(), SoundEvents.ITEM_PICKUP, SoundSource.NEUTRAL, 0.2f, ((this.getCart().random.nextFloat() - this.getCart().random.nextFloat()) * 0.7f + 1.0f) * 2.0f);
                if (eItem.getItem().getCount() > 0) continue;
                eItem.remove(Entity.RemovalReason.DISCARDED);
                continue;
            }
            if (!this.failPickup(eItem.getItem())) continue;
            eItem.remove(Entity.RemovalReason.DISCARDED);
        }
    }

    private boolean failPickup(@Nonnull ItemStack item) {
        int x = this.normalize(this.getCart().xo);
        int z = this.normalize(this.getCart().zo);
        if (x == 0 && z == 0) {
            return false;
        }
        ItemEntity entityitem = new ItemEntity(this.getCart().level(), (double)this.getCart().x(), (double)this.getCart().y(), (double)this.getCart().z(), item.copy());
        this.getCart().level().addFreshEntity((Entity)entityitem);
        return true;
    }

    private int normalize(double val) {
        return Double.compare(val, 0.0);
    }
}

