/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevescarts.modules.realtimers;

import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.ArrayList;
import javax.annotation.Nonnull;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.component.DataComponents;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.projectile.FireworkRocketEntity;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.FireworkExplosion;
import net.minecraft.world.item.component.Fireworks;
import net.minecraft.world.level.ItemLike;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.common.Tags;
import vswe.stevescarts.api.modules.ModuleBase;
import vswe.stevescarts.api.slots.SlotStevesCarts;
import vswe.stevescarts.client.guis.GuiMinecart;
import vswe.stevescarts.containers.slots.SlotFirework;
import vswe.stevescarts.entities.EntityMinecartModular;

public class ModuleFirework
extends ModuleBase {
    private int fireCooldown;

    public ModuleFirework(EntityMinecartModular cart) {
        super(cart);
    }

    @Override
    public void update() {
        if (this.fireCooldown > 0) {
            --this.fireCooldown;
        }
    }

    @Override
    public void activatedByRail(int x, int y, int z, boolean active) {
        if (active && this.fireCooldown == 0 && this.getCart().hasFuel()) {
            this.fire();
            this.fireCooldown = 20;
        }
    }

    @Override
    public boolean hasGui() {
        return true;
    }

    @Override
    protected SlotStevesCarts getSlot(int slotId, int x, int y) {
        return new SlotFirework(this.getCart(), slotId, 8 + x * 18, 16 + y * 18);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void drawForeground(GuiGraphics guiGraphics, GuiMinecart gui) {
        this.drawString(guiGraphics, gui, this.getModuleName(), 8, 6, 0x404040);
    }

    @Override
    public int guiWidth() {
        return 15 + this.getInventoryWidth() * 18;
    }

    @Override
    public int guiHeight() {
        return 20 + this.getInventoryHeight() * 18;
    }

    @Override
    protected int getInventoryWidth() {
        return 8;
    }

    @Override
    protected int getInventoryHeight() {
        return 3;
    }

    public void fire() {
        if (this.getCart().level().isClientSide) {
            return;
        }
        ItemStack firework = this.getFirework();
        if (!firework.isEmpty()) {
            this.launchFirework(firework);
        }
    }

    @Nonnull
    private ItemStack getFirework() {
        int i;
        boolean hasGunpowder = false;
        boolean hasPaper = false;
        boolean canMakeCharge = false;
        for (i = 0; i < this.getInventorySize(); ++i) {
            ItemStack stack = this.getStack(i);
            if (stack.isEmpty() || !stack.is(Tags.Items.DYES) && !stack.is(Items.FIREWORK_STAR)) continue;
            canMakeCharge = true;
            break;
        }
        if (!canMakeCharge) {
            return ItemStack.EMPTY;
        }
        for (i = 0; i < this.getInventorySize(); ++i) {
            ItemStack item = this.getStack(i);
            if (item.isEmpty()) continue;
            if (item.getItem() == Items.FIREWORK_ROCKET) {
                ItemStack firework = item.copy();
                firework.setCount(1);
                this.removeItemStack(item, firework.getCount(), i);
                return firework;
            }
            if (item.getItem() == Items.PAPER) {
                hasPaper = true;
                continue;
            }
            if (item.getItem() != Items.GUNPOWDER) continue;
            hasGunpowder = true;
        }
        if (hasPaper && hasGunpowder) {
            ItemStack charge;
            int chargeCount;
            int maxGunpowder = this.getCart().random.nextInt(3) + 1;
            int countGunpowder = 0;
            boolean removedPaper = false;
            for (int j = 0; j < this.getInventorySize(); ++j) {
                ItemStack item2 = this.getStack(j);
                if (item2.isEmpty()) continue;
                if (item2.getItem() == Items.PAPER && !removedPaper) {
                    this.removeItemStack(item2, 1, j);
                    removedPaper = true;
                    continue;
                }
                if (item2.getItem() != Items.GUNPOWDER || countGunpowder >= maxGunpowder) continue;
                while (item2.getCount() > 0 && countGunpowder < maxGunpowder) {
                    ++countGunpowder;
                    this.removeItemStack(item2, 1, j);
                }
            }
            for (chargeCount = 1; chargeCount < 7 && this.getCart().random.nextInt(3 + chargeCount / 3) == 0; ++chargeCount) {
            }
            ArrayList<FireworkExplosion> explosions = new ArrayList<FireworkExplosion>();
            for (int k = 0; k < chargeCount && !(charge = this.getCharge()).isEmpty(); ++k) {
                if (!charge.has(DataComponents.FIREWORK_EXPLOSION)) continue;
                explosions.add((FireworkExplosion)charge.get(DataComponents.FIREWORK_EXPLOSION));
            }
            ItemStack firework = new ItemStack((ItemLike)Items.FIREWORK_ROCKET);
            firework.set(DataComponents.FIREWORKS, (Object)new Fireworks(countGunpowder, explosions));
            return firework;
        }
        return ItemStack.EMPTY;
    }

    private ItemStack getCharge() {
        ArrayList<Integer> starSlots = new ArrayList<Integer>();
        for (int i = 0; i < this.getInventorySize(); ++i) {
            ItemStack item = this.getStack(i);
            if (item.isEmpty() || item.getItem() != Items.FIREWORK_STAR) continue;
            starSlots.add(i);
        }
        RandomSource random = this.getCart().random;
        if (!starSlots.isEmpty()) {
            int slot = (Integer)starSlots.get(random.nextInt(starSlots.size()));
            ItemStack item = this.getStack(slot);
            ItemStack charge = item.copy();
            charge.setCount(1);
            this.removeItemStack(item, charge.getCount(), slot);
            return charge;
        }
        FireworkExplosion.Shape shape = FireworkExplosion.Shape.SMALL_BALL;
        IntArrayList colors = new IntArrayList();
        IntArrayList fadeColors = new IntArrayList();
        boolean hasTrail = false;
        boolean hasTwinkle = false;
        boolean attemptTrail = random.nextInt(16) == 0;
        boolean attemptTwinkle = random.nextInt(8) == 0;
        boolean attemptModifier = random.nextInt(4) == 0;
        FireworkExplosion.Shape wantedShape = FireworkExplosion.Shape.byId((int)(1 + random.nextInt(4)));
        boolean removedGunpowder = false;
        for (int j = 0; j < this.getInventorySize(); ++j) {
            ItemStack item = this.getStack(j);
            if (item.isEmpty() || item.getItem() != Items.GUNPOWDER || removedGunpowder) continue;
            this.removeItemStack(item, 1, j);
            removedGunpowder = true;
            break;
        }
        if (!removedGunpowder) {
            return ItemStack.EMPTY;
        }
        boolean removedModifier = false;
        boolean removedDiamond = false;
        boolean removedGlow = false;
        for (int j = 0; j < this.getInventorySize(); ++j) {
            ItemStack item = this.getStack(j);
            if (item.isEmpty()) continue;
            if (item.getItem() == Items.GLOWSTONE_DUST && attemptTwinkle && !removedGlow) {
                this.removeItemStack(item, 1, j);
                removedGlow = true;
                hasTwinkle = true;
                continue;
            }
            if (item.getItem() == Items.DIAMOND && attemptTrail && !removedDiamond) {
                this.removeItemStack(item, 1, j);
                removedDiamond = true;
                hasTrail = true;
                continue;
            }
            if (!attemptModifier || removedModifier || !(item.getItem() == Items.FIRE_CHARGE && wantedShape == FireworkExplosion.Shape.LARGE_BALL || item.getItem() == Items.GOLD_NUGGET && wantedShape == FireworkExplosion.Shape.STAR || item.is(ItemTags.SKULLS) && wantedShape == FireworkExplosion.Shape.CREEPER) && (item.getItem() != Items.FEATHER || wantedShape != FireworkExplosion.Shape.BURST)) continue;
            this.removeItemStack(item, 1, j);
            removedModifier = true;
            shape = wantedShape;
        }
        this.generateColors((IntList)colors, shape != FireworkExplosion.Shape.BURST ? 7 : 8);
        if (colors.isEmpty()) {
            return ItemStack.EMPTY;
        }
        if (this.getCart().random.nextInt(4) == 0) {
            this.generateColors((IntList)fadeColors, 8);
        }
        FireworkExplosion explosion = new FireworkExplosion(shape, (IntList)colors, (IntList)fadeColors, hasTrail, hasTwinkle);
        ItemStack charge = new ItemStack((ItemLike)Items.FIREWORK_STAR);
        charge.set(DataComponents.FIREWORK_EXPLOSION, (Object)explosion);
        return charge;
    }

    private void generateColors(IntList colours, int maxColorCount) {
        int colorCount;
        int[] maxColors = new int[16];
        int[] currentColors = new int[16];
        for (int i = 0; i < this.getInventorySize(); ++i) {
            DyeColor colour;
            ItemStack stack = this.getStack(i);
            if (stack.isEmpty() || !stack.is(Tags.Items.DYES) || (colour = DyeColor.getColor((ItemStack)stack)) == null) continue;
            int n = colour.getId();
            maxColors[n] = maxColors[n] + stack.getCount();
        }
        for (colorCount = this.getCart().random.nextInt(2) + 1; colorCount <= maxColorCount - 2 && this.getCart().random.nextInt(2) == 0; colorCount += 2) {
        }
        ArrayList<Integer> availableColours = new ArrayList<Integer>();
        for (int colourId = 0; colourId < 16; ++colourId) {
            if (maxColors[colourId] <= 0) continue;
            availableColours.add(colourId);
        }
        if (availableColours.isEmpty()) {
            return;
        }
        while (colorCount > 0 && !availableColours.isEmpty()) {
            int colorId;
            int randomPick = this.getCart().random.nextInt(availableColours.size());
            int n = colorId = ((Integer)availableColours.get(randomPick)).intValue();
            currentColors[n] = currentColors[n] + 1;
            int n2 = colorId;
            maxColors[n2] = maxColors[n2] - 1;
            if (maxColors[n2] <= 0) {
                availableColours.remove(randomPick);
            }
            colours.add(DyeColor.byId((int)colorId).getFireworkColor());
            --colorCount;
        }
        for (int k = 0; k < this.getInventorySize(); ++k) {
            int used;
            DyeColor colour;
            ItemStack stack = this.getStack(k);
            if (stack.isEmpty() || !stack.is(Tags.Items.DYES) || (colour = DyeColor.getColor((ItemStack)stack)) == null || (used = currentColors[colour.getId()]) <= 0) continue;
            used = Math.min(used, stack.getCount());
            this.removeItemStack(stack, used, k);
            int n = colour.getId();
            currentColors[n] = currentColors[n] - used;
        }
    }

    private void removeItemStack(@Nonnull ItemStack item, int count, int slot) {
        if (!this.getCart().hasCreativeSupplies()) {
            item.shrink(count);
            if (item.getCount() <= 0) {
                this.setStack(slot, ItemStack.EMPTY);
            }
        }
    }

    private void launchFirework(@Nonnull ItemStack firework) {
        FireworkRocketEntity rocket = new FireworkRocketEntity(this.getCart().level(), (double)this.getCart().blockPosition().getX(), (double)this.getCart().blockPosition().getY() + 1.0, (double)this.getCart().blockPosition().getZ(), firework);
        this.getCart().level().addFreshEntity((Entity)rocket);
    }
}

