/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevescarts.modules.workers;

import net.minecraft.core.BlockPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.FarmBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import vswe.stevescarts.api.modules.ModuleBase;
import vswe.stevescarts.api.modules.template.ModuleWorker;
import vswe.stevescarts.entities.EntityMinecartModular;
import vswe.stevescarts.modules.workers.tools.ModuleFarmer;

public class ModuleHydrater
extends ModuleWorker {
    private int range = 1;

    public ModuleHydrater(EntityMinecartModular cart) {
        super(cart);
    }

    @Override
    public byte getWorkPriority() {
        return 82;
    }

    @Override
    public void init() {
        super.init();
        for (ModuleBase module : this.getCart().getModules()) {
            if (!(module instanceof ModuleFarmer)) continue;
            ModuleFarmer moduleFarmer = (ModuleFarmer)module;
            this.range = moduleFarmer.getExternalRange();
            break;
        }
    }

    @Override
    public boolean work() {
        Level world = this.getCart().level();
        BlockPos next = this.getNextblock();
        for (int i = -this.range; i <= this.range; ++i) {
            for (int j = -this.range; j <= this.range; ++j) {
                if (!this.hydrate(world, next.offset(i, -1, j))) continue;
                return true;
            }
        }
        return false;
    }

    private boolean hydrate(Level world, BlockPos pos) {
        int moisture;
        BlockState state = world.getBlockState(pos);
        if (state.getBlock() == Blocks.FARMLAND && (moisture = ((Integer)state.getValue((Property)FarmBlock.MOISTURE)).intValue()) != 7) {
            FluidStack waterCost = new FluidStack((Fluid)Fluids.WATER, 7 - moisture);
            FluidStack drained = this.getCart().drain(waterCost, IFluidHandler.FluidAction.SIMULATE);
            if (drained.getAmount() > 0) {
                if (this.doPreWork()) {
                    this.startWorking(2 + drained.getAmount());
                    return true;
                }
                this.stopWorking();
                this.getCart().drain(drained, IFluidHandler.FluidAction.EXECUTE);
                world.setBlock(pos, (BlockState)state.setValue((Property)FarmBlock.MOISTURE, (Comparable)Integer.valueOf(moisture + drained.getAmount())), 3);
            }
        }
        return false;
    }
}

