/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevescarts.network.packets;

import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.PacketFlow;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import net.neoforged.neoforge.network.handling.IPayloadHandler;
import vswe.stevescarts.blocks.tileentities.TileEntityManager;

public class PacketCargpManager
implements CustomPacketPayload {
    public static final CustomPacketPayload.Type<PacketCargpManager> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"stevescarts", (String)"cargo_manager"));
    private final BlockPos blockPos;
    private final int id;
    private final byte[] array;

    public PacketCargpManager(BlockPos blockPos, int id, byte[] array) {
        this.blockPos = blockPos;
        this.id = id;
        this.array = array;
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public void write(FriendlyByteBuf buf) {
        buf.writeBlockPos(this.blockPos);
        buf.writeInt(this.id);
        buf.writeByteArray(this.array);
    }

    public static PacketCargpManager read(FriendlyByteBuf buffer) {
        return new PacketCargpManager(buffer.readBlockPos(), buffer.readInt(), buffer.readByteArray());
    }

    public static class Handler
    implements IPayloadHandler<PacketCargpManager> {
        public void handle(PacketCargpManager msg, IPayloadContext ctx) {
            if (ctx.flow() != PacketFlow.SERVERBOUND) {
                return;
            }
            ctx.enqueueWork(() -> {
                Player patt0$temp;
                if (msg.blockPos != null && (patt0$temp = ctx.player()) instanceof ServerPlayer) {
                    BlockEntity patt1$temp;
                    ServerPlayer player = (ServerPlayer)patt0$temp;
                    BlockPos blockPos = msg.blockPos;
                    if (player.level().getBlockEntity(blockPos) != null && (patt1$temp = player.level().getBlockEntity(blockPos)) instanceof TileEntityManager) {
                        TileEntityManager manager = (TileEntityManager)patt1$temp;
                        manager.receivePacket(msg.id, msg.array, (Player)player);
                    }
                }
            });
        }
    }
}

