/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevescarts.network.packets;

import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.protocol.PacketFlow;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import net.neoforged.neoforge.network.handling.IPayloadHandler;
import vswe.stevescarts.blocks.tileentities.TileEntityLiquid;
import vswe.stevescarts.blocks.tileentities.TileEntityUpgrade;

public class PacketFluidSync
implements CustomPacketPayload {
    public static final CustomPacketPayload.Type<PacketFluidSync> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"stevescarts", (String)"fluid_sync"));
    private FluidStack fluidStack;
    private BlockPos pos;
    private int tankID;

    public PacketFluidSync(FluidStack fluidStack, BlockPos pos, int tankID) {
        this.fluidStack = fluidStack;
        this.pos = pos;
        this.tankID = tankID;
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public void write(RegistryFriendlyByteBuf buf) {
        buf.writeBoolean(this.fluidStack.isEmpty());
        if (!this.fluidStack.isEmpty()) {
            FluidStack.STREAM_CODEC.encode((Object)buf, (Object)this.fluidStack);
        }
        buf.writeBlockPos(this.pos);
        buf.writeInt(this.tankID);
    }

    public static PacketFluidSync read(RegistryFriendlyByteBuf buffer) {
        boolean empty = buffer.readBoolean();
        FluidStack fstack = empty ? FluidStack.EMPTY : (FluidStack)FluidStack.STREAM_CODEC.decode((Object)buffer);
        return new PacketFluidSync(fstack, buffer.readBlockPos(), buffer.readInt());
    }

    public static class Handler
    implements IPayloadHandler<PacketFluidSync> {
        public void handle(PacketFluidSync msg, IPayloadContext ctx) {
            if (ctx.flow() != PacketFlow.CLIENTBOUND) {
                return;
            }
            ctx.enqueueWork(() -> {
                ClientLevel level = Minecraft.getInstance().level;
                if (level == null) {
                    return;
                }
                BlockEntity tile = level.getBlockEntity(msg.pos);
                if (tile instanceof TileEntityLiquid) {
                    TileEntityLiquid entityLiquid = (TileEntityLiquid)tile;
                    entityLiquid.tanks[msg.tankID].setFluid(msg.fluidStack);
                } else if (tile instanceof TileEntityUpgrade) {
                    TileEntityUpgrade entityUpgrade = (TileEntityUpgrade)tile;
                    entityUpgrade.tank.setFluid(msg.fluidStack);
                }
            });
        }
    }
}

