/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevescarts.upgrades;

import java.util.ArrayList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.Container;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.SimpleContainerData;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import vswe.stevescarts.api.IModuleItem;
import vswe.stevescarts.api.modules.data.ModuleData;
import vswe.stevescarts.api.modules.data.ModuleDataHull;
import vswe.stevescarts.api.upgrades.BaseUpgradeEffect;
import vswe.stevescarts.blocks.tileentities.TileEntityCartAssembler;
import vswe.stevescarts.blocks.tileentities.TileEntityUpgrade;
import vswe.stevescarts.containers.ContainerCartAssembler;
import vswe.stevescarts.containers.slots.SlotAssemblerFuel;
import vswe.stevescarts.containers.slots.SlotModule;
import vswe.stevescarts.helpers.Localization;
import vswe.stevescarts.helpers.storages.TransferHandler;
import vswe.stevescarts.upgrades.Blueprint;
import vswe.stevescarts.upgrades.SimpleInventoryUpgradeEffect;

public class InputChest
extends SimpleInventoryUpgradeEffect {
    public InputChest(int inventoryWidth, int inventoryHeight) {
        super(inventoryWidth, inventoryHeight);
    }

    @Override
    public Component getName() {
        return Localization.translate("info.stevescarts.effectInputChest", this.getInventorySize());
    }

    @Override
    public void init(TileEntityUpgrade upgrade) {
        upgrade.getCompound().putByte("TransferCooldown", (byte)0);
    }

    @Override
    public Class<? extends Slot> getSlot(int i) {
        return SlotModule.class;
    }

    @Override
    public void update(TileEntityUpgrade upgrade) {
        if (upgrade.getLevel() == null) {
            return;
        }
        if (!upgrade.getLevel().isClientSide && upgrade.getMaster() != null) {
            CompoundTag comp = upgrade.getCompound();
            if (comp.getByte("TransferCooldown") != 0) {
                comp.putByte("TransferCooldown", (byte)(comp.getByte("TransferCooldown") - 1));
            } else {
                comp.putByte("TransferCooldown", (byte)20);
                for (int slotId = 0; slotId < upgrade.getUpgrade().getInventorySize(); ++slotId) {
                    IModuleItem itemCartModule;
                    ModuleData module;
                    ItemStack itemstack = upgrade.getItem(slotId);
                    if (itemstack.isEmpty() || (module = (itemCartModule = (IModuleItem)itemstack.getItem()).getModuleData()) == null || !this.isValidForBluePrint(upgrade.getMaster(), module) || this.willInvalidate(upgrade.getMaster(), module)) continue;
                    int stackSize = itemstack.getCount();
                    TransferHandler.TransferItem(itemstack, (Container)upgrade.getMaster(), (AbstractContainerMenu)new ContainerCartAssembler(0, null, upgrade.getMaster(), new SimpleContainerData(17)), Slot.class, SlotAssemblerFuel.class, 1);
                    if (itemstack.getCount() == 0) {
                        upgrade.setItem(slotId, ItemStack.EMPTY);
                    }
                    if (stackSize != itemstack.getCount()) break;
                }
            }
        }
    }

    private boolean willInvalidate(TileEntityCartAssembler assembler, ModuleData module) {
        ModuleDataHull hull = assembler.getHullModule();
        if (hull == null) {
            return false;
        }
        ArrayList<ModuleData> modules = assembler.getNonHullModules();
        modules.add(module);
        return ModuleData.checkForErrors(hull, modules) != null;
    }

    private boolean isValidForBluePrint(TileEntityCartAssembler assembler, ModuleData module) {
        for (TileEntityUpgrade tile : assembler.getUpgradeTiles()) {
            for (BaseUpgradeEffect effect : tile.getUpgrade().getEffects()) {
                if (!(effect instanceof Blueprint)) continue;
                return ((Blueprint)effect).isValidForBluePrint(tile, assembler.getModules(true), module);
            }
        }
        return true;
    }
}

