/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevescarts.upgrades;

import net.minecraft.network.chat.Component;
import net.minecraft.world.level.material.Fluids;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import vswe.stevescarts.blocks.tileentities.TileEntityUpgrade;
import vswe.stevescarts.helpers.Localization;
import vswe.stevescarts.upgrades.TankUpgradeEffect;

public class ThermalFuel
extends TankUpgradeEffect {
    public static final int LAVA_EFFICIENCY = 3;

    @Override
    public int getTankSize() {
        return 12000;
    }

    @Override
    public Component getName() {
        return Localization.translate("info.stevescarts.effectThermal", new Object[0]);
    }

    @Override
    public void update(TileEntityUpgrade upgrade) {
        FluidStack drain;
        int fuelspace;
        int unitspace;
        super.update(upgrade);
        if (upgrade.getLevel() == null) {
            return;
        }
        if (!upgrade.getLevel().isClientSide && upgrade.getMaster() != null && !upgrade.tank.getFluid().isEmpty() && (unitspace = Math.min((fuelspace = upgrade.getMaster().getMaxFuelLevel() - upgrade.getMaster().getFuelLevel()) / 3, 200)) > 100 && upgrade.tank.getFluid().getFluid().equals(Fluids.LAVA) && !(drain = upgrade.tank.drain(unitspace, IFluidHandler.FluidAction.SIMULATE)).isEmpty() && drain.getAmount() > 0) {
            upgrade.getMaster().setFuelLevel(upgrade.getMaster().getFuelLevel() + drain.getAmount() * 3);
            upgrade.tank.drain(unitspace, IFluidHandler.FluidAction.EXECUTE);
        }
    }
}

