/*
 * Decompiled with CFR 0.152.
 */
package com.faboslav.structurify.common.commands;

import com.faboslav.structurify.common.Structurify;
import com.faboslav.structurify.common.mixin.LocateCommandInvoker;
import com.google.common.base.Stopwatch;
import com.google.common.base.Ticker;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.datafixers.util.Pair;
import java.time.Duration;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import net.minecraft.Util;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.ResourceOrTagKeyArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Position;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.commands.LocateCommand;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.levelgen.structure.Structure;

public final class StructurifyCommand {
    public static void createCommand(CommandDispatcher<CommandSourceStack> dispatcher, CommandBuildContext context) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"structurify").requires(source -> source.hasPermission(2))).then(Commands.literal((String)"dump").executes(ctx -> {
            Structurify.getConfig().dump();
            ((CommandSourceStack)ctx.getSource()).sendSuccess(() -> Component.literal((String)("Structurify config dumped to \"" + String.valueOf(Structurify.getConfig().configDumpPath) + "\".")), !((CommandSourceStack)ctx.getSource()).isPlayer());
            return 1;
        }))).then(Commands.literal((String)"locate").then(Commands.literal((String)"structure").then(Commands.argument((String)"structure", (ArgumentType)ResourceOrTagKeyArgument.resourceOrTagKey((ResourceKey)Registries.STRUCTURE)).executes(commandContext -> StructurifyCommand.locateStructure((CommandSourceStack)commandContext.getSource(), (ResourceOrTagKeyArgument.Result<Structure>)ResourceOrTagKeyArgument.getResourceOrTagKey((CommandContext)commandContext, (String)"structure", (ResourceKey)Registries.STRUCTURE, (DynamicCommandExceptionType)LocateCommandInvoker.structurify$getStructureInvalidError())))))));
    }

    private static int locateStructure(CommandSourceStack source, ResourceOrTagKeyArgument.Result<Structure> structure) throws CommandSyntaxException {
        ServerLevel serverLevel = source.getLevel();
        BlockPos blockPos = BlockPos.containing((Position)source.getPosition());
        Registry registry = source.getLevel().registryAccess().registryOrThrow(Registries.STRUCTURE);
        HolderSet holderSet = (HolderSet)LocateCommandInvoker.structurify$invokeGetHolders(structure, (Registry<Structure>)registry).orElseThrow(() -> LocateCommandInvoker.structurify$getStructureInvalidError().create((Object)structure.asPrintable()));
        source.sendSuccess(() -> Component.literal((String)("Locating " + structure.asPrintable() + " in the radius of " + LocateCommandInvoker.structurify$getMaxStructureSearchRadius() + " chunks")), false);
        Stopwatch stopwatch = Stopwatch.createStarted((Ticker)Util.TICKER);
        CompletableFuture.supplyAsync(() -> serverLevel.getChunkSource().getGenerator().findNearestMapStructure(serverLevel, holderSet, blockPos, LocateCommandInvoker.structurify$getMaxStructureSearchRadius(), false), Util.backgroundExecutor()).thenAcceptAsync(pair -> {
            stopwatch.stop();
            source.getServer().execute(() -> {
                if (pair == null) {
                    source.sendFailure((Component)Component.translatable((String)LocateCommandInvoker.structurify$getStructureNotFoundError().create((Object)structure.asPrintable()).getLocalizedMessage()));
                } else {
                    LocateCommand.showLocateResult((CommandSourceStack)source, (ResourceOrTagKeyArgument.Result)structure, (BlockPos)blockPos, (Pair)pair, (String)"commands.locate.structure.success", (boolean)false, (Duration)stopwatch.elapsed());
                }
            });
        }, (Executor)Util.backgroundExecutor());
        return 0;
    }
}

