/*
 * Decompiled with CFR 0.152.
 */
package com.faboslav.structurify.common.config.client.gui;

import com.faboslav.structurify.common.Structurify;
import com.faboslav.structurify.common.config.client.gui.StructureSetsConfigScreen;
import com.faboslav.structurify.common.config.client.gui.StructuresConfigScreen;
import com.faboslav.structurify.common.config.client.gui.StructurifyConfigScreenState;
import com.faboslav.structurify.common.config.client.gui.widget.DynamicGridWidget;
import com.faboslav.structurify.common.config.client.gui.widget.ImageButtonWidget;
import com.faboslav.structurify.common.mixin.yacl.CategoryTabAccessor;
import com.faboslav.structurify.common.mixin.yacl.GroupSeparatorEntryAccessor;
import dev.isxander.yacl3.gui.OptionListWidget;
import dev.isxander.yacl3.gui.YACLScreen;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.components.tabs.Tab;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.Nullable;

public class StructurifyConfigScreen
extends Screen {
    private final Screen parent;
    private final StructureSetsConfigScreen structureSetsConfigScreen = new StructureSetsConfigScreen();
    @Nullable
    public YACLScreen structuresScreen = null;
    @Nullable
    public Map<String, YACLScreen> structureScreens = new HashMap<String, YACLScreen>();
    public Map<String, StructurifyConfigScreenState> screenStates = new HashMap<String, StructurifyConfigScreenState>();

    public StructurifyConfigScreen(@Nullable Screen parent) {
        super((Component)Component.translatable((String)"structurify"));
        this.parent = parent;
    }

    public StructureSetsConfigScreen getStructureSetsScreen() {
        return this.structureSetsConfigScreen;
    }

    public void onClose() {
        assert (this.minecraft != null);
        this.minecraft.setScreen(this.parent);
    }

    public void render(GuiGraphics context, int mouseX, int mouseY, float delta) {
        super.renderBackground(context, mouseX, mouseY, delta);
        super.render(context, mouseX, mouseY, delta);
        assert (this.minecraft != null);
        context.drawCenteredString(this.minecraft.font, (Component)Component.translatable((String)"gui.structurify.title"), this.width / 2, 10, 0xFFFFFF);
    }

    protected void init() {
        super.init();
        Objects.requireNonNull(this.font);
        int fontHeight = 9;
        DynamicGridWidget grid = new DynamicGridWidget(10, 10 + fontHeight + 10, this.width - 13, this.height - 20 - fontHeight - 10 - 20);
        grid.setPadding(3);
        grid.addChild(new ImageButtonWidget(0, 0, 0, 0, (Component)Component.translatable((String)"gui.structurify.structures_category.title"), Structurify.makeId("textures/gui/config/images/buttons/structures.webp"), btn -> {
            if (this.structuresScreen == null) {
                this.structuresScreen = StructuresConfigScreen.createConfigGui(Structurify.getConfig(), this);
            }
            this.minecraft.setScreen((Screen)this.structuresScreen);
            this.loadScreenState(this.structuresScreen);
        }), 2, 1);
        grid.addChild(new ImageButtonWidget(0, 0, 0, 0, (Component)Component.translatable((String)"gui.structurify.structure_sets_category.title"), Structurify.makeId("textures/gui/config/images/buttons/structure_sets.webp"), btn -> {
            YACLScreen structureSetsScreen = this.structureSetsConfigScreen.getStructureSetsScreen();
            if (structureSetsScreen == null) {
                this.structureSetsConfigScreen.createStructureSetsScreen(Structurify.getConfig(), this);
                structureSetsScreen = this.structureSetsConfigScreen.getStructureSetsScreen();
            }
            this.minecraft.setScreen((Screen)structureSetsScreen);
            this.loadScreenState(structureSetsScreen);
        }), 2, 1);
        grid.calculateLayout();
        grid.visitWidgets(x$0 -> {
            AbstractWidget cfr_ignored_0 = (AbstractWidget)this.addRenderableWidget((GuiEventListener)x$0);
        });
        int kofiButtonWidth = 135;
        int discordButtonWidth = 135;
        int discordAndKoFiButtonsWidth = kofiButtonWidth + discordButtonWidth + 30;
        int doneButtonWidth = this.width - discordAndKoFiButtonsWidth;
        Button buttonWidget = Button.builder((Component)CommonComponents.GUI_DONE, btn -> this.minecraft.setScreen(this.parent)).bounds(this.width / 2 - doneButtonWidth / 2, this.height - 30, doneButtonWidth, 20).build();
        Button donateButton = Button.builder((Component)Component.literal((String)"Buy Me a Coffee").withStyle(ChatFormatting.GOLD).withStyle(ChatFormatting.BOLD), btn -> Util.getPlatform().openUri("https://ko-fi.com/faboslav")).bounds(10, this.height - 30, kofiButtonWidth, 20).build();
        Button discordButton = Button.builder((Component)Component.literal((String)"Join Our Discord").withStyle(ChatFormatting.AQUA).withStyle(ChatFormatting.BOLD), btn -> Util.getPlatform().openUri("https://discord.gg/faboland")).bounds(this.width - discordButtonWidth - 10, this.height - 30, discordButtonWidth, 20).build();
        this.addRenderableWidget((GuiEventListener)buttonWidget);
        this.addRenderableWidget((GuiEventListener)donateButton);
        this.addRenderableWidget((GuiEventListener)discordButton);
    }

    public void saveScreenState(YACLScreen yaclScreen) {
        Tab currentTab = yaclScreen.tabNavigationBar.getTabManager().getCurrentTab();
        if (currentTab instanceof YACLScreen.CategoryTab) {
            YACLScreen.CategoryTab yaclCategoryTab = (YACLScreen.CategoryTab)currentTab;
            CategoryTabAccessor categoryTab = (CategoryTabAccessor)yaclCategoryTab;
            OptionListWidget optionListWidget = (OptionListWidget)categoryTab.getOptionList().getList();
            HashMap<String, Boolean> collapsedGroups = new HashMap<String, Boolean>();
            for (OptionListWidget.Entry entry : optionListWidget.children()) {
                if (!(entry instanceof OptionListWidget.GroupSeparatorEntry)) continue;
                OptionListWidget.GroupSeparatorEntry groupSeparatorEntry = (OptionListWidget.GroupSeparatorEntry)entry;
                GroupSeparatorEntryAccessor yaclGroupSeparatorEntry = (GroupSeparatorEntryAccessor)entry;
                String groupName = yaclGroupSeparatorEntry.getGroup().name().getString();
                if (collapsedGroups.containsKey(groupName)) continue;
                collapsedGroups.put(groupName, groupSeparatorEntry.isExpanded());
            }
            this.screenStates.put(yaclScreen.getTitle().getString(), new StructurifyConfigScreenState(categoryTab.getSearchField().getValue(), optionListWidget.getScrollAmount(), collapsedGroups));
        }
    }

    public void loadScreenState(YACLScreen yaclScreen) {
        Tab currentTab = yaclScreen.tabNavigationBar.getTabManager().getCurrentTab();
        if (currentTab instanceof YACLScreen.CategoryTab) {
            YACLScreen.CategoryTab categoryTab = (YACLScreen.CategoryTab)currentTab;
            StructurifyConfigScreenState screenState = this.screenStates.get(yaclScreen.getTitle().getString());
            if (screenState != null) {
                CategoryTabAccessor yaclScreenCategoryTab = (CategoryTabAccessor)categoryTab;
                OptionListWidget optionListWidget = (OptionListWidget)yaclScreenCategoryTab.getOptionList().getList();
                yaclScreenCategoryTab.getSearchField().setValue(screenState.lastSearchText());
                ((OptionListWidget)yaclScreenCategoryTab.getOptionList().getList()).setScrollAmount(screenState.lastScrollAmount());
                for (OptionListWidget.Entry entry : optionListWidget.children()) {
                    if (!(entry instanceof OptionListWidget.GroupSeparatorEntry)) continue;
                    OptionListWidget.GroupSeparatorEntry groupSeparatorEntry = (OptionListWidget.GroupSeparatorEntry)entry;
                    GroupSeparatorEntryAccessor yaclGroupSeparatorEntry = (GroupSeparatorEntryAccessor)entry;
                    String groupName = yaclGroupSeparatorEntry.getGroup().name().getString();
                    Boolean isGroupCollapsed = screenState.collapsedGroups().getOrDefault(groupName, false);
                    groupSeparatorEntry.setExpanded(isGroupCollapsed.booleanValue());
                }
            }
        }
    }
}

