/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.client.particles;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import net.mehvahdjukaar.supplementaries.reg.ModRegistry;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TerrainParticle;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.material.FluidState;

public class SugarParticle
extends TerrainParticle {
    public static final ParticleRenderType TERRAIN_SHEET_OPAQUE = new ParticleRenderType(){

        public BufferBuilder begin(Tesselator tesselator, TextureManager textureManager) {
            RenderSystem.disableBlend();
            RenderSystem.defaultBlendFunc();
            RenderSystem.depthMask((boolean)true);
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)TextureAtlas.LOCATION_BLOCKS);
            return tesselator.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.PARTICLE);
        }

        public String toString() {
            return "TERRAIN_SHEET_OPAQUE";
        }
    };

    public SugarParticle(ClientLevel clientLevel, double x, double y, double z, double speedX, double speedY, double speedZ) {
        super(clientLevel, x, y, z, speedX, speedY, speedZ, ModRegistry.SUGAR_CUBE.get().defaultBlockState());
        this.lifetime = (int)(40.0f / (this.random.nextFloat() * 0.7f + 0.3f));
        this.setColor(1.0f, 1.0f, 1.0f);
        this.xd *= 0.6;
        this.zd *= 0.6;
    }

    public void tick() {
        this.xo = this.x;
        this.yo = this.y;
        this.zo = this.z;
        BlockPos pos = BlockPos.containing((double)this.x, (double)this.y, (double)this.z);
        FluidState fluid = this.level.getFluidState(pos);
        boolean wasTouchingWater = fluid.is(FluidTags.WATER);
        if (wasTouchingWater && Math.abs(this.y - (double)pos.getY() - (double)fluid.getOwnHeight()) < 0.01 && this.level.getFluidState(pos.above()).isEmpty()) {
            this.gravity = 0.0f;
            this.yd = 0.0;
        } else {
            this.gravity = wasTouchingWater ? -0.05f : 1.0f;
        }
        super.tick();
        if (this.gravity != 0.0f) {
            BlockPos pos2 = BlockPos.containing((double)this.x, (double)this.y, (double)this.z);
            FluidState fluid2 = this.level.getFluidState(pos2);
            boolean isTouchingWater = fluid2.is(FluidTags.WATER);
            if (wasTouchingWater && !isTouchingWater) {
                this.setPos(this.x, (double)((float)pos.getY() + fluid.getHeight((BlockGetter)this.level, pos)) - 0.005, this.z);
                this.gravity = 0.0f;
            }
            if (!wasTouchingWater && isTouchingWater) {
                this.setPos(this.x, (double)((float)pos2.getY() + fluid2.getHeight((BlockGetter)this.level, pos2)) - 0.005, this.z);
                this.gravity = 0.0f;
            }
        }
    }

    public ParticleRenderType getRenderType() {
        return TERRAIN_SHEET_OPAQUE;
    }

    public static class Factory
    implements ParticleProvider<SimpleParticleType> {
        public Factory(SpriteSet set) {
        }

        public Particle createParticle(SimpleParticleType type, ClientLevel level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            return new SugarParticle(level, x, y, z, xSpeed, ySpeed, zSpeed);
        }
    }
}

