/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.client.renderers.tiles;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.mehvahdjukaar.moonlight.api.client.util.RotHlpr;
import net.mehvahdjukaar.moonlight.api.client.util.VertexUtil;
import net.mehvahdjukaar.supplementaries.client.ModMaterials;
import net.mehvahdjukaar.supplementaries.common.block.tiles.FlagBlockTile;
import net.mehvahdjukaar.supplementaries.configs.ClientConfigs;
import net.minecraft.client.GraphicsStatus;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BannerRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelBakery;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.FastColor;
import net.minecraft.util.Mth;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.block.entity.BannerPattern;
import net.minecraft.world.level.block.entity.BannerPatternLayers;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.AABB;
import org.joml.Quaternionf;

public class FlagBlockTileRenderer
implements BlockEntityRenderer<FlagBlockTile> {
    private final Minecraft minecraft = Minecraft.getInstance();
    private final ModelPart bannerModel;

    public FlagBlockTileRenderer(BlockEntityRendererProvider.Context context) {
        ModelPart modelpart = context.bakeLayer(ModelLayers.BANNER);
        this.bannerModel = modelpart.getChild("flag");
    }

    public AABB getRenderBoundingBox(BlockEntity tile) {
        Direction dir = ((FlagBlockTile)tile).getDirection();
        return new AABB(0.25, 0.0, 0.25, 0.75, 1.0, 0.75).expandTowards((double)((float)dir.getStepX() * 1.35f), 0.0, (double)((float)dir.getStepZ() * 1.35f)).move(tile.getBlockPos());
    }

    public int getViewDistance() {
        return 128;
    }

    public static void renderBanner(ModelPart bannerModel, float ang, PoseStack matrixStack, MultiBufferSource bufferSource, int light, int pPackedOverlay, BannerPatternLayers patterns, DyeColor baseColor) {
        matrixStack.pushPose();
        matrixStack.scale(0.6666667f, -0.6666667f, -0.6666667f);
        matrixStack.mulPose(Axis.YP.rotationDegrees(0.05f * ang));
        bannerModel.xRot = 1.5707964f;
        bannerModel.yRot = (float)Math.PI;
        bannerModel.zRot = 1.5707964f;
        bannerModel.y = -12.0f;
        bannerModel.x = 1.5f;
        BannerRenderer.renderPatterns((PoseStack)matrixStack, (MultiBufferSource)bufferSource, (int)light, (int)pPackedOverlay, (ModelPart)bannerModel, (Material)ModelBakery.BANNER_BASE, (boolean)true, (DyeColor)baseColor, (BannerPatternLayers)patterns);
        matrixStack.popPose();
    }

    public void render(FlagBlockTile tile, float partialTicks, PoseStack poseStack, MultiBufferSource bufferIn, int combinedLightIn, int combinedOverlayIn) {
        BannerPatternLayers patterns = tile.getPatterns();
        int lu = VertexUtil.lightU((int)combinedLightIn);
        int lv = VertexUtil.lightV((int)combinedLightIn);
        int w = 24;
        int h = 16;
        poseStack.pushPose();
        poseStack.translate(0.5, 0.0, 0.5);
        poseStack.mulPose(RotHlpr.rot((Direction)tile.getDirection().getOpposite()));
        poseStack.translate(0.0f, 0.0f, 0.0625f);
        long time = tile.getLevel().getGameTime();
        double l = ClientConfigs.Blocks.FLAG_WAVELENGTH.get();
        long period = ClientConfigs.Blocks.FLAG_PERIOD.get().intValue();
        double wavyness = ClientConfigs.Blocks.FLAG_AMPLITUDE.get();
        double invdamping = ClientConfigs.Blocks.FLAG_AMPLITUDE_INCREMENT.get();
        BlockPos bp = tile.getBlockPos();
        float t = ((float)Math.floorMod((long)bp.getX() * 7L + (long)bp.getZ() * 13L + time, period) + partialTicks) / (float)period;
        DyeColor color = tile.getColor();
        if (ClientConfigs.Blocks.FLAG_BANNER.get().booleanValue()) {
            float ang = (float)((wavyness + invdamping * (double)w) * (double)Mth.sin((float)((float)((double)w / l - (double)(t * 2.0f * (float)Math.PI)))));
            FlagBlockTileRenderer.renderBanner(this.bannerModel, ang, poseStack, bufferIn, combinedLightIn, combinedOverlayIn, patterns, color);
        } else {
            int segmentLen = ((GraphicsStatus)this.minecraft.options.graphicsMode().get()).getId() >= ClientConfigs.Blocks.FLAG_FANCINESS.get().ordinal() ? 1 : w;
            float oldAng = 0.0f;
            for (int dX = 0; dX < w; dX += segmentLen) {
                float ang = (float)((wavyness + invdamping * (double)dX) * (double)Mth.sin((float)((float)((double)dX / l - (double)(t * 2.0f * (float)Math.PI)))));
                FlagBlockTileRenderer.renderPatterns(bufferIn, poseStack, patterns, lu, lv, dX, w, h, segmentLen, ang, oldAng, color);
                poseStack.mulPose(Axis.YP.rotationDegrees(ang));
                poseStack.translate(0.0f, 0.0f, (float)segmentLen / 16.0f);
                poseStack.mulPose(Axis.YP.rotationDegrees(-ang));
                oldAng = ang;
            }
        }
        poseStack.popPose();
    }

    public static void renderPatterns(PoseStack matrixStackIn, MultiBufferSource bufferIn, BannerPatternLayers patterns, int combinedLightIn, DyeColor baseColor) {
        int lu = VertexUtil.lightU((int)combinedLightIn);
        int lv = VertexUtil.lightV((int)combinedLightIn);
        FlagBlockTileRenderer.renderPatterns(bufferIn, matrixStackIn, patterns, lu, lv, 0, 24, 16, 24, 0.0f, 0.0f, baseColor);
    }

    private static void renderPatterns(MultiBufferSource bufferIn, PoseStack poseStack, BannerPatternLayers list, int lu, int lv, int dX, int w, int h, int segmentLen, float ang, float oldAng, DyeColor baseColor) {
        FlagBlockTileRenderer.renderLayer(bufferIn, poseStack, lu, lv, dX, w, h, segmentLen, ang, oldAng, ModMaterials.FLAG_BASE_MATERIAL, true, baseColor);
        for (BannerPatternLayers.Layer layer : list.layers()) {
            Material material = ModMaterials.FLAG_MATERIALS.apply((BannerPattern)layer.pattern().value());
            DyeColor dyeColor = layer.color();
            FlagBlockTileRenderer.renderLayer(bufferIn, poseStack, lu, lv, dX, w, h, segmentLen, ang, oldAng, material, false, dyeColor);
        }
    }

    private static void renderLayer(MultiBufferSource bufferIn, PoseStack matrixStackIn, int lu, int lv, int dX, int w, int h, int segmentlen, float ang, float oldAng, Material material, boolean solid, DyeColor dyeColor) {
        if (material == null) {
            return;
        }
        VertexConsumer builder = material.buffer(bufferIn, solid ? RenderType::entitySolid : RenderType::entityNoOutline);
        matrixStackIn.pushPose();
        int color = dyeColor.getTextureDiffuseColor();
        float b = (float)FastColor.ARGB32.blue((int)color) / 255.0f;
        float g = (float)FastColor.ARGB32.green((int)color) / 255.0f;
        float r = (float)FastColor.ARGB32.red((int)color) / 255.0f;
        FlagBlockTileRenderer.renderCurvedSegment(builder, matrixStackIn, ang, oldAng, dX, segmentlen, h, lu, lv, dX + segmentlen >= w, r, g, b);
        matrixStackIn.popPose();
    }

    private static void renderCurvedSegment(VertexConsumer builder, PoseStack matrixStack, float angle, float oldAng, int dX, int length, int height, int lu, int lv, boolean end, float r, float g, float b) {
        float textW = 32.0f;
        float textH = 16.0f;
        float u = (float)dX / textW;
        float v = 0.0f;
        float maxV = v + (float)height / textH;
        float maxU = u + (float)length / textW;
        float w = 0.0625f;
        float hw = w / 2.0f;
        float l = (float)length / 16.0f;
        float h = (float)height / 16.0f;
        float pU = maxU - 1.0f / textW;
        float pV = maxV - w;
        float pV2 = w;
        Quaternionf rot = Axis.YP.rotationDegrees(angle);
        Quaternionf oldRot = Axis.YP.rotationDegrees(oldAng);
        Quaternionf rotInc = Axis.YP.rotationDegrees(angle - oldAng);
        Quaternionf rotInv = Axis.YP.rotationDegrees(-angle);
        int nx = 1;
        boolean nz = false;
        boolean ny = false;
        matrixStack.pushPose();
        matrixStack.translate(hw, 0.0f, 0.0f);
        matrixStack.mulPose(oldRot);
        VertexUtil.vert((VertexConsumer)builder, (PoseStack)matrixStack, (float)0.0f, (float)0.0f, (float)0.0f, (float)u, (float)maxV, (float)r, (float)g, (float)b, (float)1.0f, (int)lu, (int)lv, (float)nx, (float)((float)ny), (float)((float)nz));
        VertexUtil.vert((VertexConsumer)builder, (PoseStack)matrixStack, (float)0.0f, (float)h, (float)0.0f, (float)u, (float)v, (float)r, (float)g, (float)b, (float)1.0f, (int)lu, (int)lv, (float)nx, (float)((float)ny), (float)((float)nz));
        matrixStack.mulPose(rotInc);
        matrixStack.translate(0.0f, 0.0f, l);
        VertexUtil.vert((VertexConsumer)builder, (PoseStack)matrixStack, (float)0.0f, (float)h, (float)0.0f, (float)maxU, (float)v, (float)r, (float)g, (float)b, (float)1.0f, (int)lu, (int)lv, (float)nx, (float)((float)ny), (float)((float)nz));
        VertexUtil.vert((VertexConsumer)builder, (PoseStack)matrixStack, (float)0.0f, (float)0.0f, (float)0.0f, (float)maxU, (float)maxV, (float)r, (float)g, (float)b, (float)1.0f, (int)lu, (int)lv, (float)nx, (float)((float)ny), (float)((float)nz));
        matrixStack.popPose();
        matrixStack.pushPose();
        matrixStack.translate(-hw, 0.0f, 0.0f);
        matrixStack.mulPose(oldRot);
        VertexUtil.vert((VertexConsumer)builder, (PoseStack)matrixStack, (float)0.0f, (float)h, (float)0.0f, (float)u, (float)v, (float)r, (float)g, (float)b, (float)1.0f, (int)lu, (int)lv, (float)(-nx), (float)((float)ny), (float)((float)nz));
        VertexUtil.vert((VertexConsumer)builder, (PoseStack)matrixStack, (float)0.0f, (float)0.0f, (float)0.0f, (float)u, (float)maxV, (float)r, (float)g, (float)b, (float)1.0f, (int)lu, (int)lv, (float)(-nx), (float)((float)ny), (float)((float)nz));
        matrixStack.mulPose(rotInc);
        matrixStack.translate(0.0f, 0.0f, l);
        VertexUtil.vert((VertexConsumer)builder, (PoseStack)matrixStack, (float)0.0f, (float)0.0f, (float)0.0f, (float)maxU, (float)maxV, (float)r, (float)g, (float)b, (float)1.0f, (int)lu, (int)lv, (float)(-nx), (float)((float)ny), (float)((float)nz));
        VertexUtil.vert((VertexConsumer)builder, (PoseStack)matrixStack, (float)0.0f, (float)h, (float)0.0f, (float)maxU, (float)v, (float)r, (float)g, (float)b, (float)1.0f, (int)lu, (int)lv, (float)(-nx), (float)((float)ny), (float)((float)nz));
        matrixStack.popPose();
        matrixStack.pushPose();
        matrixStack.translate(hw, 0.0f, 0.0f);
        VertexUtil.vert((VertexConsumer)builder, (PoseStack)matrixStack, (float)0.0f, (float)h, (float)0.0f, (float)u, (float)v, (float)r, (float)g, (float)b, (float)1.0f, (int)lu, (int)lv, (float)0.0f, (float)1.0f, (float)0.0f);
        matrixStack.translate(-w, 0.0f, 0.0f);
        VertexUtil.vert((VertexConsumer)builder, (PoseStack)matrixStack, (float)0.0f, (float)h, (float)0.0f, (float)u, (float)pV2, (float)r, (float)g, (float)b, (float)1.0f, (int)lu, (int)lv, (float)0.0f, (float)1.0f, (float)0.0f);
        matrixStack.mulPose(rot);
        matrixStack.translate(0.0f, 0.0f, l);
        VertexUtil.vert((VertexConsumer)builder, (PoseStack)matrixStack, (float)0.0f, (float)h, (float)0.0f, (float)maxU, (float)pV2, (float)r, (float)g, (float)b, (float)1.0f, (int)lu, (int)lv, (float)0.0f, (float)1.0f, (float)0.0f);
        matrixStack.mulPose(rotInv);
        matrixStack.translate(w, 0.0f, 0.0f);
        VertexUtil.vert((VertexConsumer)builder, (PoseStack)matrixStack, (float)0.0f, (float)h, (float)0.0f, (float)maxU, (float)v, (float)r, (float)g, (float)b, (float)1.0f, (int)lu, (int)lv, (float)0.0f, (float)1.0f, (float)0.0f);
        matrixStack.popPose();
        matrixStack.pushPose();
        matrixStack.translate(-hw, 0.0f, 0.0f);
        VertexUtil.vert((VertexConsumer)builder, (PoseStack)matrixStack, (float)0.0f, (float)0.0f, (float)0.0f, (float)u, (float)pV, (float)r, (float)g, (float)b, (float)1.0f, (int)lu, (int)lv, (float)0.0f, (float)-1.0f, (float)0.0f);
        matrixStack.translate(w, 0.0f, 0.0f);
        VertexUtil.vert((VertexConsumer)builder, (PoseStack)matrixStack, (float)0.0f, (float)0.0f, (float)0.0f, (float)u, (float)maxV, (float)r, (float)g, (float)b, (float)1.0f, (int)lu, (int)lv, (float)0.0f, (float)-1.0f, (float)0.0f);
        matrixStack.mulPose(rot);
        matrixStack.translate(0.0f, 0.0f, l);
        VertexUtil.vert((VertexConsumer)builder, (PoseStack)matrixStack, (float)0.0f, (float)0.0f, (float)0.0f, (float)maxU, (float)maxV, (float)r, (float)g, (float)b, (float)1.0f, (int)lu, (int)lv, (float)0.0f, (float)-1.0f, (float)0.0f);
        matrixStack.mulPose(rotInv);
        matrixStack.translate(-w, 0.0f, 0.0f);
        VertexUtil.vert((VertexConsumer)builder, (PoseStack)matrixStack, (float)0.0f, (float)0.0f, (float)0.0f, (float)maxU, (float)pV, (float)r, (float)g, (float)b, (float)1.0f, (int)lu, (int)lv, (float)0.0f, (float)-1.0f, (float)0.0f);
        matrixStack.popPose();
        if (end) {
            matrixStack.pushPose();
            matrixStack.mulPose(rot);
            matrixStack.translate(0.0f, 0.0f, l);
            matrixStack.mulPose(rotInv);
            matrixStack.translate(-hw, 0.0f, 0.0f);
            VertexUtil.vert((VertexConsumer)builder, (PoseStack)matrixStack, (float)0.0f, (float)h, (float)0.0f, (float)pU, (float)v, (float)r, (float)g, (float)b, (float)1.0f, (int)lu, (int)lv, (float)0.0f, (float)0.0f, (float)1.0f);
            VertexUtil.vert((VertexConsumer)builder, (PoseStack)matrixStack, (float)0.0f, (float)0.0f, (float)0.0f, (float)pU, (float)maxV, (float)r, (float)g, (float)b, (float)1.0f, (int)lu, (int)lv, (float)0.0f, (float)0.0f, (float)1.0f);
            matrixStack.translate(w, 0.0f, 0.0f);
            VertexUtil.vert((VertexConsumer)builder, (PoseStack)matrixStack, (float)0.0f, (float)0.0f, (float)0.0f, (float)maxU, (float)maxV, (float)r, (float)g, (float)b, (float)1.0f, (int)lu, (int)lv, (float)0.0f, (float)0.0f, (float)1.0f);
            VertexUtil.vert((VertexConsumer)builder, (PoseStack)matrixStack, (float)0.0f, (float)h, (float)0.0f, (float)maxU, (float)v, (float)r, (float)g, (float)b, (float)1.0f, (int)lu, (int)lv, (float)0.0f, (float)0.0f, (float)1.0f);
            matrixStack.popPose();
        }
    }
}

