/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.entities.controllers;

import net.mehvahdjukaar.supplementaries.common.entities.controllers.BoatNodeEvaluator;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.SectionPos;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.level.pathfinder.PathFinder;
import net.minecraft.world.phys.Vec3;

public class BoatPathNavigation
extends PathNavigation {
    public BoatPathNavigation(Mob strider, Level level) {
        super(strider, level);
    }

    protected PathFinder createPathFinder(int maxVisitedNodes) {
        this.nodeEvaluator = new BoatNodeEvaluator();
        this.nodeEvaluator.setCanPassDoors(true);
        this.nodeEvaluator.setCanFloat(true);
        return new PathFinder(this.nodeEvaluator, maxVisitedNodes);
    }

    protected void followThePath() {
        Entity vehicle = this.mob.getControlledVehicle();
        if (vehicle != null) {
            boolean bl;
            Vec3 vec3 = this.getTempMobPos();
            this.maxDistanceToWaypoint = vehicle.getBbWidth() > 0.75f ? vehicle.getBbWidth() / 2.0f : 0.75f - vehicle.getBbWidth() / 2.0f;
            this.maxDistanceToWaypoint *= 1.2f;
            BlockPos vec3i = this.path.getNextNodePos();
            double d = Math.abs(this.mob.getX() - ((double)vec3i.getX() + 0.5));
            double e = Math.abs(this.mob.getY() - (double)vec3i.getY());
            double f = Math.abs(this.mob.getZ() - ((double)vec3i.getZ() + 0.5));
            boolean bl2 = bl = d < (double)this.maxDistanceToWaypoint && f < (double)this.maxDistanceToWaypoint && e < 1.0;
            if (bl || this.canCutCorner(this.path.getNextNode().type) && this.shouldTargetNextNodeInDirection(vec3)) {
                this.path.advance();
            }
            this.doStuckDetection(vec3);
        } else {
            super.followThePath();
        }
    }

    protected boolean canUpdatePath() {
        return this.isBoatInWater();
    }

    private boolean isBoatInWater() {
        Entity boat = this.mob.getControlledVehicle();
        return boat != null && boat.isInWater() && !boat.isUnderWater();
    }

    protected Vec3 getTempMobPos() {
        return new Vec3(this.mob.getX(), (double)this.getSurfaceY(), this.mob.getZ());
    }

    protected double getGroundY(Vec3 vec) {
        BlockPos posAt = BlockPos.containing((Position)vec);
        return BoatNodeEvaluator.getWaterHeightLevel((BlockGetter)this.level, posAt);
    }

    private int getSurfaceY() {
        FluidState blockState;
        int i = 0;
        int j = 0;
        do {
            blockState = this.level.getFluidState(BlockPos.containing((double)this.mob.getX(), (double)(++i), (double)this.mob.getZ()));
            if (++j <= 16) continue;
            return this.mob.getBlockY();
        } while (blockState.is(FluidTags.WATER));
        return i;
    }

    public void setCanFloat(boolean canSwim) {
    }

    public boolean canFloat() {
        return true;
    }

    public Path createPath(Entity entity, int accuracy) {
        return this.createPath(entity.blockPosition(), accuracy);
    }

    public Path createPath(BlockPos pos, int accuracy) {
        BlockPos blockPos;
        LevelChunk levelChunk = this.level.getChunkSource().getChunkNow(SectionPos.blockToSectionCoord((int)pos.getX()), SectionPos.blockToSectionCoord((int)pos.getZ()));
        if (levelChunk == null) {
            return null;
        }
        if (levelChunk.getBlockState(pos).isAir()) {
            blockPos = pos.below();
            while (blockPos.getY() > this.level.getMinBuildHeight() && levelChunk.getBlockState(blockPos).isAir()) {
                blockPos = blockPos.below();
            }
            if (blockPos.getY() > this.level.getMinBuildHeight()) {
                return super.createPath(blockPos.above(), accuracy);
            }
            while (blockPos.getY() < this.level.getMaxBuildHeight() && levelChunk.getBlockState(blockPos).isAir()) {
                blockPos = blockPos.above();
            }
            pos = blockPos;
        }
        if (!levelChunk.getFluidState(pos).is(FluidTags.WATER)) {
            return super.createPath(pos, accuracy);
        }
        blockPos = pos.above();
        while (blockPos.getY() < this.level.getMaxBuildHeight() && levelChunk.getFluidState(blockPos).is(FluidTags.WATER)) {
            blockPos = blockPos.above();
        }
        return super.createPath(blockPos, accuracy);
    }

    public boolean isStableDestination(BlockPos pos) {
        return super.isStableDestination(pos) || this.level.getFluidState(pos).is(FluidTags.WATER);
    }
}

