/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.network;

import net.mehvahdjukaar.moonlight.api.misc.TileOrEntityTarget;
import net.mehvahdjukaar.moonlight.api.platform.network.Message;
import net.mehvahdjukaar.supplementaries.Supplementaries;
import net.mehvahdjukaar.supplementaries.common.block.cannon.CannonAccess;
import net.mehvahdjukaar.supplementaries.common.block.tiles.CannonBlockTile;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;

public record ServerBoundSyncCannonPacket(float yaw, float pitch, byte firePower, boolean fire, boolean stopControlling, TileOrEntityTarget target) implements Message
{
    public static final CustomPacketPayload.TypeAndCodec<RegistryFriendlyByteBuf, ServerBoundSyncCannonPacket> CODEC = Message.makeType((ResourceLocation)Supplementaries.res("c2s_sync_cannon"), ServerBoundSyncCannonPacket::new);

    public ServerBoundSyncCannonPacket(FriendlyByteBuf buf) {
        this(buf.readFloat(), buf.readFloat(), buf.readByte(), buf.readBoolean(), buf.readBoolean(), TileOrEntityTarget.read((FriendlyByteBuf)buf));
    }

    public void write(RegistryFriendlyByteBuf buf) {
        buf.writeFloat(this.yaw);
        buf.writeFloat(this.pitch);
        buf.writeByte((int)this.firePower);
        buf.writeBoolean(this.fire);
        buf.writeBoolean(this.stopControlling);
        this.target.write((FriendlyByteBuf)buf);
    }

    public void handle(Message.Context context) {
        Player player = context.getPlayer();
        if (player instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            CannonAccess access = CannonAccess.find(player2.level(), this.target);
            if (access != null) {
                CannonBlockTile cannon = access.getInternalCannon();
                if (cannon.canBeUsedBy(BlockPos.containing((Position)access.getCannonGlobalPosition(1.0f)), (Entity)player2)) {
                    cannon.setAttributes(this.yaw, this.pitch, this.firePower, this.fire, (Player)player2, access);
                    cannon.setChanged();
                    if (this.stopControlling) {
                        cannon.setCurrentUser(null);
                    }
                    access.updateClients();
                } else {
                    Supplementaries.LOGGER.warn("Player tried to control cannon {} without permission: {}", (Object)player2.getName().getString(), (Object)this.target);
                }
            } else {
                Supplementaries.LOGGER.warn("Cannon not found for player {}: {}", (Object)player2.getName().getString(), (Object)this.target);
            }
        }
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return CODEC.type();
    }
}

