/*
 * Decompiled with CFR 0.152.
 */
package dev.worldgen.tectonic.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import dev.worldgen.lithostitched.mixin.common.RandomStateAccessor;
import dev.worldgen.lithostitched.worldgen.NoiseWiringHelper;
import dev.worldgen.tectonic.Tectonic;
import dev.worldgen.tectonic.config.ConfigHandler;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Position;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentUtils;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.InclusiveRange;
import net.minecraft.util.Mth;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.DensityFunction;
import net.minecraft.world.level.levelgen.NoiseBasedChunkGenerator;
import net.minecraft.world.level.levelgen.NoiseGeneratorSettings;
import net.minecraft.world.level.levelgen.RandomState;

public class TectonicCommand {
    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        LiteralArgumentBuilder locate = Commands.literal((String)"locate");
        TectonicCommand.addTarget((LiteralArgumentBuilder<CommandSourceStack>)locate, "mountain_range", LocateTargets.MOUNTAIN_RANGE, () -> true);
        TectonicCommand.addTarget((LiteralArgumentBuilder<CommandSourceStack>)locate, "underground_river", LocateTargets.UNDERGROUND_RIVER, () -> ConfigHandler.getState().continents.undergroundRivers);
        TectonicCommand.addTarget((LiteralArgumentBuilder<CommandSourceStack>)locate, "jungle_pillars", LocateTargets.JUNGLE_PILLARS, () -> ConfigHandler.getState().continents.junglePillars);
        TectonicCommand.addTarget((LiteralArgumentBuilder<CommandSourceStack>)locate, "rolling_hills", LocateTargets.ROLLING_HILLS, () -> ConfigHandler.getState().continents.rollingHills);
        TectonicCommand.addTarget((LiteralArgumentBuilder<CommandSourceStack>)locate, "badlands_canyon", LocateTargets.BADLANDS_CANYON, () -> true);
        TectonicCommand.addTarget((LiteralArgumentBuilder<CommandSourceStack>)locate, "badlands_plateaus", LocateTargets.BADLANDS_PLATEAUS, () -> true);
        TectonicCommand.addTarget((LiteralArgumentBuilder<CommandSourceStack>)locate, "desert_dunes", LocateTargets.DESERT_DUNES, () -> true);
        TectonicCommand.addTarget((LiteralArgumentBuilder<CommandSourceStack>)locate, "cherry_valley", LocateTargets.CHERRY_VALLEY, () -> true);
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"tectonic").requires(stack -> stack.hasPermission(2))).then(Commands.literal((String)"debug").executes(TectonicCommand::debugOutput))).then((ArgumentBuilder)locate));
    }

    private static void addTarget(LiteralArgumentBuilder<CommandSourceStack> locate, String name, Map<String, InclusiveRange<Double>> target, Supplier<Boolean> enabled) {
        locate.then(Commands.literal((String)name).executes(context -> TectonicCommand.locate((CommandContext<CommandSourceStack>)context, name, target, enabled)));
    }

    private static int debugOutput(CommandContext<CommandSourceStack> context) {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        ServerLevel level = source.getLevel();
        BlockPos origin = BlockPos.containing((Position)source.getPosition());
        HolderLookup.RegistryLookup registry = level.registryAccess().lookupOrThrow(Registries.DENSITY_FUNCTION);
        NoiseWiringHelper helper = TectonicCommand.getNoiseHelper(source);
        if (helper == null) {
            return 0;
        }
        TectonicCommand.message(source, (Component)Component.literal((String)"Tectonic debug info:"));
        TectonicCommand.message(source, TectonicCommand.getRegion(TectonicCommand.get((Holder<DensityFunction>)registry.getOrThrow(TectonicCommand.key("noise/continent/erosion")), helper, origin), TectonicCommand.get((Holder<DensityFunction>)registry.getOrThrow(TectonicCommand.key("noise/region_selector")), helper, origin)));
        TectonicCommand.message(source, (Component)Component.translatableWithFallback((String)"command.tectonic.depth_cutoff", (String)"Depth cutoff: %s", (Object[])new Object[]{TectonicCommand.get((Holder<DensityFunction>)registry.getOrThrow(TectonicCommand.key("__constants/cave/depth_cutoff")), helper, origin)}));
        return 1;
    }

    private static int locate(CommandContext<CommandSourceStack> context, String name, Map<String, InclusiveRange<Double>> targets, Supplier<Boolean> enabled) {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        ServerLevel level = source.getLevel();
        BlockPos origin = BlockPos.containing((Position)source.getPosition());
        HolderLookup.RegistryLookup registry = level.registryAccess().lookupOrThrow(Registries.DENSITY_FUNCTION);
        if (!enabled.get().booleanValue()) {
            TectonicCommand.failure(source, "Tectonic terrain feature " + name + " is not enabled.");
            return 0;
        }
        NoiseWiringHelper helper = TectonicCommand.getNoiseHelper(source);
        if (helper == null) {
            return 0;
        }
        for (BlockPos.MutableBlockPos offset : BlockPos.spiralAround((BlockPos)BlockPos.ZERO, (int)400, (Direction)Direction.EAST, (Direction)Direction.SOUTH)) {
            int x = origin.getX() + offset.getX() * 64;
            int z = origin.getZ() + offset.getZ() * 64;
            BlockPos pos = new BlockPos(x, 0, z);
            boolean allMatch = true;
            for (Map.Entry<String, InclusiveRange<Double>> target : targets.entrySet()) {
                if (target.getValue().isValueInRange((Comparable)Double.valueOf(TectonicCommand.get((Holder<DensityFunction>)registry.getOrThrow(TectonicCommand.key(target.getKey())), helper, pos)))) continue;
                allMatch = false;
            }
            if (!allMatch) continue;
            MutableComponent component = ComponentUtils.wrapInSquareBrackets((Component)Component.translatable((String)"chat.coordinates", (Object[])new Object[]{pos.getX(), "~", pos.getZ()})).withStyle(style -> style.withColor(ChatFormatting.GREEN).withClickEvent(TectonicCommand.getClickEvent(pos)).withHoverEvent(TectonicCommand.getHoverEvent()));
            int dist = Mth.floor((float)TectonicCommand.dist(origin.getX(), origin.getZ(), pos.getX(), pos.getZ()));
            TectonicCommand.message(source, (Component)Component.translatableWithFallback((String)("command.tectonic.locate." + name), (String)("The nearest " + name + " is at %s (%s blocks away)"), (Object[])new Object[]{component, dist}));
            return 1;
        }
        TectonicCommand.message(source, (Component)Component.translatableWithFallback((String)"command.tectonic.locate_failed", (String)("Couldn't find " + name + " within a 25,000 block radius.")));
        return 0;
    }

    private static float dist(int x1, int z1, int x2, int z2) {
        int i = x2 - x1;
        int j = z2 - z1;
        return Mth.sqrt((float)(i * i + j * j));
    }

    private static ClickEvent getClickEvent(BlockPos pos) {
        return new ClickEvent(ClickEvent.Action.SUGGEST_COMMAND, "/tp @s " + pos.getX() + " ~ " + pos.getZ());
    }

    private static HoverEvent getHoverEvent() {
        return new HoverEvent(HoverEvent.Action.SHOW_TEXT, (Object)Component.translatable((String)"chat.coordinates.tooltip"));
    }

    private static NoiseWiringHelper getNoiseHelper(CommandSourceStack source) {
        ServerLevel level = source.getLevel();
        if (!ConfigHandler.getState().general.modEnabled) {
            TectonicCommand.failure(source, "Tectonic is not currently enabled.");
            return null;
        }
        ChunkGenerator chunkGenerator = level.getChunkSource().getGenerator();
        if (!(chunkGenerator instanceof NoiseBasedChunkGenerator)) {
            TectonicCommand.failure(source, "Tectonic generation is not present here.");
            return null;
        }
        NoiseBasedChunkGenerator generator = (NoiseBasedChunkGenerator)chunkGenerator;
        NoiseGeneratorSettings settings = (NoiseGeneratorSettings)generator.generatorSettings().value();
        RandomState randomState = RandomState.create((NoiseGeneratorSettings)settings, (HolderGetter)level.registryAccess().lookupOrThrow(Registries.NOISE), (long)level.getSeed());
        return new NoiseWiringHelper(level.getSeed(), settings.useLegacyRandomSource(), randomState, ((RandomStateAccessor)randomState).getRandom());
    }

    private static void message(CommandSourceStack source, Component message) {
        source.sendSystemMessage(message);
    }

    private static void failure(CommandSourceStack source, String message) {
        source.sendFailure((Component)Component.literal((String)message).withStyle(ChatFormatting.RED));
    }

    private static double get(Holder<DensityFunction> holder, NoiseWiringHelper helper, BlockPos pos) {
        double d = ((DensityFunction)holder.value()).mapAll((DensityFunction.Visitor)helper).compute((DensityFunction.FunctionContext)new DensityFunction.SinglePointContext(pos.getX(), pos.getY(), pos.getZ()));
        return (double)Math.round(d * 1000.0) / 1000.0;
    }

    private static Component getRegion(double erosion, double regionSelector) {
        String nameText;
        String iconText;
        if (erosion < 0.0) {
            if (regionSelector < 0.0) {
                iconText = "\u2663";
                nameText = "Club";
            } else {
                iconText = "\u2665";
                nameText = "Heart";
            }
        } else if (regionSelector < 0.0) {
            iconText = "\u2660";
            nameText = "Spade";
        } else {
            iconText = "\u2666";
            nameText = "Diamond";
        }
        MutableComponent icon = Component.literal((String)iconText);
        icon.withStyle(regionSelector < 0.0 ? ChatFormatting.DARK_GRAY : ChatFormatting.RED);
        MutableComponent name = Component.literal((String)nameText);
        return Component.translatableWithFallback((String)"command.tectonic.region", (String)"Region: %s %s (Erosion %s / Region Selector %s)", (Object[])new Object[]{icon, name, erosion, regionSelector});
    }

    private static ResourceKey<DensityFunction> key(String name) {
        return ResourceKey.create((ResourceKey)Registries.DENSITY_FUNCTION, (ResourceLocation)Tectonic.id(name));
    }

    private static interface LocateTargets {
        public static final Map<String, InclusiveRange<Double>> UNDERGROUND_RIVER = Map.of("noise/continent/ridges_folded", LocateTargets.range(0.0, 0.025), "noise/raw_continents", LocateTargets.range(-0.1, 64.0), "noise/continent/erosion_folded", LocateTargets.range(0.0, 0.225));
        public static final Map<String, InclusiveRange<Double>> MOUNTAIN_RANGE = Map.of("noise/continent/erosion_folded", LocateTargets.range(0.0, 0.05), "noise/raw_continents", LocateTargets.range(0.1, 64.0));
        public static final Map<String, InclusiveRange<Double>> JUNGLE_PILLARS = Map.of("noise/continent/ridges", LocateTargets.range(-0.75, -0.2), "noise/vegetation_index", LocateTargets.range(4.0, 5.0), "noise/temperature_index", LocateTargets.range(4.0, 4.0), "noise/region_selector", LocateTargets.range(0.1, 64.0), "noise/continent/erosion", LocateTargets.range(-0.8, -0.45), "noise/raw_continents", LocateTargets.range(0.1, 64.0));
        public static final Map<String, InclusiveRange<Double>> ROLLING_HILLS = Map.of("noise/continent/ridges_folded", LocateTargets.range(0.2, 64.0), "noise/vegetation_index", LocateTargets.range(0.0, 2.0), "noise/temperature_index", LocateTargets.range(0.0, 3.0), "noise/region_selector", LocateTargets.range(0.1, 64.0), "noise/continent/erosion", LocateTargets.range(-0.8, -0.45), "noise/raw_continents", LocateTargets.range(0.1, 64.0));
        public static final Map<String, InclusiveRange<Double>> BADLANDS_CANYON = Map.of("noise/continent/ridges_folded", LocateTargets.range(0.2, 64.0), "noise/temperature_index", LocateTargets.range(5.0, 5.0), "noise/region_selector", LocateTargets.range(-64.0, 0.0), "noise/continent/erosion", LocateTargets.range(0.45, 0.8), "noise/raw_continents", LocateTargets.range(0.35, 64.0));
        public static final Map<String, InclusiveRange<Double>> BADLANDS_PLATEAUS = Map.of("noise/continent/ridges_folded", LocateTargets.range(0.2, 64.0), "noise/temperature_index", LocateTargets.range(5.0, 5.0), "noise/region_selector", LocateTargets.range(-64.0, 0.0), "noise/continent/erosion", LocateTargets.range(-8.0, -0.45), "noise/raw_continents", LocateTargets.range(0.35, 64.0));
        public static final Map<String, InclusiveRange<Double>> DESERT_DUNES = Map.of("noise/continent/ridges_folded", LocateTargets.range(0.2, 64.0), "noise/temperature_index", LocateTargets.range(5.0, 5.0), "noise/region_selector", LocateTargets.range(0.1, 64.0), "noise/continent/erosion", LocateTargets.range(0.45, 0.8), "noise/raw_continents", LocateTargets.range(0.1, 64.0));
        public static final Map<String, InclusiveRange<Double>> CHERRY_VALLEY = Map.of("noise/continent/ridges_folded", LocateTargets.range(0.4, 64.0), "noise/vegetation_index", LocateTargets.range(0.0, 2.0), "noise/temperature_index", LocateTargets.range(3.0, 3.0), "noise/region_selector", LocateTargets.range(-64.0, 0.0), "noise/continent/erosion", LocateTargets.range(-0.8, -0.45), "noise/raw_continents", LocateTargets.range(0.35, 64.0));

        private static InclusiveRange<Double> range(double min, double max) {
            return new InclusiveRange((Comparable)Double.valueOf(min), (Comparable)Double.valueOf(max));
        }
    }
}

