/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.tempad.common.config;

import com.google.common.base.CaseFormat;
import com.teamresourceful.bytecodecs.base.ByteCodec;
import com.teamresourceful.resourcefulconfig.api.types.entries.Observable;
import com.teamresourceful.resourcefullib.common.network.Network;
import com.teamresourceful.resourcefullib.common.network.Packet;
import com.teamresourceful.resourcefullib.common.network.base.ClientboundPacketType;
import com.teamresourceful.resourcefullib.common.network.base.NetworkHandle;
import com.teamresourceful.resourcefullib.common.network.base.PacketType;
import com.teamresourceful.resourcefullib.common.network.defaults.CodecPacketType;
import earth.terrarium.tempad.Tempad;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Function;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.IntIterator;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.reflect.KProperty;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.entity.player.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\u0018\u00002\u00020\u0001:\u0003%&'B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000e\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cJ$\u0010\u001d\u001a\f\u0012\u0004\u0012\u00020\u001e0\u0013R\u00020\u00002\u0012\u0010\u001f\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001e0!0 J$\u0010\"\u001a\f\u0012\u0004\u0012\u00020#0\u0013R\u00020\u00002\u0012\u0010\u001f\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020#0!0 J$\u0010$\u001a\f\u0012\u0004\u0012\u00020\u00030\u0013R\u00020\u00002\u0012\u0010\u001f\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030!0 R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0015\u0010\f\u001a\u00060\rR\u00020\u0000\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR%\u0010\u0010\u001a\u0016\u0012\u0004\u0012\u00020\u0012\u0012\f\u0012\n\u0012\u0002\b\u00030\u0013R\u00020\u00000\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0018\u0010\u0016\u001a\n \u0017*\u0004\u0018\u00010\u00120\u0012X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0018\u00a8\u0006("}, d2={"Learth/terrarium/tempad/common/config/ConfigCache;", "", "modId", "", "network", "Lcom/teamresourceful/resourcefullib/common/network/Network;", "<init>", "(Ljava/lang/String;Lcom/teamresourceful/resourcefullib/common/network/Network;)V", "getModId", "()Ljava/lang/String;", "getNetwork", "()Lcom/teamresourceful/resourcefullib/common/network/Network;", "syncType", "Learth/terrarium/tempad/common/config/ConfigCache$ConfigSyncType;", "getSyncType", "()Learth/terrarium/tempad/common/config/ConfigCache$ConfigSyncType;", "entries", "", "Lnet/minecraft/resources/ResourceLocation;", "Learth/terrarium/tempad/common/config/ConfigCache$ConfigEntry;", "getEntries", "()Ljava/util/Map;", "syncId", "kotlin.jvm.PlatformType", "Lnet/minecraft/resources/ResourceLocation;", "syncAll", "", "player", "Lnet/minecraft/world/entity/player/Player;", "ofInt", "", "observable", "Lkotlin/reflect/KProperty;", "Lcom/teamresourceful/resourcefulconfig/api/types/entries/Observable;", "ofBoolean", "", "ofString", "ConfigSyncType", "ConfigSync", "ConfigEntry", "tempad-1.21.1"})
@SourceDebugExtension(value={"SMAP\nConfigCache.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ConfigCache.kt\nearth/terrarium/tempad/common/config/ConfigCache\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,102:1\n462#2:103\n412#2:104\n1246#3,4:105\n1#4:109\n*S KotlinDebug\n*F\n+ 1 ConfigCache.kt\nearth/terrarium/tempad/common/config/ConfigCache\n*L\n26#1:103\n26#1:104\n26#1:105,4\n*E\n"})
public final class ConfigCache {
    @NotNull
    private final String modId;
    @NotNull
    private final Network network;
    @NotNull
    private final ConfigSyncType syncType;
    @NotNull
    private final Map<ResourceLocation, ConfigEntry<?>> entries;
    private final ResourceLocation syncId;

    public ConfigCache(@NotNull String modId, @NotNull Network network) {
        Intrinsics.checkNotNullParameter((Object)modId, (String)"modId");
        Intrinsics.checkNotNullParameter((Object)network, (String)"network");
        this.modId = modId;
        this.network = network;
        this.syncType = new ConfigSyncType();
        this.entries = new LinkedHashMap();
        this.syncId = ResourceLocation.fromNamespaceAndPath((String)this.modId, (String)"config_sync");
    }

    @NotNull
    public final String getModId() {
        return this.modId;
    }

    @NotNull
    public final Network getNetwork() {
        return this.network;
    }

    @NotNull
    public final ConfigSyncType getSyncType() {
        return this.syncType;
    }

    @NotNull
    public final Map<ResourceLocation, ConfigEntry<?>> getEntries() {
        return this.entries;
    }

    /*
     * WARNING - void declaration
     */
    public final void syncAll(@NotNull Player player) {
        void $this$mapValuesTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Map<ResourceLocation, ConfigEntry<?>> $this$mapValues$iv = this.entries;
        boolean $i$f$mapValues = false;
        Map<ResourceLocation, ConfigEntry<?>> map = $this$mapValues$iv;
        Map destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
        boolean $i$f$mapValuesTo = false;
        Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            void it;
            void it$iv$iv;
            Map.Entry entry = (Map.Entry)element$iv$iv$iv;
            Map map2 = destination$iv$iv;
            boolean bl = false;
            Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
            Object k = it$iv$iv.getKey();
            Map map3 = map2;
            boolean bl2 = false;
            ConfigEntry.ConfigSyncData configSyncData = ((ConfigEntry)it.getValue()).createPacket();
            map3.put(k, configSyncData);
        }
        Map syncData = destination$iv$iv;
        this.network.sendToPlayer((Packet)new ConfigSync(syncData), player);
    }

    @NotNull
    public final ConfigEntry<Integer> ofInt(@NotNull KProperty<Observable<Integer>> observable) {
        ConfigEntry<Integer> configEntry;
        Intrinsics.checkNotNullParameter(observable, (String)"observable");
        ByteCodec byteCodec2 = ByteCodec.INT;
        Intrinsics.checkNotNullExpressionValue((Object)byteCodec2, (String)"INT");
        ConfigEntry<Integer> $this$ofInt_u24lambda_u241 = configEntry = new ConfigEntry<Integer>(observable, byteCodec2);
        boolean bl = false;
        ResourceLocation resourceLocation = $this$ofInt_u24lambda_u241.getSyncType().id();
        Intrinsics.checkNotNullExpressionValue((Object)resourceLocation, (String)"id(...)");
        this.entries.put(resourceLocation, $this$ofInt_u24lambda_u241);
        return configEntry;
    }

    @NotNull
    public final ConfigEntry<Boolean> ofBoolean(@NotNull KProperty<Observable<Boolean>> observable) {
        ConfigEntry<Boolean> configEntry;
        Intrinsics.checkNotNullParameter(observable, (String)"observable");
        ByteCodec byteCodec2 = ByteCodec.BOOLEAN;
        Intrinsics.checkNotNullExpressionValue((Object)byteCodec2, (String)"BOOLEAN");
        ConfigEntry<Boolean> $this$ofBoolean_u24lambda_u242 = configEntry = new ConfigEntry<Boolean>(observable, byteCodec2);
        boolean bl = false;
        ResourceLocation resourceLocation = $this$ofBoolean_u24lambda_u242.getSyncType().id();
        Intrinsics.checkNotNullExpressionValue((Object)resourceLocation, (String)"id(...)");
        this.entries.put(resourceLocation, $this$ofBoolean_u24lambda_u242);
        return configEntry;
    }

    @NotNull
    public final ConfigEntry<String> ofString(@NotNull KProperty<Observable<String>> observable) {
        ConfigEntry<String> configEntry;
        Intrinsics.checkNotNullParameter(observable, (String)"observable");
        ByteCodec byteCodec2 = ByteCodec.STRING;
        Intrinsics.checkNotNullExpressionValue((Object)byteCodec2, (String)"STRING");
        ConfigEntry<String> $this$ofString_u24lambda_u243 = configEntry = new ConfigEntry<String>(observable, byteCodec2);
        boolean bl = false;
        ResourceLocation resourceLocation = $this$ofString_u24lambda_u243.getSyncType().id();
        Intrinsics.checkNotNullExpressionValue((Object)resourceLocation, (String)"id(...)");
        this.entries.put(resourceLocation, $this$ofString_u24lambda_u243);
        return configEntry;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u0000.\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\b\b\u0086\u0004\u0018\u0000*\u0004\b\u0000\u0010\u00012\u00020\u0002:\u0001\u001cB)\u0012\u0012\u0010\u0003\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u00050\u0004\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00000\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0014\u0010\u0018\u001a\u00100\u0014R\f\u0012\u0004\u0012\u00028\u00000\u0000R\u00020\u0015J\"\u0010\r\u001a\u00028\u00002\u0006\u0010\u0019\u001a\u00020\u00022\n\u0010\u001a\u001a\u0006\u0012\u0002\b\u00030\u0004H\u0086\u0002\u00a2\u0006\u0002\u0010\u001bR\u001a\u0010\u0003\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00000\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u001c\u0010\f\u001a\u00028\u0000X\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010\u0011\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R%\u0010\u0012\u001a\u0016\u0012\u0012\u0012\u00100\u0014R\f\u0012\u0004\u0012\u00028\u00000\u0000R\u00020\u00150\u0013\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017\u00a8\u0006\u001d"}, d2={"Learth/terrarium/tempad/common/config/ConfigCache$ConfigEntry;", "T", "", "observable", "Lkotlin/reflect/KProperty;", "Lcom/teamresourceful/resourcefulconfig/api/types/entries/Observable;", "codec", "Lcom/teamresourceful/bytecodecs/base/ByteCodec;", "<init>", "(Learth/terrarium/tempad/common/config/ConfigCache;Lkotlin/reflect/KProperty;Lcom/teamresourceful/bytecodecs/base/ByteCodec;)V", "getCodec", "()Lcom/teamresourceful/bytecodecs/base/ByteCodec;", "value", "getValue", "()Ljava/lang/Object;", "setValue", "(Ljava/lang/Object;)V", "Ljava/lang/Object;", "syncType", "Lcom/teamresourceful/resourcefullib/common/network/defaults/CodecPacketType$Client;", "Learth/terrarium/tempad/common/config/ConfigCache$ConfigEntry$ConfigSyncData;", "Learth/terrarium/tempad/common/config/ConfigCache;", "getSyncType", "()Lcom/teamresourceful/resourcefullib/common/network/defaults/CodecPacketType$Client;", "createPacket", "test", "property", "(Ljava/lang/Object;Lkotlin/reflect/KProperty;)Ljava/lang/Object;", "ConfigSyncData", "tempad-1.21.1"})
    public final class ConfigEntry<T> {
        @NotNull
        private final KProperty<Observable<T>> observable;
        @NotNull
        private final ByteCodec<T> codec;
        private T value;
        @NotNull
        private final CodecPacketType.Client<ConfigSyncData> syncType;

        public ConfigEntry(@NotNull KProperty<Observable<T>> observable, ByteCodec<T> codec2) {
            Intrinsics.checkNotNullParameter(observable, (String)"observable");
            Intrinsics.checkNotNullParameter(codec2, (String)"codec");
            this.observable = observable;
            this.codec = codec2;
            this.value = ((Observable)this.observable.getGetter().call(new Object[0])).get();
            CodecPacketType.Client client = CodecPacketType.Client.create((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)ConfigCache.this.getModId(), (String)CaseFormat.LOWER_CAMEL.to(CaseFormat.LOWER_UNDERSCORE, this.observable.getName())), (ByteCodec)this.codec.map(arg_0 -> ConfigEntry.syncType$lambda$0(this, arg_0), ConfigEntry::syncType$lambda$1), (Function)NetworkHandle.handle(arg_0 -> ConfigEntry.syncType$lambda$2(this, arg_0)));
            Intrinsics.checkNotNullExpressionValue((Object)client, (String)"create(...)");
            this.syncType = client;
            ConfigCache.this.getNetwork().register((ClientboundPacketType)this.syncType);
            ((Observable)this.observable.getGetter().call(new Object[0])).addListener((arg_0, arg_1) -> ConfigEntry._init_$lambda$3(this, ConfigCache.this, arg_0, arg_1));
        }

        @NotNull
        public final ByteCodec<T> getCodec() {
            return this.codec;
        }

        public final T getValue() {
            return this.value;
        }

        public final void setValue(T t) {
            this.value = t;
        }

        @NotNull
        public final CodecPacketType.Client<ConfigSyncData> getSyncType() {
            return this.syncType;
        }

        @NotNull
        public final ConfigSyncData createPacket() {
            return new ConfigSyncData(((Observable)this.observable.getGetter().call(new Object[0])).get());
        }

        public final T getValue(@NotNull Object test, @NotNull KProperty<?> property) {
            Intrinsics.checkNotNullParameter((Object)test, (String)"test");
            Intrinsics.checkNotNullParameter(property, (String)"property");
            return this.value;
        }

        private static final ConfigSyncData syncType$lambda$0(ConfigEntry this$0, Object it) {
            return this$0.new ConfigSyncData(it);
        }

        private static final Object syncType$lambda$1(ConfigSyncData it) {
            return it.getConfig();
        }

        private static final void syncType$lambda$2(ConfigEntry this$0, ConfigSyncData message) {
            this$0.value = message.getConfig();
        }

        private static final void _init_$lambda$3(ConfigEntry this$0, ConfigCache this$1, Object object, Object newValue) {
            this$0.value = newValue;
            Network network = this$1.getNetwork();
            Packet packet = this$0.new ConfigSyncData(newValue);
            MinecraftServer minecraftServer = Tempad.Companion.getServer();
            Intrinsics.checkNotNull((Object)minecraftServer);
            network.sendToAllPlayers(packet, minecraftServer);
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0004\u0018\u00002\u0016\u0012\u0012\u0012\u00100\u0000R\f\u0012\u0004\u0012\u00028\u00000\u0002R\u00020\u00030\u0001B\u000f\u0012\u0006\u0010\u0004\u001a\u00028\u0000\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u001c\u0010\n\u001a\u0016\u0012\u0012\u0012\u00100\u0000R\f\u0012\u0004\u0012\u00028\u00000\u0002R\u00020\u00030\u000bH\u0016J\u0010\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fJ\u0006\u0010\u0010\u001a\u00020\rR\u0013\u0010\u0004\u001a\u00028\u0000\u00a2\u0006\n\n\u0002\u0010\t\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0011"}, d2={"Learth/terrarium/tempad/common/config/ConfigCache$ConfigEntry$ConfigSyncData;", "Lcom/teamresourceful/resourcefullib/common/network/Packet;", "Learth/terrarium/tempad/common/config/ConfigCache$ConfigEntry;", "Learth/terrarium/tempad/common/config/ConfigCache;", "config", "<init>", "(Learth/terrarium/tempad/common/config/ConfigCache$ConfigEntry;Ljava/lang/Object;)V", "getConfig", "()Ljava/lang/Object;", "Ljava/lang/Object;", "type", "Lcom/teamresourceful/resourcefullib/common/network/base/PacketType;", "encode", "", "buffer", "Lnet/minecraft/network/RegistryFriendlyByteBuf;", "set", "tempad-1.21.1"})
        public final class ConfigSyncData
        implements Packet<ConfigSyncData> {
            private final T config;

            public ConfigSyncData(T config) {
                this.config = config;
            }

            public final T getConfig() {
                return this.config;
            }

            @NotNull
            public PacketType<ConfigSyncData> type() {
                return (PacketType)ConfigEntry.this.getSyncType();
            }

            public final void encode(@Nullable RegistryFriendlyByteBuf buffer) {
                ConfigEntry.this.getSyncType().encode((Packet)this, buffer);
            }

            public final void set() {
                ConfigEntry.this.setValue(this.config);
            }
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\b\u0086\u0004\u0018\u00002\f\u0012\b\u0012\u00060\u0000R\u00020\u00020\u0001B/\u0012&\u0010\u0003\u001a\"\u0012\u0004\u0012\u00020\u0005\u0012\u0018\u0012\u00160\u0006R\n\u0012\u0002\b\u00030\u0007R\u00020\u0002j\u0006\u0012\u0002\b\u0003`\b0\u0004\u00a2\u0006\u0004\b\t\u0010\nJ\u0012\u0010\r\u001a\f\u0012\b\u0012\u00060\u0000R\u00020\u00020\u000eH\u0016R1\u0010\u0003\u001a\"\u0012\u0004\u0012\u00020\u0005\u0012\u0018\u0012\u00160\u0006R\n\u0012\u0002\b\u00030\u0007R\u00020\u0002j\u0006\u0012\u0002\b\u0003`\b0\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u000f"}, d2={"Learth/terrarium/tempad/common/config/ConfigCache$ConfigSync;", "Lcom/teamresourceful/resourcefullib/common/network/Packet;", "Learth/terrarium/tempad/common/config/ConfigCache;", "entries", "", "Lnet/minecraft/resources/ResourceLocation;", "Learth/terrarium/tempad/common/config/ConfigCache$ConfigEntry$ConfigSyncData;", "Learth/terrarium/tempad/common/config/ConfigCache$ConfigEntry;", "Learth/terrarium/tempad/common/config/Data;", "<init>", "(Learth/terrarium/tempad/common/config/ConfigCache;Ljava/util/Map;)V", "getEntries", "()Ljava/util/Map;", "type", "Lcom/teamresourceful/resourcefullib/common/network/base/PacketType;", "tempad-1.21.1"})
    public final class ConfigSync
    implements Packet<ConfigSync> {
        @NotNull
        private final Map<ResourceLocation, ConfigEntry.ConfigSyncData> entries;

        public ConfigSync(Map<ResourceLocation, ? extends ConfigEntry.ConfigSyncData> entries) {
            Intrinsics.checkNotNullParameter(entries, (String)"entries");
            this.entries = entries;
        }

        @NotNull
        public final Map<ResourceLocation, ConfigEntry.ConfigSyncData> getEntries() {
            return this.entries;
        }

        @NotNull
        public PacketType<ConfigSync> type() {
            return (PacketType)ConfigCache.this.getSyncType();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\b\u0086\u0004\u0018\u00002\f\u0012\b\u0012\u00060\u0002R\u00020\u00030\u0001B\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0007H\u0016J\u0014\u0010\b\u001a\u00060\u0002R\u00020\u00032\u0006\u0010\t\u001a\u00020\nH\u0016J\u0014\u0010\u000b\u001a\u00020\f2\n\u0010\r\u001a\u00060\u0002R\u00020\u0003H\u0016J\u001c\u0010\u000e\u001a\u00020\u000f2\n\u0010\r\u001a\u00060\u0002R\u00020\u00032\u0006\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\u0010"}, d2={"Learth/terrarium/tempad/common/config/ConfigCache$ConfigSyncType;", "Lcom/teamresourceful/resourcefullib/common/network/base/ClientboundPacketType;", "Learth/terrarium/tempad/common/config/ConfigCache$ConfigSync;", "Learth/terrarium/tempad/common/config/ConfigCache;", "<init>", "(Learth/terrarium/tempad/common/config/ConfigCache;)V", "id", "Lnet/minecraft/resources/ResourceLocation;", "decode", "buffer", "Lnet/minecraft/network/RegistryFriendlyByteBuf;", "handle", "Ljava/lang/Runnable;", "message", "encode", "", "tempad-1.21.1"})
    @SourceDebugExtension(value={"SMAP\nConfigCache.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ConfigCache.kt\nearth/terrarium/tempad/common/config/ConfigCache$ConfigSyncType\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,102:1\n1863#2:103\n1864#2:105\n1863#2,2:106\n1#3:104\n*S KotlinDebug\n*F\n+ 1 ConfigCache.kt\nearth/terrarium/tempad/common/config/ConfigCache$ConfigSyncType\n*L\n42#1:103\n42#1:105\n50#1:106,2\n*E\n"})
    public final class ConfigSyncType
    implements ClientboundPacketType<ConfigSync> {
        @NotNull
        public ResourceLocation id() {
            ResourceLocation resourceLocation = ConfigCache.this.syncId;
            Intrinsics.checkNotNullExpressionValue((Object)resourceLocation, (String)"access$getSyncId$p(...)");
            return resourceLocation;
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public ConfigSync decode(@NotNull RegistryFriendlyByteBuf buffer) {
            void $this$forEach$iv;
            Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
            Map decodedEntries = new LinkedHashMap();
            int size = buffer.readVarInt();
            Iterable iterable = (Iterable)RangesKt.until((int)0, (int)size);
            ConfigCache configCache = ConfigCache.this;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv.iterator();
            while (iterator.hasNext()) {
                int element$iv;
                int it = element$iv = ((IntIterator)iterator).nextInt();
                boolean bl = false;
                ResourceLocation id = buffer.readResourceLocation();
                ConfigEntry<?> configEntry = configCache.getEntries().get(id);
                if (configEntry == null || (configEntry = configEntry.getSyncType()) == null || (configEntry = (ConfigEntry.ConfigSyncData)configEntry.decode(buffer)) == null) continue;
                ConfigEntry<?> entry = configEntry;
                boolean bl2 = false;
                Intrinsics.checkNotNull((Object)id);
                decodedEntries.put(id, entry);
            }
            return new ConfigSync(decodedEntries);
        }

        @NotNull
        public Runnable handle(@NotNull ConfigSync message) {
            Intrinsics.checkNotNullParameter((Object)message, (String)"message");
            return () -> ConfigSyncType.handle$lambda$3(message);
        }

        public void encode(@NotNull ConfigSync message, @NotNull RegistryFriendlyByteBuf buffer) {
            Intrinsics.checkNotNullParameter((Object)message, (String)"message");
            Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
            buffer.writeVarInt(message.getEntries().size());
            message.getEntries().forEach((arg_0, arg_1) -> ConfigSyncType.encode$lambda$5((arg_0, arg_1) -> ConfigSyncType.encode$lambda$4(buffer, arg_0, arg_1), arg_0, arg_1));
        }

        private static final void handle$lambda$3(ConfigSync $message) {
            Iterable $this$forEach$iv = $message.getEntries().values();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                ConfigEntry.ConfigSyncData it = (ConfigEntry.ConfigSyncData)element$iv;
                boolean bl = false;
                it.set();
            }
        }

        private static final Unit encode$lambda$4(RegistryFriendlyByteBuf $buffer, ResourceLocation id, ConfigEntry.ConfigSyncData entry) {
            Intrinsics.checkNotNullParameter((Object)id, (String)"id");
            Intrinsics.checkNotNullParameter((Object)entry, (String)"entry");
            $buffer.writeResourceLocation(id);
            entry.encode($buffer);
            return Unit.INSTANCE;
        }

        private static final void encode$lambda$5(Function2 $tmp0, Object p0, Object p1) {
            $tmp0.invoke(p0, p1);
        }
    }
}

