/*
 * Decompiled with CFR 0.152.
 */
package raccoonman.terrablenderfix.mixin;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.util.Pair;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.world.level.levelgen.SurfaceRules;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import raccoonman.terrablenderfix.TBFixCommon;
import terrablender.api.SurfaceRuleManager;

@Mixin(value={SurfaceRuleManager.class})
class MixinSurfaceRuleManager {
    @Shadow(remap=false)
    private static Map<SurfaceRuleManager.RuleCategory, Map<String, SurfaceRules.RuleSource>> surfaceRules;
    @Shadow(remap=false)
    private static Map<SurfaceRuleManager.RuleCategory, SurfaceRules.RuleSource> defaultSurfaceRules;
    @Shadow(remap=false)
    private static Map<SurfaceRuleManager.RuleCategory, Map<SurfaceRuleManager.RuleStage, List<Pair<Integer, SurfaceRules.RuleSource>>>> defaultSurfaceRuleInjections;

    MixinSurfaceRuleManager() {
    }

    @Overwrite(remap=false)
    public static SurfaceRules.RuleSource getNamespacedRules(SurfaceRuleManager.RuleCategory category, SurfaceRules.RuleSource datapackRules) {
        TBFixCommon.LOGGER.info("Optimizing surface rules");
        ImmutableList.Builder builder = ImmutableList.builder();
        builder.addAll(surfaceRules.get(category).values());
        builder.add((Object)datapackRules);
        return SurfaceRules.sequence((SurfaceRules.RuleSource[])((SurfaceRules.RuleSource[])builder.build().toArray(SurfaceRules.RuleSource[]::new)));
    }

    @Inject(at={@At(value="TAIL")}, method={"<clinit>"}, remap=false)
    private static void clinit(CallbackInfo callback) {
        surfaceRules = new LinkedHashMap<SurfaceRuleManager.RuleCategory, Map<String, SurfaceRules.RuleSource>>(surfaceRules);
        defaultSurfaceRules = new LinkedHashMap<SurfaceRuleManager.RuleCategory, SurfaceRules.RuleSource>(defaultSurfaceRules);
        defaultSurfaceRuleInjections = new LinkedHashMap<SurfaceRuleManager.RuleCategory, Map<SurfaceRuleManager.RuleStage, List<Pair<Integer, SurfaceRules.RuleSource>>>>(defaultSurfaceRuleInjections);
        TBFixCommon.LOGGER.info("Changed SurfaceRuleManager map type");
    }
}

