/*
 * Decompiled with CFR 0.152.
 */
package net.swedz.tesseract.neoforge.compat.mi.component;

import aztech.modern_industrialization.machines.MachineBlockEntity;
import aztech.modern_industrialization.machines.MachineComponent;
import aztech.modern_industrialization.machines.components.CasingComponent;
import aztech.modern_industrialization.machines.components.DropableComponent;
import aztech.modern_industrialization.machines.components.OverdriveComponent;
import aztech.modern_industrialization.machines.components.RedstoneControlComponent;
import aztech.modern_industrialization.machines.components.UpgradeComponent;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.ItemStack;
import net.swedz.tesseract.neoforge.compat.mi.api.ComponentStackHolder;

public class SimpleItemStackComponent
implements MachineComponent,
DropableComponent,
ComponentStackHolder {
    protected final String stackTagKey;
    protected final UpdatedCallback callback;
    protected ItemStack stack = ItemStack.EMPTY;

    public SimpleItemStackComponent(String stackTagKey, UpdatedCallback callback) {
        this.stackTagKey = stackTagKey;
        this.callback = callback;
    }

    public SimpleItemStackComponent(String stackTagKey) {
        this(stackTagKey, null);
    }

    @Override
    public ItemStack getStack() {
        return this.stack;
    }

    @Override
    public void setStack(ItemStack stack) {
        ItemStack previous = this.stack;
        this.stack = stack;
        if (this.callback != null) {
            this.callback.onUpdate(previous, stack);
        }
    }

    public void setStackServer(MachineBlockEntity machine, ItemStack stack) {
        ItemStack previous = this.stack;
        this.stack = stack;
        machine.setChanged();
        machine.sync();
        if (this.callback != null) {
            this.callback.onUpdate(previous, stack);
        }
    }

    public ItemStack getDrop() {
        return this.stack;
    }

    public void writeNbt(CompoundTag tag, HolderLookup.Provider registries) {
        tag.put(this.stackTagKey, this.stack.saveOptional(registries));
    }

    public void readNbt(CompoundTag tag, HolderLookup.Provider registries, boolean isUpgradingMachine) {
        this.stack = ItemStack.parseOptional((HolderLookup.Provider)registries, (CompoundTag)tag.getCompound(this.stackTagKey));
    }

    public void writeClientNbt(CompoundTag tag, HolderLookup.Provider registries) {
    }

    public void readClientNbt(CompoundTag tag, HolderLookup.Provider registries) {
    }

    public static SimpleItemStackComponent wrap(final RedstoneControlComponent component) {
        return new SimpleItemStackComponent("redstoneModuleStack"){

            @Override
            public ItemStack getStack() {
                return component.getDrop();
            }

            @Override
            public void setStackServer(MachineBlockEntity machine, ItemStack stack) {
                component.setStackServer(machine, stack);
            }

            @Override
            public ItemStack getDrop() {
                return component.getDrop();
            }

            @Override
            public void writeNbt(CompoundTag tag, HolderLookup.Provider registries) {
                component.writeNbt(tag, registries);
            }

            @Override
            public void readNbt(CompoundTag tag, HolderLookup.Provider registries, boolean isUpgradingMachine) {
                component.readNbt(tag, registries, isUpgradingMachine);
            }

            @Override
            public void writeClientNbt(CompoundTag tag, HolderLookup.Provider registries) {
                component.writeClientNbt(tag, registries);
            }

            @Override
            public void readClientNbt(CompoundTag tag, HolderLookup.Provider registries) {
                component.readClientNbt(tag, registries);
            }
        };
    }

    public static SimpleItemStackComponent wrap(final UpgradeComponent component) {
        return new SimpleItemStackComponent("upgradesItemStack"){

            @Override
            public ItemStack getStack() {
                return component.getDrop();
            }

            @Override
            public void setStackServer(MachineBlockEntity machine, ItemStack stack) {
                component.setStackServer(machine, stack);
            }

            @Override
            public ItemStack getDrop() {
                return component.getDrop();
            }

            @Override
            public void writeNbt(CompoundTag tag, HolderLookup.Provider registries) {
                component.writeNbt(tag, registries);
            }

            @Override
            public void readNbt(CompoundTag tag, HolderLookup.Provider registries, boolean isUpgradingMachine) {
                component.readNbt(tag, registries, isUpgradingMachine);
            }

            @Override
            public void writeClientNbt(CompoundTag tag, HolderLookup.Provider registries) {
                component.writeClientNbt(tag, registries);
            }

            @Override
            public void readClientNbt(CompoundTag tag, HolderLookup.Provider registries) {
                component.readClientNbt(tag, registries);
            }
        };
    }

    public static SimpleItemStackComponent wrap(final OverdriveComponent component) {
        return new SimpleItemStackComponent("overdriveModuleStack"){

            @Override
            public ItemStack getStack() {
                return component.getDrop();
            }

            @Override
            public void setStackServer(MachineBlockEntity machine, ItemStack stack) {
                component.setStackServer(machine, stack);
            }

            @Override
            public ItemStack getDrop() {
                return component.getDrop();
            }

            @Override
            public void writeNbt(CompoundTag tag, HolderLookup.Provider registries) {
                component.writeNbt(tag, registries);
            }

            @Override
            public void readNbt(CompoundTag tag, HolderLookup.Provider registries, boolean isUpgradingMachine) {
                component.readNbt(tag, registries, isUpgradingMachine);
            }

            @Override
            public void writeClientNbt(CompoundTag tag, HolderLookup.Provider registries) {
                component.writeClientNbt(tag, registries);
            }

            @Override
            public void readClientNbt(CompoundTag tag, HolderLookup.Provider registries) {
                component.readClientNbt(tag, registries);
            }
        };
    }

    public static SimpleItemStackComponent wrap(final CasingComponent component) {
        return new SimpleItemStackComponent("casing"){

            @Override
            public ItemStack getStack() {
                return component.getDrop();
            }

            @Override
            public void setStackServer(MachineBlockEntity machine, ItemStack stack) {
                component.setCasingServer(machine, stack);
            }

            @Override
            public ItemStack getDrop() {
                return component.getDrop();
            }

            @Override
            public void writeNbt(CompoundTag tag, HolderLookup.Provider registries) {
                component.writeNbt(tag, registries);
            }

            @Override
            public void readNbt(CompoundTag tag, HolderLookup.Provider registries, boolean isUpgradingMachine) {
                component.readNbt(tag, registries, isUpgradingMachine);
            }

            @Override
            public void writeClientNbt(CompoundTag tag, HolderLookup.Provider registries) {
                component.writeClientNbt(tag, registries);
            }

            @Override
            public void readClientNbt(CompoundTag tag, HolderLookup.Provider registries) {
                component.readClientNbt(tag, registries);
            }
        };
    }

    public static interface UpdatedCallback {
        public void onUpdate(ItemStack var1, ItemStack var2);
    }
}

