/*
 * Decompiled with CFR 0.152.
 */
package net.swedz.tesseract.neoforge.compat.mi.component.craft.multiplied;

import java.util.function.Supplier;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.swedz.tesseract.neoforge.Tesseract;
import net.swedz.tesseract.neoforge.compat.mi.component.craft.multiplied.MultipliedCrafterComponent;

public abstract class EuCostTransformer {
    private final ResourceLocation id;

    public EuCostTransformer(ResourceLocation id) {
        this.id = id;
    }

    public String getTranslationKey() {
        return "eu_cost_transformer.%s.%s".formatted(this.id.getNamespace(), this.id.getPath());
    }

    public MutableComponent text() {
        return Component.translatable((String)this.getTranslationKey());
    }

    public abstract long transform(MultipliedCrafterComponent var1, long var2, long var4);

    public long transform(MultipliedCrafterComponent crafter, long eu) {
        return this.transform(crafter, eu, 0L);
    }

    public static final class PercentageEuCostTransformer
    extends EuCostTransformer {
        private final Supplier<Float> percentage;

        public PercentageEuCostTransformer(Supplier<Float> percentage) {
            super(Tesseract.id("percentage"));
            this.percentage = percentage;
        }

        @Override
        public long transform(MultipliedCrafterComponent crafter, long eu, long bonusEu) {
            return (long)((float)(eu * (long)crafter.getRecipeMultiplier() + bonusEu) * this.percentage.get().floatValue());
        }

        @Override
        public MutableComponent text() {
            return Component.translatable((String)this.getTranslationKey(), (Object[])new Object[]{(int)(this.percentage.get().floatValue() * 100.0f)});
        }
    }
}

