/*
 * Decompiled with CFR 0.152.
 */
package net.swedz.tesseract.neoforge.compat.mi.guicomponent.slotpanel;

import aztech.modern_industrialization.MI;
import aztech.modern_industrialization.MITooltips;
import aztech.modern_industrialization.inventory.HackySlot;
import aztech.modern_industrialization.inventory.SlotGroup;
import aztech.modern_industrialization.machines.MachineBlockEntity;
import aztech.modern_industrialization.machines.components.CasingComponent;
import aztech.modern_industrialization.machines.components.OverdriveComponent;
import aztech.modern_industrialization.machines.components.RedstoneControlComponent;
import aztech.modern_industrialization.machines.components.UpgradeComponent;
import aztech.modern_industrialization.machines.gui.GuiComponent;
import aztech.modern_industrialization.machines.gui.GuiComponentServer;
import aztech.modern_industrialization.machines.gui.MachineGuiParameters;
import aztech.modern_industrialization.machines.guicomponents.SlotPanel;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import io.netty.buffer.ByteBuf;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.swedz.tesseract.neoforge.Tesseract;
import net.swedz.tesseract.neoforge.compat.mi.component.SimpleItemStackComponent;

public final class ModularSlotPanel
implements GuiComponentServer<Params, Data> {
    public static final GuiComponentServer.Type<Params, Data> TYPE = new GuiComponentServer.Type(Tesseract.id("modular_slot_panel"), Params.STREAM_CODEC, Data.STREAM_CODEC);
    private static final Map<ResourceLocation, Slot> SLOTS = Maps.newHashMap();
    public static final ResourceLocation REDSTONE_MODULE = ModularSlotPanel.registerMISlot("redstone_module", SlotPanel.SlotType.REDSTONE_MODULE);
    public static final ResourceLocation UPGRADES = ModularSlotPanel.registerMISlot("upgrades", SlotPanel.SlotType.UPGRADES);
    public static final ResourceLocation CASINGS = ModularSlotPanel.registerMISlot("casings", SlotPanel.SlotType.CASINGS);
    public static final ResourceLocation OVERDRIVE_MODULE = ModularSlotPanel.registerMISlot("overdrive_module", SlotPanel.SlotType.OVERDRIVE_MODULE);
    private final MachineBlockEntity machine;
    private final int offsetY;
    private final List<Slot> slots = Lists.newArrayList();
    private final List<Supplier<Integer>> stackLimits = Lists.newArrayList();
    private final List<SimpleItemStackComponent> slotComponents = Lists.newArrayList();

    public static ResourceLocation registerSlot(ResourceLocation id, SlotGroup group, int stackLimit, Predicate<ItemStack> insertionChecker, ResourceLocation atlas, int u, int v, Supplier<Component> tooltip) {
        if (SLOTS.containsKey(id)) {
            throw new IllegalArgumentException("There is already a slot type registered for the id '" + id.toString() + "'");
        }
        SLOTS.put(id, new Slot(id, group, stackLimit, insertionChecker, atlas, u, v, tooltip));
        return id;
    }

    private static ResourceLocation registerMISlot(String name, SlotPanel.SlotType slotType) {
        return ModularSlotPanel.registerSlot(MI.id((String)name), slotType.group, slotType.slotLimit, slotType.insertionChecker, null, slotType.u, slotType.v, () -> slotType.tooltip.text().withStyle(MITooltips.DEFAULT_STYLE));
    }

    static Slot getSlot(ResourceLocation id) {
        Slot slot = SLOTS.get(id);
        if (slot == null) {
            throw new IllegalArgumentException("Could not find slot with id '" + id.toString() + "'");
        }
        return slot;
    }

    static int getSlotX(MachineGuiParameters guiParameters) {
        return guiParameters.backgroundWidth + 6;
    }

    static int getSlotY(int index) {
        return 19 + index * 20;
    }

    public ModularSlotPanel(MachineBlockEntity machine, int offsetY) {
        this.machine = machine;
        this.offsetY = offsetY;
    }

    private ModularSlotPanel with(Slot slot, Supplier<Integer> stackLimit, SimpleItemStackComponent component) {
        this.slots.add(slot);
        this.stackLimits.add(stackLimit);
        this.slotComponents.add(component);
        return this;
    }

    public ModularSlotPanel with(ResourceLocation slotId, Supplier<Integer> stackLimit, SimpleItemStackComponent component) {
        return this.with(ModularSlotPanel.getSlot(slotId), stackLimit, component);
    }

    private ModularSlotPanel with(Slot slot, SimpleItemStackComponent component) {
        return this.with(slot, slot::stackLimit, component);
    }

    public ModularSlotPanel with(ResourceLocation slotId, SimpleItemStackComponent component) {
        return this.with(ModularSlotPanel.getSlot(slotId), component);
    }

    public ModularSlotPanel withRedstoneModule(RedstoneControlComponent component) {
        return this.with(REDSTONE_MODULE, SimpleItemStackComponent.wrap(component));
    }

    public ModularSlotPanel withUpgrades(UpgradeComponent component) {
        return this.with(UPGRADES, SimpleItemStackComponent.wrap(component));
    }

    public ModularSlotPanel withCasings(CasingComponent component) {
        return this.with(CASINGS, SimpleItemStackComponent.wrap(component));
    }

    public ModularSlotPanel withOverdrive(OverdriveComponent component) {
        return this.with(OVERDRIVE_MODULE, SimpleItemStackComponent.wrap(component));
    }

    public Params getParams() {
        return new Params(this.offsetY, this.slots);
    }

    public Data extractData() {
        return new Data(this.stackLimits.stream().map(Supplier::get).toList());
    }

    public GuiComponentServer.Type<Params, Data> getType() {
        return TYPE;
    }

    public void setupMenu(GuiComponent.MenuFacade menu) {
        for (int i = 0; i < this.slots.size(); ++i) {
            final Slot slot = this.slots.get(i);
            final Supplier<Integer> stackLimit = this.stackLimits.get(i);
            final SimpleItemStackComponent component = this.slotComponents.get(i);
            menu.addSlotToMenu((net.minecraft.world.inventory.Slot)new HackySlot(ModularSlotPanel.getSlotX(this.machine.guiParams), ModularSlotPanel.getSlotY(i)){

                protected ItemStack getRealStack() {
                    return component.getStack().copy();
                }

                protected void setRealStack(ItemStack stack) {
                    component.setStackServer(ModularSlotPanel.this.machine, stack);
                }

                public boolean mayPlace(ItemStack stack) {
                    return slot.insertionChecker().test(stack);
                }

                public int getMaxStackSize() {
                    return (Integer)stackLimit.get();
                }
            }, slot.group());
        }
    }

    public record Slot(ResourceLocation id, SlotGroup group, int stackLimit, Predicate<ItemStack> insertionChecker, ResourceLocation atlas, int u, int v, Supplier<Component> tooltip) {
        public static final StreamCodec<ByteBuf, Slot> STREAM_CODEC = ResourceLocation.STREAM_CODEC.map(ModularSlotPanel::getSlot, Slot::id);
    }

    public record Params(int offsetY, List<Slot> slots) {
        public static final StreamCodec<ByteBuf, Params> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.INT, Params::offsetY, (StreamCodec)Slot.STREAM_CODEC.apply(ByteBufCodecs.list()), Params::slots, Params::new);
    }

    public record Data(List<Integer> stackLimits) {
        public static final StreamCodec<ByteBuf, Data> STREAM_CODEC = ByteBufCodecs.VAR_INT.apply(ByteBufCodecs.list()).map(Data::new, Data::stackLimits);
    }
}

