/*
 * Decompiled with CFR 0.152.
 */
package net.swedz.tesseract.neoforge.compat.mi.material.property;

import aztech.modern_industrialization.nuclear.IsotopeParams;
import aztech.modern_industrialization.nuclear.NeutronBehaviour;
import net.swedz.tesseract.neoforge.compat.mi.material.property.MIMaterialProperties;
import net.swedz.tesseract.neoforge.material.Material;

public class IsotopeFuel
extends IsotopeParams {
    public final int maxTemp;
    public final double neutronsMultiplication;
    public final double directEnergyFactor;
    public final int tempLimitLow;
    public final int tempLimitHigh;

    public IsotopeFuel(double thermalAbsorbProba, double thermalScatterings, int maxTemp, int tempLimitLow, int tempLimitHigh, double neutronsMultiplication, double directEnergyFactor) {
        super(thermalAbsorbProba, NeutronBehaviour.reduceCrossProba((double)thermalAbsorbProba, (double)0.1), thermalScatterings, NeutronBehaviour.reduceCrossProba((double)thermalScatterings, (double)0.5));
        this.maxTemp = maxTemp;
        this.neutronsMultiplication = neutronsMultiplication;
        this.directEnergyFactor = directEnergyFactor;
        this.tempLimitLow = tempLimitLow;
        this.tempLimitHigh = tempLimitHigh;
    }

    public static IsotopeFuel mix(IsotopeFuel a, IsotopeFuel b, double factor) {
        factor = 1.0 - factor;
        double newThermalAbsorptionProba = NeutronBehaviour.probaFromCrossSection((double)IsotopeFuel.mix(a.thermalAbsorption, b.thermalAbsorption, factor));
        double newScatteringProba = NeutronBehaviour.probaFromCrossSection((double)IsotopeFuel.mix(a.thermalScattering, b.thermalScattering, factor));
        double newNeutronMultiplicationFactor = IsotopeFuel.mix(a.neutronsMultiplication, b.neutronsMultiplication, factor);
        double totalEnergy = IsotopeFuel.mix(a.neutronsMultiplication * (1.0 + a.directEnergyFactor), b.neutronsMultiplication * (1.0 + b.directEnergyFactor), factor);
        int newMaxTemp = (int)IsotopeFuel.mix(a.maxTemp, b.maxTemp, factor);
        int newTempLimitLow = (int)IsotopeFuel.mix(a.tempLimitLow, b.tempLimitLow, factor);
        int newTempLimitHigh = (int)IsotopeFuel.mix(a.tempLimitHigh, b.tempLimitHigh, factor);
        double newDirectEnergyFactor = totalEnergy / newNeutronMultiplicationFactor - 1.0;
        return new IsotopeFuel(newThermalAbsorptionProba, newScatteringProba, newMaxTemp, newTempLimitLow, newTempLimitHigh, newNeutronMultiplicationFactor, newDirectEnergyFactor);
    }

    public static IsotopeFuel mix(Material a, Material b, double factor) {
        return IsotopeFuel.mix(a.getOrThrow(MIMaterialProperties.ISOTOPE), b.getOrThrow(MIMaterialProperties.ISOTOPE), factor);
    }

    private static double mix(double a, double b, double r) {
        return r * a + (1.0 - r) * b;
    }
}

