/*
 * Decompiled with CFR 0.152.
 */
package net.swedz.tesseract.neoforge.helper;

import com.google.common.base.Suppliers;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.Util;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderStateShard;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.RegisterRenderBuffersEvent;
import net.swedz.tesseract.neoforge.Tesseract;

@EventBusSubscriber(modid="tesseract_api", value={Dist.CLIENT})
public final class CubeOverlayRenderHelper {
    private static final RenderType CUBE_OVERLAY = CubeOverlayRenderHelper.createRenderType("cube_overlay", Tesseract.id("textures/block/cube_overlay.png"));
    private static final Function<Direction, BakedQuad> SIDE_QUADS = Util.memoize(CubeOverlayRenderHelper::createQuadForFace);
    private static final Supplier<BakedQuad[]> CUBE_QUADS = Suppliers.memoize(() -> {
        BakedQuad[] quads = new BakedQuad[6];
        int index = 0;
        for (Direction direction : Direction.values()) {
            quads[index++] = SIDE_QUADS.apply(direction);
        }
        return quads;
    });

    public static RenderType createRenderType(String name, ResourceLocation texture) {
        return RenderType.create((String)name, (VertexFormat)DefaultVertexFormat.BLOCK, (VertexFormat.Mode)VertexFormat.Mode.QUADS, (int)65536, (boolean)false, (boolean)false, (RenderType.CompositeState)RenderType.CompositeState.builder().setShaderState(RenderStateShard.POSITION_COLOR_TEX_LIGHTMAP_SHADER).setTransparencyState(RenderStateShard.TRANSLUCENT_TRANSPARENCY).setTextureState((RenderStateShard.EmptyTextureStateShard)new RenderStateShard.TextureStateShard(texture, false, false)).setLightmapState(RenderStateShard.LIGHTMAP).createCompositeState(false));
    }

    @SubscribeEvent
    private static void registerRenderBuffers(RegisterRenderBuffersEvent event) {
        event.registerRenderBuffer(CUBE_OVERLAY);
    }

    private static BakedQuad createQuadForFace(Direction direction) {
        float[][] fArrayArray;
        switch (direction) {
            default: {
                throw new MatchException(null, null);
            }
            case UP: {
                float[][] fArrayArray2 = new float[4][];
                fArrayArray2[0] = new float[]{0.0f, 1.0f, 0.0f};
                fArrayArray2[1] = new float[]{0.0f, 1.0f, 1.0f};
                fArrayArray2[2] = new float[]{1.0f, 1.0f, 1.0f};
                fArrayArray = fArrayArray2;
                fArrayArray2[3] = new float[]{1.0f, 1.0f, 0.0f};
                break;
            }
            case DOWN: {
                float[][] fArrayArray3 = new float[4][];
                fArrayArray3[0] = new float[]{0.0f, 0.0f, 0.0f};
                fArrayArray3[1] = new float[]{1.0f, 0.0f, 0.0f};
                fArrayArray3[2] = new float[]{1.0f, 0.0f, 1.0f};
                fArrayArray = fArrayArray3;
                fArrayArray3[3] = new float[]{0.0f, 0.0f, 1.0f};
                break;
            }
            case NORTH: {
                float[][] fArrayArray4 = new float[4][];
                fArrayArray4[0] = new float[]{0.0f, 0.0f, 0.0f};
                fArrayArray4[1] = new float[]{0.0f, 1.0f, 0.0f};
                fArrayArray4[2] = new float[]{1.0f, 1.0f, 0.0f};
                fArrayArray = fArrayArray4;
                fArrayArray4[3] = new float[]{1.0f, 0.0f, 0.0f};
                break;
            }
            case SOUTH: {
                float[][] fArrayArray5 = new float[4][];
                fArrayArray5[0] = new float[]{0.0f, 0.0f, 1.0f};
                fArrayArray5[1] = new float[]{1.0f, 0.0f, 1.0f};
                fArrayArray5[2] = new float[]{1.0f, 1.0f, 1.0f};
                fArrayArray = fArrayArray5;
                fArrayArray5[3] = new float[]{0.0f, 1.0f, 1.0f};
                break;
            }
            case WEST: {
                float[][] fArrayArray6 = new float[4][];
                fArrayArray6[0] = new float[]{0.0f, 0.0f, 0.0f};
                fArrayArray6[1] = new float[]{0.0f, 0.0f, 1.0f};
                fArrayArray6[2] = new float[]{0.0f, 1.0f, 1.0f};
                fArrayArray = fArrayArray6;
                fArrayArray6[3] = new float[]{0.0f, 1.0f, 0.0f};
                break;
            }
            case EAST: {
                float[][] fArrayArray7 = new float[4][];
                fArrayArray7[0] = new float[]{1.0f, 0.0f, 0.0f};
                fArrayArray7[1] = new float[]{1.0f, 1.0f, 0.0f};
                fArrayArray7[2] = new float[]{1.0f, 1.0f, 1.0f};
                fArrayArray = fArrayArray7;
                fArrayArray7[3] = new float[]{1.0f, 0.0f, 1.0f};
            }
        }
        float[][] positions = fArrayArray;
        return new BakedQuad(CubeOverlayRenderHelper.createVertexData(positions, direction), 0, direction, null, false);
    }

    private static int[] createVertexData(float[][] positions, Direction direction) {
        int[] vertexData = new int[positions.length * 8];
        for (int i = 0; i < positions.length; ++i) {
            float x = positions[i][0];
            float y = positions[i][1];
            float z = positions[i][2];
            float u = switch (direction.getAxis()) {
                default -> throw new MatchException(null, null);
                case Direction.Axis.X -> z;
                case Direction.Axis.Y, Direction.Axis.Z -> x;
            };
            float v = switch (direction.getAxis()) {
                default -> throw new MatchException(null, null);
                case Direction.Axis.X, Direction.Axis.Z -> y;
                case Direction.Axis.Y -> z;
            };
            int index = i * 8;
            vertexData[index] = Float.floatToRawIntBits(x);
            vertexData[index + 1] = Float.floatToRawIntBits(y);
            vertexData[index + 2] = Float.floatToRawIntBits(z);
            vertexData[index + 3] = -1;
            vertexData[index + 4] = Float.floatToRawIntBits(u);
            vertexData[index + 5] = Float.floatToRawIntBits(v);
            vertexData[index + 6] = 0;
            vertexData[index + 7] = 0;
        }
        return vertexData;
    }

    public static void render(PoseStack matrices, VertexConsumer consumer, Direction direction, float red, float green, float blue, float alpha, int packedLight, int overlay) {
        BakedQuad overlayQuad = SIDE_QUADS.apply(direction);
        consumer.putBulkData(matrices.last(), overlayQuad, red, green, blue, alpha, packedLight, overlay);
    }

    public static void render(PoseStack matrices, VertexConsumer consumer, Direction direction, float red, float green, float blue, float alpha, int overlay) {
        CubeOverlayRenderHelper.render(matrices, consumer, direction, red, green, blue, alpha, 0xF000F0, overlay);
    }

    public static void render(PoseStack matrices, VertexConsumer consumer, Direction direction, float red, float green, float blue, int overlay) {
        CubeOverlayRenderHelper.render(matrices, consumer, direction, red, green, blue, 1.0f, 0xF000F0, overlay);
    }

    public static void render(PoseStack matrices, MultiBufferSource bufferSource, float red, float green, float blue, float alpha, int packedLight, int overlay) {
        VertexConsumer consumer = bufferSource.getBuffer(CUBE_OVERLAY);
        for (BakedQuad overlayQuad : CUBE_QUADS.get()) {
            consumer.putBulkData(matrices.last(), overlayQuad, red, green, blue, alpha, packedLight, overlay);
        }
    }

    public static void render(PoseStack matrices, MultiBufferSource bufferSource, float red, float green, float blue, float alpha, int overlay) {
        CubeOverlayRenderHelper.render(matrices, bufferSource, red, green, blue, alpha, 0xF000F0, overlay);
    }

    public static void render(PoseStack matrices, MultiBufferSource bufferSource, float red, float green, float blue, int overlay) {
        CubeOverlayRenderHelper.render(matrices, bufferSource, red, green, blue, 1.0f, 0xF000F0, overlay);
    }
}

