/*
 * Decompiled with CFR 0.152.
 */
package net.swedz.tesseract.neoforge.helper.datagen;

import com.google.common.collect.Maps;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.nio.file.Path;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackType;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import net.swedz.tesseract.neoforge.api.Assert;

public abstract class FontDatagenProvider
implements DataProvider {
    private final PackOutput output;
    private final ExistingFileHelper existingFileHelper;
    private final String modId;
    private final String fontName;
    private final Map<Character, BitmapCharacterProvider> providers = Maps.newHashMap();

    public FontDatagenProvider(PackOutput output, ExistingFileHelper existingFileHelper, String modId, String fontName) {
        this.output = output;
        this.existingFileHelper = existingFileHelper;
        this.modId = modId;
        this.fontName = fontName;
    }

    protected abstract void addCharacters();

    public void addBitmap(char character, ResourceLocation file, int height, int ascent) {
        Assert.noneNull(Character.valueOf(character), file);
        file = file.withPath(arg_0 -> FontDatagenProvider.lambda$addBitmap$0("%s.png", arg_0));
        Assert.that(this.existingFileHelper.exists(file.withPrefix("textures/"), PackType.CLIENT_RESOURCES), "Texture %s does not exist in any known resource pack".formatted(file));
        if (this.providers.put(Character.valueOf(character), new BitmapCharacterProvider(file, height, ascent)) != null) {
            throw new IllegalStateException("Duplicate character " + character);
        }
    }

    public void addBitmap(char character, ResourceLocation file) {
        this.addBitmap(character, file, 7, 7);
    }

    public CompletableFuture<?> run(CachedOutput cachedOutput) {
        this.addCharacters();
        return !this.providers.isEmpty() ? this.save(cachedOutput, this.output.getOutputFolder(PackOutput.Target.RESOURCE_PACK).resolve(this.modId).resolve("font").resolve(this.fontName + ".json")) : CompletableFuture.allOf(new CompletableFuture[0]);
    }

    private CompletableFuture<?> save(CachedOutput cachedOutput, Path target) {
        JsonObject json = new JsonObject();
        JsonArray providersArray = new JsonArray();
        for (Map.Entry<Character, BitmapCharacterProvider> entry : this.providers.entrySet()) {
            Character character = entry.getKey();
            BitmapCharacterProvider provider = entry.getValue();
            providersArray.add((JsonElement)provider.toJson(character.charValue()));
        }
        json.add("providers", (JsonElement)providersArray);
        return DataProvider.saveStable((CachedOutput)cachedOutput, (JsonElement)json, (Path)target);
    }

    public String getName() {
        return "Font: " + this.fontName + " for mod: " + this.modId;
    }

    private static /* synthetic */ String lambda$addBitmap$0(String rec$, Object xva$0) {
        return "%s.png".formatted(xva$0);
    }

    private static final class BitmapCharacterProvider {
        private final ResourceLocation file;
        private final int height;
        private final int ascent;

        public BitmapCharacterProvider(ResourceLocation file, int height, int ascent) {
            this.file = file;
            this.height = height;
            this.ascent = ascent;
        }

        public JsonObject toJson(char character) {
            JsonObject json = new JsonObject();
            json.addProperty("type", "bitmap");
            json.addProperty("file", this.file.toString());
            json.addProperty("height", (Number)this.height);
            json.addProperty("ascent", (Number)this.ascent);
            JsonArray chars = new JsonArray();
            chars.add(String.valueOf(character));
            json.add("chars", (JsonElement)chars);
            return json;
        }
    }
}

