/*
 * Decompiled with CFR 0.152.
 */
package net.swedz.tesseract.neoforge.localizedlistener;

import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.neoforged.bus.api.Event;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.server.ServerStoppedEvent;
import net.swedz.tesseract.neoforge.localizedlistener.LocalizedListener;
import net.swedz.tesseract.neoforge.localizedlistener.LocalizedListenerMultiMap;

public abstract class LocalizedListeners {
    private LocalizedListenerMultiMap listeners = new LocalizedListenerMultiMap();

    public final void init() {
        NeoForge.EVENT_BUS.addListener(ServerStoppedEvent.class, __ -> {
            if (this.listeners.size() != 0) {
                this.listeners = new LocalizedListenerMultiMap();
            }
        });
        this.initListeners();
    }

    protected abstract void initListeners();

    public <E extends Event> LocalizedListener<E> register(Level level, ChunkPos chunk, Class<E> listenerClass, LocalizedListener<E> listener) {
        this.listeners.add((LevelAccessor)level, chunk, listenerClass, listener);
        return listener;
    }

    public <E extends Event> LocalizedListener<E> register(Level level, Iterable<ChunkPos> chunks, Class<E> listenerClass, LocalizedListener<E> listener) {
        for (ChunkPos chunk : chunks) {
            this.register(level, chunk, listenerClass, listener);
        }
        return listener;
    }

    public <E extends Event> void unregister(Level level, ChunkPos chunk, Class<E> listenerClass, LocalizedListener<E> listener) {
        this.listeners.remove((LevelAccessor)level, chunk, listenerClass, listener);
    }

    public <E extends Event> void unregister(Level level, Iterable<ChunkPos> chunks, Class<E> listenerClass, LocalizedListener<E> listener) {
        for (ChunkPos chunk : chunks) {
            this.unregister(level, chunk, listenerClass, listener);
        }
    }

    protected <E extends Event> void withListener(EventPriority priority, Class<E> listenerClass, Predicate<E> condition, Function<E, Level> level, Function<E, ChunkPos> chunk) {
        NeoForge.EVENT_BUS.addListener(priority, listenerClass, event -> {
            Set listenerInstances;
            if (condition.test(event) && (listenerInstances = this.listeners.get((LevelAccessor)level.apply(event), (ChunkPos)chunk.apply(event), listenerClass)) != null) {
                for (LocalizedListener<Event> localizedListener : listenerInstances) {
                    localizedListener.on((Event)event);
                }
            }
        });
    }

    protected <E extends Event> void withListener(Class<E> listenerClass, Predicate<E> condition, Function<E, Level> level, Function<E, ChunkPos> chunk) {
        this.withListener(EventPriority.NORMAL, listenerClass, condition, level, chunk);
    }
}

