/*
 * Decompiled with CFR 0.152.
 */
package net.swedz.tesseract.neoforge.registry.holder;

import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.neoforged.neoforge.registries.DeferredRegister;
import net.swedz.tesseract.neoforge.registry.common.CommonModelBuilders;
import net.swedz.tesseract.neoforge.registry.holder.BlockHolder;
import net.swedz.tesseract.neoforge.registry.holder.ItemHolder;

public class BlockWithItemHolder<BlockType extends Block, ItemType extends BlockItem>
extends BlockHolder<BlockType>
implements ItemLike {
    private final ItemHolder<ItemType> itemHolder;

    public BlockWithItemHolder(ResourceLocation location, String englishName, DeferredRegister.Blocks registerBlocks, Function<BlockBehaviour.Properties, BlockType> blockCreator, DeferredRegister.Items registerItems, BiFunction<Block, Item.Properties, ItemType> itemCreator) {
        super(location, englishName, registerBlocks, blockCreator);
        this.itemHolder = new ItemHolder<BlockItem>(location, englishName, registerItems, p -> (BlockItem)itemCreator.apply((Block)this.get(), (Item.Properties)p)).withModelBuilder(CommonModelBuilders::block);
    }

    public ItemHolder<ItemType> item() {
        return this.itemHolder;
    }

    public BlockWithItemHolder<BlockType, ItemType> item(Consumer<ItemHolder<ItemType>> consumer) {
        consumer.accept(this.itemHolder);
        return this;
    }

    @Override
    public BlockWithItemHolder<BlockType, ItemType> register() {
        this.guaranteeUnlocked();
        this.registerableBlock.register(this.identifier, DeferredRegister.Blocks::registerBlock);
        this.itemHolder.register();
        this.lock();
        return this;
    }

    public Item asItem() {
        return this.itemHolder.asItem();
    }
}

